/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.JSType;

final class TypeStringBuilder {
    private final StringBuilder builder = new StringBuilder();
    private final boolean isForAnnotations;
    private String indentation = "";

    TypeStringBuilder(boolean isForAnnotations) {
        this.isForAnnotations = isForAnnotations;
    }

    boolean isForAnnotations() {
        return this.isForAnnotations;
    }

    TypeStringBuilder append(String x) {
        this.builder.append(x);
        return this;
    }

    TypeStringBuilder append(JSType x) {
        x.appendTo(this);
        return this;
    }

    TypeStringBuilder appendAll(Iterable<?> elements, String separator) {
        boolean separate = false;
        for (Object e : elements) {
            if (separate) {
                this.append(separator);
            } else {
                separate = true;
            }
            if (e instanceof JSType) {
                this.append((JSType)e);
                continue;
            }
            this.append((String)e);
        }
        return this;
    }

    TypeStringBuilder appendNonNull(JSType type) {
        if (!(!this.isForAnnotations || !type.isObject() || type.isUnknownType() || type.isTemplateType() || type.isRecordType() || type.isFunctionType() || type.isUnionType() || type.isLiteralObject())) {
            this.append("!");
        }
        return this.append(type);
    }

    TypeStringBuilder breakLineAndIndent() {
        this.builder.append("\n").append(this.indentation);
        return this;
    }

    TypeStringBuilder indent(Runnable cb) {
        String lastIndent = this.indentation;
        this.indentation = lastIndent + "  ";
        cb.run();
        this.indentation = lastIndent;
        return this;
    }

    String build() {
        return this.builder.toString();
    }

    TypeStringBuilder cloneWithConfig() {
        TypeStringBuilder clone2 = new TypeStringBuilder(this.isForAnnotations);
        clone2.indentation = this.indentation;
        return clone2;
    }
}

