/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.compiler;

import dotty.tools.dotc.interfaces.Diagnostic;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.repl.AbstractFileClassLoader;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import org.openmole.core.compiler.CompositeClassLoader;
import org.openmole.core.compiler.Interpreter;
import org.openmole.core.compiler.Interpreter$CompilationError$;
import org.openmole.core.compiler.Interpreter$CompletionCandidate$;
import org.openmole.core.compiler.Interpreter$ErrorMessage$;
import org.openmole.core.compiler.Interpreter$ErrorPosition$;
import org.openmole.core.compiler.Interpreter$HeaderInfo$;
import org.openmole.core.compiler.Interpreter$RawCompiled$;
import org.openmole.core.compiler.repl.REPLDriver;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.pluginmanager.Activator$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.TmpDirectory$;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Interpreter$
implements Serializable {
    public static final Interpreter$CompilationError$ CompilationError;
    public static final Interpreter$ErrorMessage$ ErrorMessage;
    public static final Interpreter$ErrorPosition$ ErrorPosition;
    public static final Interpreter$CompletionCandidate$ CompletionCandidate;
    public static final Interpreter$HeaderInfo$ HeaderInfo;
    public static final Interpreter$RawCompiled$ RawCompiled;
    public static final Interpreter$ MODULE$;

    private Interpreter$() {
    }

    static {
        MODULE$ = new Interpreter$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Interpreter$.class);
    }

    public boolean isInterpretedClass(Class<?> c) {
        return c.getClassLoader() != null && AbstractFileClassLoader.class.isAssignableFrom(c.getClassLoader().getClass());
    }

    public String compilationMessage(List<Interpreter.ErrorMessage> errorMessages, String code, int lineOffset, Option<String> fullCode) {
        Tuple2 tuple2 = errorMessages.partition((Function1 & Serializable)e -> BoxesRunTime.unboxToBoolean((Object)e.position().map((Function1 & Serializable)_$1 -> _$1.line() < 0).getOrElse(Interpreter$::$anonfun$1$$anonfun$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 $1$ = tuple2;
        Tuple2 tuple22 = $1$;
        List importsErrors = (List)tuple22._1();
        List codeErrors = (List)tuple22._2();
        return (String)(codeErrors.nonEmpty() ? codeErrors.map((Function1 & Serializable)error -> this.readableErrorMessages$1(lineOffset, (Interpreter.ErrorMessage)error)).mkString("\n") + "\n" : "") + (String)(importsErrors.filter((Function1 & Serializable)_$2 -> _$2.error()).nonEmpty() ? "Error in imports header:\n" + importsErrors.filter((Function1 & Serializable)_$3 -> _$3.error()).map((Function1 & Serializable)error -> this.readableErrorMessages$1(lineOffset, (Interpreter.ErrorMessage)error)).mkString("\n") + "\n" : "") + StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Compiling code:\n        |" + code)) + this.fullCodePart$1(fullCode).getOrElse(Interpreter$::compilationMessage$$anonfun$5);
    }

    public int compilationMessage$default$3() {
        return 0;
    }

    public Option<String> compilationMessage$default$4() {
        return None$.MODULE$;
    }

    public Throwable errorMessagesToException(List<Interpreter.ErrorMessage> messages, String code) {
        return Interpreter$CompilationError$.MODULE$.apply(messages, code);
    }

    public Interpreter.HeaderInfo firstLine(String file) {
        return Interpreter$HeaderInfo$.MODULE$.apply(file);
    }

    public Interpreter.ErrorMessage diagnosticToErrorMessage(Diagnostic diagnostic) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(diagnostic.position());
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        if (None$.MODULE$.equals(option)) {
            return Interpreter$ErrorMessage$.MODULE$.apply(diagnostic.message(), diagnostic.message(), (Option<Interpreter.ErrorPosition>)None$.MODULE$, diagnostic.level() == 2);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            SourcePosition pos = (SourcePosition)some.value();
            int firstLine = 0;
            return Interpreter$ErrorMessage$.MODULE$.apply(this.decoratedMessage$2(pos, diagnostic), diagnostic.message(), (Option<Interpreter.ErrorPosition>)Some$.MODULE$.apply((Object)this.errorPos$1(pos, firstLine)), diagnostic.level() == 2);
        }
        throw new MatchError((Object)option);
    }

    public CompositeClassLoader classLoader(Function0<Seq<Bundle>> priorityBundles, Seq<File> jars) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])jars.toArray(ClassTag$.MODULE$.apply(File.class)));
        return new CompositeClassLoader((Seq<ClassLoader>)((Seq)((IterableOps)((IterableOps)((IterableOps)priorityBundles.apply()).map((Function1 & Serializable)_$4 -> org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(_$4).classLoader())).$plus$plus((IterableOnce)new .colon.colon((Object)new URLClassLoader((URL[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> _$5.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class))), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)PluginManager$.MODULE$.globalClassLoader(Interpreter.class), (List)Nil$.MODULE$))));
    }

    public Seq<String> classPath(Seq<Bundle> priorityBundles, Seq<File> jars) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])((BundleContext)Activator$.MODULE$.context().get()).getBundles());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$7 -> !org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(_$7).isSystem()));
        return (Seq)((SeqOps)((IterableOps)((IterableOps)((IterableOps)priorityBundles.map((Function1 & Serializable)b -> this.toPath$1((Bundle)b))).$plus$plus((IterableOnce)jars.map((Function1 & Serializable)_$6 -> _$6.getCanonicalPath()))).$plus$plus((IterableOnce)PluginManager$.MODULE$.bundlesForClass(this.getClass()).map((Function1 & Serializable)b -> this.toPath$1((Bundle)b)))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)b -> this.toPath$1((Bundle)b), ClassTag$.MODULE$.apply(String.class))))).distinct();
    }

    public Tuple2<REPLDriver, ClassLoader> driver(File classDirectory, Seq<Bundle> priorityBundles, Seq<File> jars, boolean quiet) {
        REPLDriver rEPLDriver;
        classDirectory.mkdirs();
        CompositeClassLoader classLoaderValue = this.classLoader((Function0<Seq<Bundle>>)((Function0 & Serializable)() -> Interpreter$.$anonfun$2(priorityBundles)), jars);
        Option option = Activator$.MODULE$.context();
        if (option instanceof Some) {
            Some some = (Some)option;
            Object object = Predef$.MODULE$.refArrayOps((Object[])new String[]{"-classpath", this.classPath(priorityBundles, jars).mkString(":"), "-d", classDirectory.getAbsolutePath()});
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)(quiet ? (SeqOps)new .colon.colon((Object)"-Xrepl-disable-display", (List)Nil$.MODULE$) : (SeqOps)Nil$.MODULE$), ClassTag$.MODULE$.apply(String.class)));
            REPLDriver rEPLDriver2 = new REPLDriver((String[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (IterableOnce)this.commonOptions$1(), ClassTag$.MODULE$.apply(String.class)), Console$.MODULE$.out(), (Option<ClassLoader>)Some$.MODULE$.apply((Object)classLoaderValue));
            rEPLDriver = rEPLDriver2;
        } else if (None$.MODULE$.equals(option)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])new String[]{"-classpath", System.getProperty("java.class.path"), "-d", classDirectory.getAbsolutePath()});
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)(quiet ? (SeqOps)new .colon.colon((Object)"-Xrepl-disable-display", (List)Nil$.MODULE$) : (SeqOps)Nil$.MODULE$), ClassTag$.MODULE$.apply(String.class)));
            REPLDriver rEPLDriver3 = new REPLDriver((String[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (IterableOnce)this.commonOptions$1(), ClassTag$.MODULE$.apply(String.class)), Console$.MODULE$.out(), (Option<ClassLoader>)Some$.MODULE$.apply((Object)classLoaderValue));
            rEPLDriver = rEPLDriver3;
        } else {
            throw new MatchError((Object)option);
        }
        REPLDriver driver = rEPLDriver;
        return Tuple2$.MODULE$.apply((Object)driver, (Object)classLoaderValue);
    }

    public Interpreter apply(Function0<Seq<Bundle>> priorityBundles, Seq<File> jars, boolean quiet, TmpDirectory newFile, FileService fileService) {
        File classDirectory = fileService.wrapRemoveOnGC(TmpDirectory$.MODULE$.newDirectory("classDirectory", TmpDirectory$.MODULE$.newDirectory$default$2(), newFile));
        Tuple2<REPLDriver, ClassLoader> tuple2 = this.driver(classDirectory, (Seq<Bundle>)((Seq)priorityBundles.apply()), jars, quiet);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<REPLDriver, ClassLoader> $3$ = tuple2;
        Tuple2<REPLDriver, ClassLoader> tuple22 = $3$;
        REPLDriver drv = (REPLDriver)((Object)tuple22._1());
        ClassLoader cl = (ClassLoader)tuple22._2();
        return new Interpreter(drv, classDirectory, cl);
    }

    public Nil$ apply$default$1() {
        return package$.MODULE$.Nil();
    }

    public Seq<File> apply$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean apply$default$3() {
        return true;
    }

    private static final String readableErrorMessages$1$$anonfun$2() {
        return "";
    }

    private final String readableErrorMessages$1(int lineOffset$1, Interpreter.ErrorMessage error) {
        return (String)error.position().map((Function1 & Serializable)p -> "(line " + (p.line() - lineOffset$1) + ") ").getOrElse(Interpreter$::readableErrorMessages$1$$anonfun$2) + error.decoratedMessage();
    }

    private static final boolean $anonfun$1$$anonfun$2() {
        return false;
    }

    private final Option fullCodePart$1(Option fullCode$1) {
        return fullCode$1.map((Function1 & Serializable)fc -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\nComplete encapsulated code was:\n          |" + fc)));
    }

    private static final String compilationMessage$$anonfun$5() {
        return "";
    }

    private final Interpreter.ErrorPosition errorPos$1(SourcePosition pos$1, int firstLine$1) {
        return Interpreter$ErrorPosition$.MODULE$.apply(pos$1.line() - firstLine$1, pos$1.startColumn(), pos$1.endColumn(), pos$1.column());
    }

    private final String decoratedMessage$2(SourcePosition pos$2, Diagnostic diagnostic$1) {
        int offsetOfError = pos$2.column();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(diagnostic$1.message() + "\n                |" + pos$2.lineContent() + "\n                |" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offsetOfError) + "^"));
    }

    private final String toPath$1(Bundle b) {
        return new URL(b.getLocation()).getPath();
    }

    private final Seq commonOptions$1() {
        return (Seq)((SeqOps)new .colon.colon((Object)"-language:postfixOps", (List)new .colon.colon((Object)"-language:implicitConversions", (List)new .colon.colon((Object)"-nowarn", (List)Nil$.MODULE$))));
    }

    private static final Seq $anonfun$2(Seq priorityBundles$1) {
        return priorityBundles$1;
    }
}

