/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.compiler;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.interfaces.Diagnostic;
import dotty.tools.repl.AbstractFileClassLoader;
import dotty.tools.repl.State;
import dotty.tools.repl.SyntaxErrors;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.openmole.core.compiler.Interpreter$;
import org.openmole.core.compiler.Interpreter$CompilationError$;
import org.openmole.core.compiler.Interpreter$CompletionCandidate$;
import org.openmole.core.compiler.Interpreter$ErrorMessage$;
import org.openmole.core.compiler.Interpreter$ErrorPosition$;
import org.openmole.core.compiler.Interpreter$HeaderInfo$;
import org.openmole.core.compiler.Interpreter$RawCompiled$;
import org.openmole.core.compiler.repl.REPLDriver;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.tool.file.package$;
import org.osgi.framework.Bundle;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;

public class Interpreter {
    private final REPLDriver driver;
    private final File classDirectory;
    private final ClassLoader classLoaderValue;

    public static Interpreter apply(Function0<Seq<Bundle>> function0, Seq<File> seq, boolean bl, TmpDirectory tmpDirectory, FileService fileService) {
        return Interpreter$.MODULE$.apply(function0, seq, bl, tmpDirectory, fileService);
    }

    public static Seq<String> classPath(Seq<Bundle> seq, Seq<File> seq2) {
        return Interpreter$.MODULE$.classPath(seq, seq2);
    }

    public static String compilationMessage(List<ErrorMessage> list, String string, int n, Option<String> option) {
        return Interpreter$.MODULE$.compilationMessage(list, string, n, option);
    }

    public static ErrorMessage diagnosticToErrorMessage(Diagnostic diagnostic) {
        return Interpreter$.MODULE$.diagnosticToErrorMessage(diagnostic);
    }

    public static Throwable errorMessagesToException(List<ErrorMessage> list, String string) {
        return Interpreter$.MODULE$.errorMessagesToException(list, string);
    }

    public static HeaderInfo firstLine(String string) {
        return Interpreter$.MODULE$.firstLine(string);
    }

    public static boolean isInterpretedClass(Class<?> clazz) {
        return Interpreter$.MODULE$.isInterpretedClass(clazz);
    }

    public static Nil$ apply$default$1() {
        return Interpreter$.MODULE$.apply$default$1();
    }

    public static Seq<File> apply$default$2() {
        return Interpreter$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return Interpreter$.MODULE$.apply$default$3();
    }

    public static int compilationMessage$default$3() {
        return Interpreter$.MODULE$.compilationMessage$default$3();
    }

    public static Option<String> compilationMessage$default$4() {
        return Interpreter$.MODULE$.compilationMessage$default$4();
    }

    public Interpreter(REPLDriver driver, File classDirectory, ClassLoader classLoaderValue) {
        this.driver = driver;
        this.classDirectory = classDirectory;
        this.classLoaderValue = classLoaderValue;
    }

    public REPLDriver driver() {
        return this.driver;
    }

    public File classDirectory() {
        return this.classDirectory;
    }

    public ClassLoader classLoaderValue() {
        return this.classLoaderValue;
    }

    public State initialState() {
        return this.driver().initialState();
    }

    public Object eval(String code) {
        return this.compile(code).apply();
    }

    public Function0<Object> compile(String code) {
        RawCompiled compiled = this.dottyCompile(code, this.dottyCompile$default$2());
        return (Function0 & Serializable)() -> this.run(compiled)._1();
    }

    public RawCompiled dottyCompile(String code, State state) {
        RawCompiled rawCompiled;
        Interpreter interpreter = this;
        synchronized (interpreter) {
            Either either;
            Tuple2 c;
            Serializable compiled;
            Serializable serializable = compiled = this.driver().justCompile(code, state);
            if (serializable instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)serializable;
                c = tuple2;
                either = (Either)c._1();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    List diagnostics = (List)left.value();
                    throw Interpreter$.MODULE$.errorMessagesToException((List<ErrorMessage>)diagnostics.map((Function1 & Serializable)diagnostic -> Interpreter$.MODULE$.diagnosticToErrorMessage((Diagnostic)diagnostic)), code);
                }
                if (!(either instanceof Right)) {
                    throw new MatchError((Object)either);
                }
            } else {
                if (serializable instanceof SyntaxErrors) {
                    SyntaxErrors syntaxErrors;
                    SyntaxErrors errors = syntaxErrors = (SyntaxErrors)serializable;
                    throw Interpreter$.MODULE$.errorMessagesToException((List<ErrorMessage>)errors.errors().map((Function1 & Serializable)diagnostic -> Interpreter$.MODULE$.diagnosticToErrorMessage((Diagnostic)diagnostic)), code);
                }
                throw new MatchError((Object)serializable);
            }
            Right right = (Right)either;
            rawCompiled = Interpreter$RawCompiled$.MODULE$.apply((Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State>)c, this.classDirectory());
        }
        return rawCompiled;
    }

    public State dottyCompile$default$2() {
        return this.initialState();
    }

    public Tuple2<Object, State> run(RawCompiled c) {
        State runResult = this.driver().justRun(c.compiled());
        return Tuple2$.MODULE$.apply(this.getResult$1(c, runResult), (Object)runResult);
    }

    public Vector<CompletionCandidate> completion(String code, int position, State state) {
        Vector vector;
        Interpreter interpreter = this;
        synchronized (interpreter) {
            vector = this.driver().completions(position, code, state).map((Function1 & Serializable)c -> Interpreter$CompletionCandidate$.MODULE$.apply(c.label(), (List<Symbols.Symbol>)c.symbols(), c.description())).toVector();
        }
        return vector;
    }

    public Class<?> resultClass(State state, Option<Object> index) {
        return Class.forName("rs$line$" + index.getOrElse(() -> Interpreter.resultClass$$anonfun$1(state)), true, (ClassLoader)this.classLoader(state.context()));
    }

    public Option<Object> resultClass$default$2() {
        return None$.MODULE$;
    }

    public AbstractFileClassLoader classLoader(Contexts.Context context) {
        return this.driver().rederingValue().classLoader(context);
    }

    public void close() {
        package$.MODULE$.FileDecorator(this.classDirectory()).recursiveDelete();
    }

    private final Object getResult$1(RawCompiled c$1, State state) {
        if (state.valIndex() > ((State)c$1.compiled()._2()).valIndex()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.resultClass(state, this.resultClass$default$2()).getDeclaredMethods());
            Method m = (Method)ArrayOps$.MODULE$.head$extension(object);
            return m.invoke(null, new Object[0]);
        }
        return BoxedUnit.UNIT;
    }

    private static final int resultClass$$anonfun$1(State state$1) {
        return state$1.objectIndex();
    }

    public static class CompilationError
    extends Exception
    implements Product {
        private final List<ErrorMessage> errorMessages;
        private final String code;

        public static CompilationError apply(List<ErrorMessage> list, String string) {
            return Interpreter$CompilationError$.MODULE$.apply(list, string);
        }

        public static CompilationError fromProduct(Product product) {
            return Interpreter$CompilationError$.MODULE$.fromProduct(product);
        }

        public static CompilationError unapply(CompilationError compilationError) {
            return Interpreter$CompilationError$.MODULE$.unapply(compilationError);
        }

        public CompilationError(List<ErrorMessage> errorMessages, String code) {
            this.errorMessages = errorMessages;
            this.code = code;
            super(Interpreter$.MODULE$.compilationMessage(errorMessages, code, Interpreter$.MODULE$.compilationMessage$default$3(), Interpreter$.MODULE$.compilationMessage$default$4()));
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 533730470, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            CompilationError compilationError;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompilationError)) return false;
            CompilationError compilationError2 = compilationError = (CompilationError)object;
            List<ErrorMessage> list = this.errorMessages();
            List<ErrorMessage> list2 = compilationError2.errorMessages();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string = this.code();
            String string2 = compilationError2.code();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!compilationError2.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CompilationError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CompilationError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "errorMessages";
            }
            if (1 == n2) {
                return "code";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<ErrorMessage> errorMessages() {
            return this.errorMessages;
        }

        public String code() {
            return this.code;
        }

        public CompilationError copy(List<ErrorMessage> errorMessages, String code) {
            return new CompilationError(errorMessages, code);
        }

        public List<ErrorMessage> copy$default$1() {
            return this.errorMessages();
        }

        public String copy$default$2() {
            return this.code();
        }

        public List<ErrorMessage> _1() {
            return this.errorMessages();
        }

        public String _2() {
            return this.code();
        }
    }

    public static class CompletionCandidate
    implements Product,
    Serializable {
        private final String label;
        private final List<Symbols.Symbol> symbols;
        private final String description;

        public static CompletionCandidate apply(String string, List<Symbols.Symbol> list, String string2) {
            return Interpreter$CompletionCandidate$.MODULE$.apply(string, list, string2);
        }

        public static CompletionCandidate fromProduct(Product product) {
            return Interpreter$CompletionCandidate$.MODULE$.fromProduct(product);
        }

        public static CompletionCandidate unapply(CompletionCandidate completionCandidate) {
            return Interpreter$CompletionCandidate$.MODULE$.unapply(completionCandidate);
        }

        public CompletionCandidate(String label, List<Symbols.Symbol> symbols, String description) {
            this.label = label;
            this.symbols = symbols;
            this.description = description;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 990457516, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            CompletionCandidate completionCandidate;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompletionCandidate)) return false;
            CompletionCandidate completionCandidate2 = completionCandidate = (CompletionCandidate)object;
            String string = this.label();
            String string2 = completionCandidate2.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<Symbols.Symbol> list = this.symbols();
            List<Symbols.Symbol> list2 = completionCandidate2.symbols();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string3 = this.description();
            String string4 = completionCandidate2.description();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!completionCandidate2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompletionCandidate;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CompletionCandidate";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "label";
                }
                case 1: {
                    return "symbols";
                }
                case 2: {
                    return "description";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String label() {
            return this.label;
        }

        public List<Symbols.Symbol> symbols() {
            return this.symbols;
        }

        public String description() {
            return this.description;
        }

        public CompletionCandidate copy(String label, List<Symbols.Symbol> symbols, String description) {
            return new CompletionCandidate(label, symbols, description);
        }

        public String copy$default$1() {
            return this.label();
        }

        public List<Symbols.Symbol> copy$default$2() {
            return this.symbols();
        }

        public String copy$default$3() {
            return this.description();
        }

        public String _1() {
            return this.label();
        }

        public List<Symbols.Symbol> _2() {
            return this.symbols();
        }

        public String _3() {
            return this.description();
        }
    }

    public static class ErrorMessage
    implements Product,
    Serializable {
        private final String decoratedMessage;
        private final String rawMessage;
        private final Option<ErrorPosition> position;
        private final boolean error;

        public static ErrorMessage apply(String string, String string2, Option<ErrorPosition> option, boolean bl) {
            return Interpreter$ErrorMessage$.MODULE$.apply(string, string2, option, bl);
        }

        public static ErrorMessage fromProduct(Product product) {
            return Interpreter$ErrorMessage$.MODULE$.fromProduct(product);
        }

        public static ErrorMessage unapply(ErrorMessage errorMessage) {
            return Interpreter$ErrorMessage$.MODULE$.unapply(errorMessage);
        }

        public ErrorMessage(String decoratedMessage, String rawMessage, Option<ErrorPosition> position, boolean error) {
            this.decoratedMessage = decoratedMessage;
            this.rawMessage = rawMessage;
            this.position = position;
            this.error = error;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)1367556351);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.decoratedMessage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rawMessage()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.position()));
            n = Statics.mix((int)n, (int)(this.error() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            ErrorMessage errorMessage;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorMessage)) return false;
            ErrorMessage errorMessage2 = errorMessage = (ErrorMessage)object;
            if (this.error() != errorMessage2.error()) return false;
            String string = this.decoratedMessage();
            String string2 = errorMessage2.decoratedMessage();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.rawMessage();
            String string4 = errorMessage2.rawMessage();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<ErrorPosition> option = this.position();
            Option<ErrorPosition> option2 = errorMessage2.position();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!errorMessage2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ErrorMessage;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ErrorMessage";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "decoratedMessage";
                }
                case 1: {
                    return "rawMessage";
                }
                case 2: {
                    return "position";
                }
                case 3: {
                    return "error";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String decoratedMessage() {
            return this.decoratedMessage;
        }

        public String rawMessage() {
            return this.rawMessage;
        }

        public Option<ErrorPosition> position() {
            return this.position;
        }

        public boolean error() {
            return this.error;
        }

        public ErrorMessage copy(String decoratedMessage, String rawMessage, Option<ErrorPosition> position, boolean error) {
            return new ErrorMessage(decoratedMessage, rawMessage, position, error);
        }

        public String copy$default$1() {
            return this.decoratedMessage();
        }

        public String copy$default$2() {
            return this.rawMessage();
        }

        public Option<ErrorPosition> copy$default$3() {
            return this.position();
        }

        public boolean copy$default$4() {
            return this.error();
        }

        public String _1() {
            return this.decoratedMessage();
        }

        public String _2() {
            return this.rawMessage();
        }

        public Option<ErrorPosition> _3() {
            return this.position();
        }

        public boolean _4() {
            return this.error();
        }
    }

    public static class ErrorPosition
    implements Product,
    Serializable {
        private final int line;
        private final int start;
        private final int end;
        private final int point;

        public static ErrorPosition apply(int n, int n2, int n3, int n4) {
            return Interpreter$ErrorPosition$.MODULE$.apply(n, n2, n3, n4);
        }

        public static ErrorPosition fromProduct(Product product) {
            return Interpreter$ErrorPosition$.MODULE$.fromProduct(product);
        }

        public static ErrorPosition unapply(ErrorPosition errorPosition) {
            return Interpreter$ErrorPosition$.MODULE$.unapply(errorPosition);
        }

        public ErrorPosition(int line, int start, int end, int point) {
            this.line = line;
            this.start = start;
            this.end = end;
            this.point = point;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)654473009);
            n = Statics.mix((int)n, (int)this.line());
            n = Statics.mix((int)n, (int)this.start());
            n = Statics.mix((int)n, (int)this.end());
            n = Statics.mix((int)n, (int)this.point());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            ErrorPosition errorPosition;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ErrorPosition)) return false;
            ErrorPosition errorPosition2 = errorPosition = (ErrorPosition)object;
            if (this.line() != errorPosition2.line()) return false;
            if (this.start() != errorPosition2.start()) return false;
            if (this.end() != errorPosition2.end()) return false;
            if (this.point() != errorPosition2.point()) return false;
            if (!errorPosition2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ErrorPosition;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ErrorPosition";
        }

        public Object productElement(int n) {
            int n2 = n;
            return BoxesRunTime.boxToInteger((int)(switch (n2) {
                case 0 -> this._1();
                case 1 -> this._2();
                case 2 -> this._3();
                case 3 -> this._4();
                default -> throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }));
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "line";
                }
                case 1: {
                    return "start";
                }
                case 2: {
                    return "end";
                }
                case 3: {
                    return "point";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int line() {
            return this.line;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public int point() {
            return this.point;
        }

        public ErrorPosition copy(int line, int start, int end, int point) {
            return new ErrorPosition(line, start, end, point);
        }

        public int copy$default$1() {
            return this.line();
        }

        public int copy$default$2() {
            return this.start();
        }

        public int copy$default$3() {
            return this.end();
        }

        public int copy$default$4() {
            return this.point();
        }

        public int _1() {
            return this.line();
        }

        public int _2() {
            return this.start();
        }

        public int _3() {
            return this.end();
        }

        public int _4() {
            return this.point();
        }
    }

    public static class HeaderInfo
    implements Product,
    Serializable {
        private final String file;

        public static HeaderInfo apply(String string) {
            return Interpreter$HeaderInfo$.MODULE$.apply(string);
        }

        public static HeaderInfo fromProduct(Product product) {
            return Interpreter$HeaderInfo$.MODULE$.fromProduct(product);
        }

        public static HeaderInfo unapply(HeaderInfo headerInfo) {
            return Interpreter$HeaderInfo$.MODULE$.unapply(headerInfo);
        }

        public HeaderInfo(String file) {
            this.file = file;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1666697493, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            HeaderInfo headerInfo;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HeaderInfo)) return false;
            HeaderInfo headerInfo2 = headerInfo = (HeaderInfo)object;
            String string = this.file();
            String string2 = headerInfo2.file();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!headerInfo2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HeaderInfo;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HeaderInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "file";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String file() {
            return this.file;
        }

        public HeaderInfo copy(String file) {
            return new HeaderInfo(file);
        }

        public String copy$default$1() {
            return this.file();
        }

        public String _1() {
            return this.file();
        }
    }

    public static class RawCompiled
    implements Product,
    Serializable {
        private final Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> compiled;
        private final File classDirectory;

        public static RawCompiled apply(Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> tuple2, File file) {
            return Interpreter$RawCompiled$.MODULE$.apply(tuple2, file);
        }

        public static RawCompiled fromProduct(Product product) {
            return Interpreter$RawCompiled$.MODULE$.fromProduct(product);
        }

        public static RawCompiled unapply(RawCompiled rawCompiled) {
            return Interpreter$RawCompiled$.MODULE$.unapply(rawCompiled);
        }

        public RawCompiled(Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> compiled, File classDirectory) {
            this.compiled = compiled;
            this.classDirectory = classDirectory;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 1899896659, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            RawCompiled rawCompiled;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RawCompiled)) return false;
            RawCompiled rawCompiled2 = rawCompiled = (RawCompiled)object;
            Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> tuple2 = this.compiled();
            Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> tuple22 = rawCompiled2.compiled();
            if (tuple2 == null) {
                if (tuple22 != null) {
                    return false;
                }
            } else if (!tuple2.equals(tuple22)) return false;
            File file = this.classDirectory();
            File file2 = rawCompiled2.classDirectory();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!((Object)file).equals(file2)) return false;
            if (!rawCompiled2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RawCompiled;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RawCompiled";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "compiled";
            }
            if (1 == n2) {
                return "classDirectory";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> compiled() {
            return this.compiled;
        }

        public File classDirectory() {
            return this.classDirectory;
        }

        public RawCompiled copy(Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> compiled, File classDirectory) {
            return new RawCompiled(compiled, classDirectory);
        }

        public Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> copy$default$1() {
            return this.compiled();
        }

        public File copy$default$2() {
            return this.classDirectory();
        }

        public Tuple2<Either<List<dotty.tools.dotc.reporting.Diagnostic>, Tuple2<CompilationUnit, State>>, State> _1() {
            return this.compiled();
        }

        public File _2() {
            return this.classDirectory();
        }
    }
}

