/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.Ipv6AddressPlatform;
import java.io.Serializable;
import java.net.Inet6Address;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Ipv6Address
extends IpAddress
implements Ipv6AddressPlatform {
    private final byte[] bytes;

    public static Cidr<Ipv6Address> LinkLocalBlock() {
        return Ipv6Address$.MODULE$.LinkLocalBlock();
    }

    public static Ipv6Address Loopback() {
        return Ipv6Address$.MODULE$.Loopback();
    }

    public static Cidr<Ipv6Address> MappedV4Block() {
        return Ipv6Address$.MODULE$.MappedV4Block();
    }

    public static Ipv6Address MulticastRangeEnd() {
        return Ipv6Address$.MODULE$.MulticastRangeEnd();
    }

    public static Ipv6Address MulticastRangeStart() {
        return Ipv6Address$.MODULE$.MulticastRangeStart();
    }

    public static Ipv6Address SourceSpecificMulticastRangeEnd() {
        return Ipv6Address$.MODULE$.SourceSpecificMulticastRangeEnd();
    }

    public static Ipv6Address SourceSpecificMulticastRangeStart() {
        return Ipv6Address$.MODULE$.SourceSpecificMulticastRangeStart();
    }

    public static Cidr<Ipv6Address> UniqueLocalBlock() {
        return Ipv6Address$.MODULE$.UniqueLocalBlock();
    }

    public static Ipv6Address fromBigInt(BigInt bigInt) {
        return Ipv6Address$.MODULE$.fromBigInt(bigInt);
    }

    public static Option<Ipv6Address> fromBytes(byte[] byArray) {
        return Ipv6Address$.MODULE$.fromBytes(byArray);
    }

    public static Ipv6Address fromBytes(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        return Ipv6Address$.MODULE$.fromBytes(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16);
    }

    public static Ipv6Address fromInet6Address(Inet6Address inet6Address) {
        return Ipv6Address$.MODULE$.fromInet6Address(inet6Address);
    }

    public static Option<Ipv6Address> fromString(String string) {
        return Ipv6Address$.MODULE$.fromString(string);
    }

    public static Ipv6Address mask(int n) {
        return Ipv6Address$.MODULE$.mask(n);
    }

    public Ipv6Address(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public <A> A fold(Function1<Ipv4Address, A> v4, Function1<Ipv6Address, A> v6) {
        return (A)v6.apply((Object)this);
    }

    @Override
    public Ipv6Address transform(Function1<Ipv4Address, Ipv4Address> v4, Function1<Ipv6Address, Ipv6Address> v6) {
        return (Ipv6Address)v6.apply((Object)this);
    }

    @Override
    public String toDefaultString() {
        int idx;
        int[] fields = new int[8];
        boolean condensing = false;
        int condensedStart = -1;
        int maxCondensedStart = -1;
        int condensedLength = 0;
        int maxCondensedLength = 0;
        for (idx = 0; idx < 8; ++idx) {
            int field;
            int j = 2 * idx;
            fields[idx] = field = (0xFF & this.bytes()[j]) << 8 | 0xFF & this.bytes()[j + 1];
            if (field == 0) {
                if (!condensing) {
                    condensing = true;
                    condensedStart = idx;
                    condensedLength = 0;
                }
                ++condensedLength;
            } else {
                condensing = false;
            }
            if (condensedLength <= maxCondensedLength) continue;
            maxCondensedLength = condensedLength;
            maxCondensedStart = condensedStart;
        }
        if (maxCondensedLength == 1) {
            maxCondensedStart = -1;
        }
        scala.collection.mutable.StringBuilder str = new scala.collection.mutable.StringBuilder();
        idx = 0;
        while (idx < 8) {
            if (idx == maxCondensedStart) {
                str.append("::");
                idx += maxCondensedLength;
                continue;
            }
            String hextet = Integer.toString(fields[idx], 16);
            str.append(hextet);
            if (++idx >= 8 || idx == maxCondensedStart) continue;
            str.append(":");
        }
        return str.toString();
    }

    public String toUncondensedString() {
        scala.collection.mutable.StringBuilder str = new scala.collection.mutable.StringBuilder();
        int idx = 0;
        byte[] bytes = this.toBytes();
        while (idx < 16) {
            int field = (bytes[idx] & 0xFF) << 8 | bytes[idx + 1] & 0xFF;
            String hextet = StringOps$.MODULE$.format$extension("%04x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)field)}));
            str.append(hextet);
            if ((idx += 2) >= 15) continue;
            str.append(":");
        }
        return str.toString();
    }

    public String toMixedString() {
        byte[] bytes = this.toBytes();
        Object object = Predef$.MODULE$.byteArrayOps(bytes);
        Ipv4Address v4 = (Ipv4Address)Ipv4Address$.MODULE$.fromBytes((byte[])ArrayOps$.MODULE$.slice$extension(object, 12, 16)).get();
        bytes[12] = 0;
        bytes[13] = 1;
        bytes[14] = 0;
        bytes[15] = 1;
        String s2 = Ipv6Address$.MODULE$.com$comcast$ip4s$Ipv6Address$$$unsafeFromBytes(bytes).toString();
        String prefix = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(s2), 0, StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(s2)) - 3);
        return new StringBuilder(0).append(prefix).append(v4.toString()).toString();
    }

    @Override
    public String toUriString() {
        return new StringBuilder(2).append("[").append(this.toDefaultString()).append("]").toString();
    }

    @Override
    public Ipv6Address next() {
        return Ipv6Address$.MODULE$.fromBigInt(this.toBigInt().$plus(BigInt$.MODULE$.int2bigInt(1)));
    }

    @Override
    public Ipv6Address previous() {
        return Ipv6Address$.MODULE$.fromBigInt(this.toBigInt().$minus(BigInt$.MODULE$.int2bigInt(1)));
    }

    public BigInt toBigInt() {
        byte[] bs = this.bytes();
        ObjectRef result = ObjectRef.create((Object)package$.MODULE$.BigInt().apply(0));
        Object object = Predef$.MODULE$.byteArrayOps(bs);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(object)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            BigInt bigInt = ((BigInt)result$2.elem).$less$less(8).$bar(BigInt$.MODULE$.int2bigInt(0xFF & bs[i]));
            result$2.elem = bigInt;
            bigInt = null;
        });
        return (BigInt)result.elem;
    }

    @Override
    public boolean isMulticast() {
        return this.$greater$eq(Ipv6Address$.MODULE$.MulticastRangeStart()) && this.$less$eq(Ipv6Address$.MODULE$.MulticastRangeEnd());
    }

    @Override
    public boolean isSourceSpecificMulticast() {
        return this.$greater$eq(Ipv6Address$.MODULE$.SourceSpecificMulticastRangeStart()) && this.$less$eq(Ipv6Address$.MODULE$.SourceSpecificMulticastRangeEnd());
    }

    @Override
    public boolean isLoopback() {
        Ipv6Address ipv6Address = this;
        Ipv6Address ipv6Address2 = Ipv6Address$.MODULE$.Loopback();
        return !(ipv6Address == null ? ipv6Address2 != null : !((Object)ipv6Address).equals(ipv6Address2)) || this.isMappedV4() && this.collapseMappedV4().isLoopback();
    }

    @Override
    public boolean isLinkLocal() {
        return BoxesRunTime.unboxToBoolean((Object)Ipv6Address$.MODULE$.LinkLocalBlock().contains().apply((Object)this)) || this.isMappedV4() && this.collapseMappedV4().isLinkLocal();
    }

    @Override
    public boolean isPrivate() {
        return BoxesRunTime.unboxToBoolean((Object)Ipv6Address$.MODULE$.UniqueLocalBlock().contains().apply((Object)this)) || this.isMappedV4() && this.collapseMappedV4().isPrivate();
    }

    public Ipv6Address masked(Ipv6Address mask) {
        return Ipv6Address$.MODULE$.fromBigInt(this.toBigInt().$amp(mask.toBigInt()));
    }

    public Ipv6Address maskedLast(Ipv6Address mask) {
        return Ipv6Address$.MODULE$.fromBigInt(this.toBigInt().$amp(mask.toBigInt()).$bar(mask.toBigInt().unary_$tilde()));
    }
}

