/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Show;
import cats.kernel.Order;
import fs2.Stream;
import java.io.Serializable;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.ParseFailure;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.Status$ClientError$;
import org.http4s.Status$Informational$;
import org.http4s.Status$Redirection$;
import org.http4s.Status$ServerError$;
import org.http4s.Status$Successful$;
import org.http4s.util.Renderable;
import org.http4s.util.Writer;
import org.typelevel.vault.Vault;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple5;
import scala.collection.immutable.List;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;

public abstract class Status
implements Ordered<Status>,
Renderable,
Product,
Serializable {
    private final int code;
    private final String reason;
    private final boolean isEntityAllowed;
    private final ResponseClass responseClass;

    public static Status Accepted() {
        return Status$.MODULE$.Accepted();
    }

    public static Status AlreadyReported() {
        return Status$.MODULE$.AlreadyReported();
    }

    public static Status BadGateway() {
        return Status$.MODULE$.BadGateway();
    }

    public static Status BadRequest() {
        return Status$.MODULE$.BadRequest();
    }

    public static Status Conflict() {
        return Status$.MODULE$.Conflict();
    }

    public static Status Continue() {
        return Status$.MODULE$.Continue();
    }

    public static Status Created() {
        return Status$.MODULE$.Created();
    }

    public static Status EarlyHints() {
        return Status$.MODULE$.EarlyHints();
    }

    public static Status ExpectationFailed() {
        return Status$.MODULE$.ExpectationFailed();
    }

    public static Status FailedDependency() {
        return Status$.MODULE$.FailedDependency();
    }

    public static Status Forbidden() {
        return Status$.MODULE$.Forbidden();
    }

    public static Status Found() {
        return Status$.MODULE$.Found();
    }

    public static Status GatewayTimeout() {
        return Status$.MODULE$.GatewayTimeout();
    }

    public static Status Gone() {
        return Status$.MODULE$.Gone();
    }

    public static Status HttpVersionNotSupported() {
        return Status$.MODULE$.HttpVersionNotSupported();
    }

    public static Status IMUsed() {
        return Status$.MODULE$.IMUsed();
    }

    public static Status ImATeapot() {
        return Status$.MODULE$.ImATeapot();
    }

    public static Status InsufficientStorage() {
        return Status$.MODULE$.InsufficientStorage();
    }

    public static Status InternalServerError() {
        return Status$.MODULE$.InternalServerError();
    }

    public static Status LengthRequired() {
        return Status$.MODULE$.LengthRequired();
    }

    public static Status Locked() {
        return Status$.MODULE$.Locked();
    }

    public static Status LoopDetected() {
        return Status$.MODULE$.LoopDetected();
    }

    public static int MaxCode() {
        return Status$.MODULE$.MaxCode();
    }

    public static Status MethodNotAllowed() {
        return Status$.MODULE$.MethodNotAllowed();
    }

    public static int MinCode() {
        return Status$.MODULE$.MinCode();
    }

    public static Status MisdirectedRequest() {
        return Status$.MODULE$.MisdirectedRequest();
    }

    public static Status MovedPermanently() {
        return Status$.MODULE$.MovedPermanently();
    }

    public static Status MultiStatus() {
        return Status$.MODULE$.MultiStatus();
    }

    public static Status MultipleChoices() {
        return Status$.MODULE$.MultipleChoices();
    }

    public static Status NetworkAuthenticationRequired() {
        return Status$.MODULE$.NetworkAuthenticationRequired();
    }

    public static Status NoContent() {
        return Status$.MODULE$.NoContent();
    }

    public static Status NonAuthoritativeInformation() {
        return Status$.MODULE$.NonAuthoritativeInformation();
    }

    public static Status NotAcceptable() {
        return Status$.MODULE$.NotAcceptable();
    }

    public static Status NotExtended() {
        return Status$.MODULE$.NotExtended();
    }

    public static Status NotFound() {
        return Status$.MODULE$.NotFound();
    }

    public static Status NotImplemented() {
        return Status$.MODULE$.NotImplemented();
    }

    public static Status NotModified() {
        return Status$.MODULE$.NotModified();
    }

    public static Status Ok() {
        return Status$.MODULE$.Ok();
    }

    public static Status PartialContent() {
        return Status$.MODULE$.PartialContent();
    }

    public static Status PayloadTooLarge() {
        return Status$.MODULE$.PayloadTooLarge();
    }

    public static Status PaymentRequired() {
        return Status$.MODULE$.PaymentRequired();
    }

    public static Status PermanentRedirect() {
        return Status$.MODULE$.PermanentRedirect();
    }

    public static Status PreconditionFailed() {
        return Status$.MODULE$.PreconditionFailed();
    }

    public static Status PreconditionRequired() {
        return Status$.MODULE$.PreconditionRequired();
    }

    public static Status Processing() {
        return Status$.MODULE$.Processing();
    }

    public static Status ProxyAuthenticationRequired() {
        return Status$.MODULE$.ProxyAuthenticationRequired();
    }

    public static Status RangeNotSatisfiable() {
        return Status$.MODULE$.RangeNotSatisfiable();
    }

    public static Status RequestHeaderFieldsTooLarge() {
        return Status$.MODULE$.RequestHeaderFieldsTooLarge();
    }

    public static Status RequestTimeout() {
        return Status$.MODULE$.RequestTimeout();
    }

    public static Status ResetContent() {
        return Status$.MODULE$.ResetContent();
    }

    public static Status SeeOther() {
        return Status$.MODULE$.SeeOther();
    }

    public static Status ServiceUnavailable() {
        return Status$.MODULE$.ServiceUnavailable();
    }

    public static Status SwitchingProtocols() {
        return Status$.MODULE$.SwitchingProtocols();
    }

    public static Status TemporaryRedirect() {
        return Status$.MODULE$.TemporaryRedirect();
    }

    public static Status TooEarly() {
        return Status$.MODULE$.TooEarly();
    }

    public static Status TooManyRequests() {
        return Status$.MODULE$.TooManyRequests();
    }

    public static Status Unauthorized() {
        return Status$.MODULE$.Unauthorized();
    }

    public static Status UnavailableForLegalReasons() {
        return Status$.MODULE$.UnavailableForLegalReasons();
    }

    public static Status UnprocessableEntity() {
        return Status$.MODULE$.UnprocessableEntity();
    }

    public static Status UnsupportedMediaType() {
        return Status$.MODULE$.UnsupportedMediaType();
    }

    public static Status UpgradeRequired() {
        return Status$.MODULE$.UpgradeRequired();
    }

    public static Status UriTooLong() {
        return Status$.MODULE$.UriTooLong();
    }

    public static Status UseProxy() {
        return Status$.MODULE$.UseProxy();
    }

    public static Status VariantAlsoNegotiates() {
        return Status$.MODULE$.VariantAlsoNegotiates();
    }

    public static Status apply(int n) {
        return Status$.MODULE$.apply(n);
    }

    public static Status apply(int n, String string, boolean bl) {
        return Status$.MODULE$.apply(n, string, bl);
    }

    public static Either<ParseFailure, Status> fromInt(int n) {
        return Status$.MODULE$.fromInt(n);
    }

    public static Either<ParseFailure, Status> fromIntAndReason(int n, String string) {
        return Status$.MODULE$.fromIntAndReason(n, string);
    }

    public static Order<Status> http4sOrderForStatus() {
        return Status$.MODULE$.http4sOrderForStatus();
    }

    public static Show<Status> http4sShowForStatus() {
        return Status$.MODULE$.http4sShowForStatus();
    }

    public static List<Status> registered() {
        return Status$.MODULE$.registered();
    }

    public static String apply$default$2() {
        return Status$.MODULE$.apply$default$2();
    }

    public static boolean apply$default$3() {
        return Status$.MODULE$.apply$default$3();
    }

    public Status(int code, String reason, boolean isEntityAllowed) {
        this.code = code;
        this.reason = reason;
        this.isEntityAllowed = isEntityAllowed;
        Ordered.$init$((Ordered)this);
        this.responseClass = code < 200 ? Status$Informational$.MODULE$ : (code < 300 ? Status$Successful$.MODULE$ : (code < 400 ? Status$Redirection$.MODULE$ : (ResponseClass)(code < 500 ? Status$ClientError$.MODULE$ : Status$ServerError$.MODULE$)));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.code());
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Status)) return false;
        Status status = (Status)object;
        if (this.code() != status.code()) return false;
        if (!status.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Status;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Status";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToInteger((int)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "code";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int code() {
        return this.code;
    }

    public String reason() {
        return this.reason;
    }

    public boolean isEntityAllowed() {
        return this.isEntityAllowed;
    }

    public ResponseClass responseClass() {
        return this.responseClass;
    }

    public int compare(Status that) {
        return this.code() - that.code();
    }

    public boolean isSuccess() {
        return this.responseClass().isSuccess();
    }

    public Status withReason(String reason) {
        return Status$.MODULE$.apply(this.code(), reason, this.isEntityAllowed());
    }

    public String sanitizedReason() {
        return "";
    }

    @Override
    public Writer render(Writer writer) {
        return writer.$less$less(this.code()).$less$less(' ').$less$less(this.sanitizedReason());
    }

    public <F> Option<Response<F>> unapply(Response<F> msg) {
        Status status = msg.status();
        Status status2 = this;
        if (!(status != null ? !((Object)status).equals(status2) : status2 != null)) {
            return Some$.MODULE$.apply(msg);
        }
        return None$.MODULE$;
    }

    public int _1() {
        return this.code();
    }

    public static interface ResponseClass {
        public boolean isSuccess();

        public static Option unapply$(ResponseClass $this, Response resp) {
            return $this.unapply(resp);
        }

        default public <F> Option<Response<F>> unapply(Response<F> resp) {
            Option<Tuple5<Status, HttpVersion, Headers, Stream<F, Object>, Vault>> option;
            Response<F> response = resp;
            if (response != null && !(option = Response$.MODULE$.unapply(response)).isEmpty()) {
                Tuple5 tuple5 = (Tuple5)option.get();
                Status status = (Status)tuple5._1();
                ResponseClass responseClass = status.responseClass();
                ResponseClass responseClass2 = this;
                if (!(responseClass != null ? !responseClass.equals(responseClass2) : responseClass2 != null)) {
                    return Some$.MODULE$.apply(resp);
                }
            }
            return None$.MODULE$;
        }
    }
}

