/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio1;

import java.io.Serializable;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.OptionValue;
import org.http4s.blaze.channel.OptionValue$;
import org.http4s.blaze.channel.nio1.NIO1Channel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.runtime.BoxedUnit;

public final class NIO1ClientChannel
implements NIO1Channel {
    private final SocketChannel underlying;
    private final Function0<BoxedUnit> onClose;
    private final AtomicBoolean closed;
    private final SelectableChannel selectableChannel;

    public NIO1ClientChannel(SocketChannel underlying, Function0<BoxedUnit> onClose) {
        this.underlying = underlying;
        this.onClose = onClose;
        this.closed = new AtomicBoolean(false);
        this.selectableChannel = underlying;
    }

    @Override
    public SelectableChannel selectableChannel() {
        return this.selectableChannel;
    }

    public void configureBlocking(boolean block) {
        this.underlying.configureBlocking(block);
    }

    public SocketAddress getRemoteAddress() {
        return this.underlying.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.underlying.getLocalAddress();
    }

    public void configureOptions(ChannelOptions options) {
        options.options().foreach((Function1 & Serializable)x$1 -> {
            OptionValue optionValue = x$1;
            if (optionValue instanceof OptionValue) {
                OptionValue optionValue2 = OptionValue$.MODULE$.unapply(optionValue);
                SocketOption socketOption = optionValue2._1();
                Object t = optionValue2._2();
                SocketOption k = socketOption;
                Object v = t;
                return this.underlying.setOption(k, v);
            }
            throw new MatchError((Object)optionValue);
        });
    }

    public int read(ByteBuffer dst) {
        return this.underlying.read(dst);
    }

    public int write(ByteBuffer src) {
        return this.underlying.write(src);
    }

    public long write(ByteBuffer[] srcs) {
        return this.underlying.write(srcs);
    }

    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public void close() {
        try {
            this.underlying.close();
        }
        finally {
            if (this.closed.compareAndSet(false, true)) {
                this.onClose.apply$mcV$sp();
            }
        }
    }
}

