/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio2;

import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ByteBufferHead;
import org.http4s.blaze.channel.nio2.ClientChannelFactory$;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Option;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.control.NonFatal$;

public final class ClientChannelFactory {
    private final int bufferSize;
    private final Option<AsynchronousChannelGroup> group;
    public final ChannelOptions org$http4s$blaze$channel$nio2$ClientChannelFactory$$channelOptions;
    private final TickWheelExecutor scheduler;
    public final Duration org$http4s$blaze$channel$nio2$ClientChannelFactory$$connectTimeout;
    private final Logger logger;

    public static int $lessinit$greater$default$1() {
        return ClientChannelFactory$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<AsynchronousChannelGroup> $lessinit$greater$default$2() {
        return ClientChannelFactory$.MODULE$.$lessinit$greater$default$2();
    }

    public static ChannelOptions $lessinit$greater$default$3() {
        return ClientChannelFactory$.MODULE$.$lessinit$greater$default$3();
    }

    public static TickWheelExecutor $lessinit$greater$default$4() {
        return ClientChannelFactory$.MODULE$.$lessinit$greater$default$4();
    }

    public static Duration $lessinit$greater$default$5() {
        return ClientChannelFactory$.MODULE$.$lessinit$greater$default$5();
    }

    public ClientChannelFactory(int bufferSize, Option<AsynchronousChannelGroup> group, ChannelOptions channelOptions, TickWheelExecutor scheduler, Duration connectTimeout) {
        this.bufferSize = bufferSize;
        this.group = group;
        this.org$http4s$blaze$channel$nio2$ClientChannelFactory$$channelOptions = channelOptions;
        this.scheduler = scheduler;
        this.org$http4s$blaze$channel$nio2$ClientChannelFactory$$connectTimeout = connectTimeout;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.channel.nio2.ClientChannelFactory");
    }

    public ClientChannelFactory(int bufferSize, Option<AsynchronousChannelGroup> group, ChannelOptions channelOptions) {
        this(bufferSize, group, channelOptions, Execution$.MODULE$.scheduler(), (Duration)Duration$.MODULE$.Inf());
    }

    public Future<HeadStage<ByteBuffer>> connect(SocketAddress remoteAddress, int bufferSize) {
        Boolean bl;
        Promise p = Promise$.MODULE$.apply();
        try {
            AsynchronousSocketChannel ch = AsynchronousSocketChannel.open((AsynchronousChannelGroup)this.group.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Runnable onTimeout = new Runnable(remoteAddress, p, ch, this){
                private final SocketAddress remoteAddress$1;
                private final Promise p$1;
                private final AsynchronousSocketChannel ch$1;
                private final /* synthetic */ ClientChannelFactory $outer;
                {
                    this.remoteAddress$1 = remoteAddress$2;
                    this.p$1 = p$3;
                    this.ch$1 = ch$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    SocketTimeoutException exception = new SocketTimeoutException(new StringBuilder(58).append("An attempt to establish connection with ").append(this.remoteAddress$1).append(" timed out after ").append(this.$outer.org$http4s$blaze$channel$nio2$ClientChannelFactory$$connectTimeout).append(".").toString());
                    boolean finishedWithTimeout = this.p$1.tryFailure((Throwable)exception);
                    if (finishedWithTimeout) {
                        try {
                            this.ch$1.close();
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3 = (Throwable)option.get();
                            }
                            throw throwable;
                        }
                        return;
                    }
                }
            };
            Cancelable scheduledTimeout = this.scheduler.schedule(onTimeout, this.org$http4s$blaze$channel$nio2$ClientChannelFactory$$connectTimeout);
            CompletionHandler<Void, Null$> completionHandler = new CompletionHandler<Void, Null$>(p, scheduledTimeout, ch, bufferSize, this){
                private final Promise p$2;
                private final Cancelable scheduledTimeout$1;
                private final AsynchronousSocketChannel ch$2;
                private final int bufferSize$1;
                private final /* synthetic */ ClientChannelFactory $outer;
                {
                    this.p$2 = p$4;
                    this.scheduledTimeout$1 = scheduledTimeout$2;
                    this.ch$2 = ch$4;
                    this.bufferSize$1 = bufferSize$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void failed(Throwable exc, Null$ attachment) {
                    this.p$2.tryFailure(exc);
                    this.scheduledTimeout$1.cancel();
                }

                public void completed(Void result, Null$ attachment) {
                    this.$outer.org$http4s$blaze$channel$nio2$ClientChannelFactory$$channelOptions.applyToChannel(this.ch$2);
                    this.p$2.trySuccess((Object)new ByteBufferHead(this.ch$2, this.bufferSize$1));
                    this.scheduledTimeout$1.cancel();
                }
            };
            try {
                ch.connect(remoteAddress, null, completionHandler);
                bl = BoxedUnit.UNIT;
            }
            catch (IllegalArgumentException ex) {
                block10: {
                    try {
                        ch.close();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            Logger Logger_this = this.logger;
                            if (Logger_this.isErrorEnabled()) {
                                Logger_this.error("Failure occurred while closing channel.", e);
                            }
                            break block10;
                        }
                        throw throwable;
                    }
                }
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable4;
            Option option;
            Throwable throwable5 = throwable;
            if (throwable5 == null || (option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                throw throwable;
            }
            Throwable t = throwable4 = (Throwable)option.get();
            bl = BoxesRunTime.boxToBoolean((boolean)p.tryFailure(t));
        }
        return p.future();
    }

    public int connect$default$2() {
        return this.bufferSize;
    }
}

