/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FlowStrategy;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings$DefaultSettings$;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.SessionFlowControl;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.math.package$;

public class SessionFlowControlImpl
extends SessionFlowControl {
    public final SessionCore org$http4s$blaze$http$http2$SessionFlowControlImpl$$session;
    private final FlowStrategy flowStrategy;
    public final Logger org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound;

    public SessionFlowControlImpl(SessionCore session, FlowStrategy flowStrategy) {
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session = session;
        this.flowStrategy = flowStrategy;
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.SessionFlowControlImpl");
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow = Http2Settings$DefaultSettings$.MODULE$.INITIAL_WINDOW_SIZE();
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow = Http2Settings$DefaultSettings$.MODULE$.INITIAL_WINDOW_SIZE();
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound = 0;
    }

    public void onSessonBytesConsumed(int consumed) {
        int n = consumed;
        int sessionUpdate = this.flowStrategy.checkSession(this);
        if (0 < sessionUpdate) {
            this.sessionInboundAcked(sessionUpdate);
            this.sendSessionWindowUpdate(sessionUpdate);
            return;
        }
    }

    public void sendSessionWindowUpdate(int updateSize) {
        ByteBuffer frame = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().sessionWindowUpdate(updateSize);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(frame);
    }

    public void onStreamBytesConsumed(StreamFlowWindow stream, int consumed) {
        int n = consumed;
        FlowStrategy.Increment update = this.flowStrategy.checkStream(stream);
        if (0 < update.session()) {
            this.sessionInboundAcked(update.session());
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().sessionWindowUpdate(update.session()));
        }
        if (0 < update.stream()) {
            stream.streamInboundAcked(update.stream());
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().streamWindowUpdate(stream.streamId(), update.stream()));
            return;
        }
    }

    public void sendStreamWindowUpdate(int stream, int updateSize) {
        ByteBuffer frame = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().streamWindowUpdate(stream, updateSize);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(frame);
    }

    @Override
    public final StreamFlowWindow newStreamFlowWindow(int streamId) {
        Predef$.MODULE$.require(0 < streamId);
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(20).append("Created new stream: ").append(streamId).toString());
        }
        return new StreamFlowWindowImpl(this, streamId);
    }

    @Override
    public final int sessionInboundWindow() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow;
    }

    @Override
    public final boolean sessionInboundObserved(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(33).append("Observed ").append(count).append(" inbound session bytes. ").append(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString()).toString());
        }
        Predef$.MODULE$.require(0 <= count);
        if (this.sessionInboundWindow() < count) {
            return false;
        }
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow -= count;
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound += count;
        return true;
    }

    @Override
    public final void sessionInboundAcked(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(30).append("Acked ").append(count).append(" inbound session bytes. ").append(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString()).toString());
        }
        Predef$.MODULE$.require(0 <= count);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow += count;
    }

    @Override
    public final void sessionInboundConsumed(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(33).append("Consumed ").append(count).append(" inbound session bytes. ").append(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString()).toString());
        }
        Predef$.MODULE$.require(0 <= count);
        if (count > this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound) {
            String msg = new StringBuilder(53).append("Consumed more bytes (").append(count).append(") than had been accounted for (").append(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound).append(")").toString();
            throw new IllegalStateException(msg);
        }
        if (count > 0) {
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound -= count;
            this.onSessonBytesConsumed(count);
            return;
        }
    }

    @Override
    public final int sessionUnconsumedBytes() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound;
    }

    @Override
    public final int sessionOutboundWindow() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow;
    }

    @Override
    public final Option<Http2Exception> sessionOutboundAcked(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(36).append(count).append(" outbound session bytes were ACKed. ").append(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString()).toString());
        }
        if (count <= 0) {
            return Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Invalid session WINDOW_UPDATE: size <= 0."));
        }
        if (Integer.MAX_VALUE - this.sessionOutboundWindow() < count) {
            return Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway("Session flow control exceeded max window."));
        }
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow += count;
        return None$.MODULE$;
    }

    public String org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString() {
        return new StringBuilder(46).append("Session: {inbound: ").append(this.sessionInboundWindow()).append(", unconsumed: ").append(this.sessionUnconsumedBytes()).append(", outbound: ").append(this.sessionOutboundWindow()).append("}").toString();
    }

    public final class StreamFlowWindowImpl
    extends StreamFlowWindow {
        private final int streamId;
        private int _streamInboundWindow;
        private int _streamOutboundWindow;
        private int _streamUnconsumedInbound;
        private final /* synthetic */ SessionFlowControlImpl $outer;

        public StreamFlowWindowImpl(SessionFlowControlImpl $outer, int streamId) {
            this.streamId = streamId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this._streamInboundWindow = $outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.localSettings().initialWindowSize();
            this._streamOutboundWindow = $outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.remoteSettings().initialWindowSize();
            this._streamUnconsumedInbound = 0;
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        @Override
        public SessionFlowControl sessionFlowControl() {
            return this.$outer;
        }

        @Override
        public int streamUnconsumedBytes() {
            return this._streamUnconsumedInbound;
        }

        @Override
        public int streamOutboundWindow() {
            return this._streamOutboundWindow;
        }

        @Override
        public Option<Http2Exception> streamOutboundAcked(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(36).append("Stream(").append(this.streamId()).append(") had ").append(count).append(" outbound bytes ACKed. ").append(this.streamWindowString()).toString());
            }
            if (count <= 0) {
                return Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(43).append("Invalid stream (").append(this.streamId()).append(") WINDOW_UPDATE: size <= 0.").toString()));
            }
            if (Integer.MAX_VALUE - this.streamOutboundWindow() < count) {
                return Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().rst(this.streamId(), "Stream flow control exceeded max window."));
            }
            this._streamOutboundWindow += count;
            return None$.MODULE$;
        }

        @Override
        public Option<Http2Exception> remoteSettingsInitialWindowChange(int delta) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(45).append("Stream(").append(this.streamId()).append(") outbound window adjusted by ").append(delta).append(" bytes. ").append(this.streamWindowString()).toString());
            }
            if (Integer.MAX_VALUE - this.streamOutboundWindow() < delta) {
                return Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway(new StringBuilder(45).append("Flow control exceeded max window for stream ").append(this.streamId()).append(".").toString()));
            }
            this._streamOutboundWindow += delta;
            return None$.MODULE$;
        }

        @Override
        public int outboundRequest(int request2) {
            int withdrawal;
            block0: {
                Predef$.MODULE$.require(0 <= request2);
                withdrawal = package$.MODULE$.min(this.$outer.sessionOutboundWindow(), package$.MODULE$.min(request2, this.streamOutboundWindow()));
                this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow -= withdrawal;
                this._streamOutboundWindow -= withdrawal;
                Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
                if (!Logger_this.isTraceEnabled()) break block0;
                Logger_this.trace(new StringBuilder(51).append("Stream(").append(this.streamId()).append(") requested ").append(request2).append(" outbound bytes, ").append(withdrawal).append(" were granted. ").append(this.streamWindowString()).toString());
            }
            return withdrawal;
        }

        @Override
        public int streamInboundWindow() {
            return this._streamInboundWindow;
        }

        @Override
        public boolean inboundObserved(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(34).append("Stream(").append(this.streamId()).append(") observed ").append(count).append(" inbound bytes. ").append(this.streamWindowString()).toString());
            }
            Predef$.MODULE$.require(0 <= count);
            if (count > this.streamInboundWindow() || count > this.$outer.sessionInboundWindow()) {
                Logger Logger_this2 = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
                if (Logger_this2.isInfoEnabled()) {
                    Logger_this2.info(new StringBuilder(66).append("Stream(").append(this.streamId()).append(") observed ").append(count).append(" inbound bytes which overflowed inbound window. ").append(this.streamWindowString()).toString());
                }
                return false;
            }
            this._streamUnconsumedInbound += count;
            this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound += count;
            this._streamInboundWindow -= count;
            this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow -= count;
            return true;
        }

        @Override
        public void inboundConsumed(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(34).append("Stream(").append(this.streamId()).append(") consumed ").append(count).append(" inbound bytes. ").append(this.streamWindowString()).toString());
            }
            Predef$.MODULE$.require(0 <= count);
            Predef$.MODULE$.require(count <= this.streamUnconsumedBytes());
            Predef$.MODULE$.require(count <= this.$outer.sessionUnconsumedBytes());
            if (0 < count) {
                this._streamUnconsumedInbound -= count;
                this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound -= count;
                this.$outer.onSessonBytesConsumed(count);
                this.$outer.onStreamBytesConsumed(this, count);
                return;
            }
        }

        @Override
        public void streamInboundAcked(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(23).append("Stream(").append(this.streamId()).append(") ACKed ").append(count).append(" bytes. ").append(this.streamWindowString()).toString());
            }
            Predef$.MODULE$.require(0 <= count);
            this._streamInboundWindow += count;
        }

        private String streamWindowString() {
            return new StringBuilder(12).append(this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString()).append(", Stream(").append(this.streamId()).append("): ").append(new StringBuilder(37).append("{inbound: ").append(this.streamInboundWindow()).append(", unconsumed: ").append(this.streamUnconsumedBytes()).append(", outbound: ").append(this.streamOutboundWindow()).append("}").toString()).toString();
        }

        public final /* synthetic */ SessionFlowControlImpl org$http4s$blaze$http$http2$SessionFlowControlImpl$StreamFlowWindowImpl$$$outer() {
            return this.$outer;
        }
    }
}

