/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline.stages;

import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Execution$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public interface ByteToObjectStage<O>
extends MidStage<ByteBuffer, O> {
    public static void $init$(ByteToObjectStage $this) {
        $this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer_$eq(null);
    }

    public ByteBuffer org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer();

    public void org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer_$eq(ByteBuffer var1);

    public Seq<ByteBuffer> messageToBuffer(O var1);

    public Option<O> bufferToMessage(ByteBuffer var1);

    public int maxBufferSize();

    public static Future writeRequest$(ByteToObjectStage $this, Seq data) {
        return $this.writeRequest((Object)data);
    }

    @Override
    default public Future<BoxedUnit> writeRequest(Seq<O> data) {
        Future future;
        try {
            future = this.channelWrite((Seq)data.flatMap((Function1 & Serializable)in -> this.messageToBuffer(in)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Encoding failure", t);
                }
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    public static Future writeRequest$(ByteToObjectStage $this, Object data) {
        return $this.writeRequest(data);
    }

    @Override
    default public Future<BoxedUnit> writeRequest(O data) {
        Future future;
        try {
            future = this.channelWrite(this.messageToBuffer(data));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Encoding failure", t);
                }
                future = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return future;
    }

    public static Future readRequest$(ByteToObjectStage $this, int size) {
        return $this.readRequest(size);
    }

    @Override
    default public Future<O> readRequest(int size) {
        if (this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer() != null && this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().hasRemaining()) {
            Future future;
            block6: {
                try {
                    ByteBuffer slice = this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().slice();
                    Option<O> result = this.bufferToMessage(slice);
                    this.cleanBuffers(slice);
                    Option<O> option = result;
                    if (option instanceof Some) {
                        Object o = ((Some)option).value();
                        future = Future$.MODULE$.successful(o);
                        break block6;
                    }
                    if (None$.MODULE$.equals(option)) {
                        future = this.startReadDecode();
                        break block6;
                    }
                    throw new MatchError(option);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = (Throwable)option.get();
                        future = Future$.MODULE$.failed(t);
                    }
                    throw throwable;
                }
            }
            return future;
        }
        return this.startReadDecode();
    }

    private Future<O> startReadDecode() {
        Promise p = Promise$.MODULE$.apply();
        this.readAndDecodeLoop(p);
        return p.future();
    }

    private void readAndDecodeLoop(Promise<O> p) {
        this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object object;
                block9: {
                    ByteBuffer lineBuffer = (ByteBuffer)((Success)try_).value();
                    this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer_$eq(BufferTools$.MODULE$.concatBuffers(this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer(), lineBuffer));
                    try {
                        ByteBuffer slice = this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().slice();
                        Option<O> result = this.bufferToMessage(slice);
                        this.cleanBuffers(slice);
                        Option<O> option = result;
                        if (option instanceof Some) {
                            Object o = ((Some)option).value();
                            object = p.success(o);
                            break block9;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.readAndDecodeLoop(p);
                            object = BoxedUnit.UNIT;
                            break block9;
                        }
                        throw new MatchError(option);
                    }
                    catch (Throwable throwable) {
                        Throwable t;
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            t = throwable3 = (Throwable)option.get();
                            Logger Logger_this = this.logger();
                            if (Logger_this.isErrorEnabled()) {
                                Logger_this.error("Error during decode", t);
                            }
                        } else {
                            throw throwable;
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)p.tryFailure(t));
                    }
                }
                return object;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                return p.failure(t);
            }
            throw new MatchError((Object)try_);
        }, Execution$.MODULE$.trampoline());
    }

    private void cleanBuffers(ByteBuffer slice) {
        if (slice.position() > 0) {
            this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().position(this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().position() + slice.position());
        }
        if (this.maxBufferSize() > 0 && this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().remaining() > this.maxBufferSize()) {
            this.closePipeline((Option<Throwable>)Some$.MODULE$.apply((Object)new BufferOverflowException()));
            return;
        }
        if (!this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer().hasRemaining()) {
            this.org$http4s$blaze$pipeline$stages$ByteToObjectStage$$_decodeBuffer_$eq(null);
            return;
        }
    }
}

