/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline.stages.monitors;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.http4s.blaze.channel.SocketConnection;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.slf4j.Logger;
import scala.Function1;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ConnectionMonitor {
    public Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> wrapBuilder(Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> factory) {
        return (Function1 & Serializable)_$1 -> ((Future)factory.apply(_$1)).map((Function1 & Serializable)_$2 -> _$2.prepend(new ServerStatusStage()), Execution$.MODULE$.trampoline());
    }

    public abstract void connectionAccepted();

    public abstract void connectionClosed();

    public abstract void bytesInbound(long var1);

    public abstract void bytesOutBound(long var1);

    private static final /* synthetic */ int writeRequest$$anonfun$1(int i, ByteBuffer b) {
        return i + b.remaining();
    }

    public static /* bridge */ /* synthetic */ int org$http4s$blaze$pipeline$stages$monitors$ConnectionMonitor$ServerStatusStage$$_$writeRequest$$anonfun$adapted$1(Object i, Object b) {
        return ConnectionMonitor.writeRequest$$anonfun$1(BoxesRunTime.unboxToInt((Object)i), (ByteBuffer)b);
    }

    public class ServerStatusStage
    implements MidStage<ByteBuffer, ByteBuffer> {
        private Logger logger;
        private Head _prevStage;
        private Tail _nextStage;
        private final String name;
        private final AtomicBoolean cleaned;

        public ServerStatusStage() {
            if (ConnectionMonitor.this == null) {
                throw new NullPointerException();
            }
            Stage.$init$(this);
            Tail.$init$(this);
            Head.$init$(this);
            this.name = "ServerStatusStage";
            this.cleaned = new AtomicBoolean(false);
            Statics.releaseFence();
        }

        @Override
        public final Logger logger() {
            return this.logger;
        }

        @Override
        public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
            this.logger = x$0;
        }

        @Override
        public Head _prevStage() {
            return this._prevStage;
        }

        @Override
        public void _prevStage_$eq(Head x$1) {
            this._prevStage = x$1;
        }

        @Override
        public Tail _nextStage() {
            return this._nextStage;
        }

        @Override
        public void _nextStage_$eq(Tail x$1) {
            this._nextStage = x$1;
        }

        @Override
        public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
            Stage.inboundCommand$(this, cmd);
        }

        @Override
        public String name() {
            return this.name;
        }

        private void clearCount() {
            if (!this.cleaned.getAndSet(true)) {
                ConnectionMonitor.this.connectionClosed();
                return;
            }
        }

        @Override
        public void stageStartup() {
            ConnectionMonitor.this.connectionAccepted();
            Stage.stageStartup$(this);
        }

        @Override
        public void stageShutdown() {
            this.clearCount();
            this.cleaned.set(true);
            Stage.stageShutdown$(this);
        }

        @Override
        public Future<BoxedUnit> writeRequest(ByteBuffer data) {
            ConnectionMonitor.this.bytesOutBound(data.remaining());
            return this.channelWrite(data);
        }

        @Override
        public Future<BoxedUnit> writeRequest(Seq<ByteBuffer> data) {
            ConnectionMonitor.this.bytesOutBound(BoxesRunTime.unboxToInt((Object)data.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), ConnectionMonitor::org$http4s$blaze$pipeline$stages$monitors$ConnectionMonitor$ServerStatusStage$$_$writeRequest$$anonfun$adapted$1)));
            return this.channelWrite((Seq)data);
        }

        @Override
        public Future<ByteBuffer> readRequest(int size) {
            return this.channelRead(size, this.channelRead$default$2()).map((Function1 & Serializable)b -> {
                ConnectionMonitor.this.bytesInbound(b.remaining());
                return b;
            }, Execution$.MODULE$.directec());
        }

        public final /* synthetic */ ConnectionMonitor org$http4s$blaze$pipeline$stages$monitors$ConnectionMonitor$ServerStatusStage$$$outer() {
            return ConnectionMonitor.this;
        }
    }
}

