/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.syntax.GenTemporalOps_$;
import cats.effect.std.Dispatcher;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$OptionStreamOps$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers$;
import org.http4s.HttpVersion$;
import org.http4s.InvalidBodyException$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.http2.DataFrame;
import org.http4s.blaze.http.http2.DataFrame$;
import org.http4s.blaze.http.http2.HeadersFrame;
import org.http4s.blaze.http.http2.HeadersFrame$;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.PseudoHeaders$;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.Http2Writer;
import org.http4s.headers.Connection$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class Http2NodeStage<F>
implements TailStage<StreamFrame> {
    private Logger logger;
    private Head _prevStage;
    private final int streamId;
    private final Duration timeout;
    private final ExecutionContext executionContext;
    private final Function0<Vault> attributes;
    public final Function1<Request<F>, PartialFunction<Throwable, F>> org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler;
    private final Duration idleTimeout;
    private final TickWheelExecutor scheduler;
    public final Dispatcher<F> org$http4s$blaze$server$Http2NodeStage$$dispatcher;
    public final Async<F> org$http4s$blaze$server$Http2NodeStage$$F;
    private final Function1<Request<F>, F> runApp;
    private final Some<F> shutdownStageToken;
    public final Function1<Request<F>, F> org$http4s$blaze$server$Http2NodeStage$$raceTimeout;

    public Http2NodeStage(int streamId, Duration timeout, ExecutionContext executionContext, Function0<Vault> attributes, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Duration responseHeaderTimeout, Duration idleTimeout, TickWheelExecutor scheduler, Dispatcher<F> dispatcher, Async<F> F) {
        Function1 & Serializable intersect;
        this.streamId = streamId;
        this.timeout = timeout;
        this.executionContext = executionContext;
        this.attributes = attributes;
        this.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler = serviceErrorHandler;
        this.idleTimeout = idleTimeout;
        this.scheduler = scheduler;
        this.org$http4s$blaze$server$Http2NodeStage$$dispatcher = dispatcher;
        this.org$http4s$blaze$server$Http2NodeStage$$F = F;
        Stage.$init$(this);
        Tail.$init$(this);
        this.runApp = httpApp.run();
        this.shutdownStageToken = Some$.MODULE$.apply(F.delay((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }));
        Duration duration = responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            intersect = (Function1 & Serializable)req -> {
                Object object = package.temporal$.MODULE$.genTemporalOps_(this.runApp.apply(req));
                return GenTemporalOps_$.MODULE$.timeoutTo$extension(object, finite, F.pure(Response$.MODULE$.timeout()), (GenTemporal)F);
            };
        } else {
            intersect = this.runApp;
        }
        this.org$http4s$blaze$server$Http2NodeStage$$raceTimeout = intersect;
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String name() {
        return "Http2NodeStage";
    }

    @Override
    public void stageStartup() {
        Stage.stageStartup$(this);
        this.initIdleTimeout();
        this.readHeaders();
    }

    private void initIdleTimeout() {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable t = (Throwable)((Left)either).value();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in idle timeout callback", t);
                    }
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                    return;
                }
                if (either instanceof Right) {
                    Logger Logger_this = this.logger();
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("Shutting down due to idle timeout");
                    }
                    this.closePipeline((Option)None$.MODULE$);
                    return;
                }
                throw new MatchError((Object)either);
            };
            IdleTimeoutStage stage = new IdleTimeoutStage(f, this.scheduler, this.executionContext());
            this.spliceBefore((MidStage)stage);
            stage.init((Function1<Either<Throwable, TimeoutException>, BoxedUnit>)cb);
            return;
        }
    }

    private void readHeaders() {
        this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                if (streamFrame instanceof HeadersFrame) {
                    HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                    Priority priority = headersFrame._1();
                    boolean bl = headersFrame._2();
                    Seq<Tuple2<String, String>> seq = headersFrame._3();
                    boolean endStream = bl;
                    Seq<Tuple2<String, String>> hs = seq;
                    this.checkAndRunRequest(hs, endStream);
                    return;
                }
                StreamFrame frame = streamFrame;
                Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, new StringBuilder(24).append("Received invalid frame: ").append(frame).toString());
                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command$EOF$.MODULE$.equals(throwable)) {
                    this.closePipeline((Option)None$.MODULE$);
                    return;
                }
                Throwable t = throwable;
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Unknown error in readHeaders", t);
                }
                Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Unknown error");
                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.executionContext());
    }

    private Stream<F, Object> getBody(long maxlen) {
        BooleanRef complete = BooleanRef.create((boolean)false);
        LongRef bytesRead = LongRef.create((long)0L);
        Object t = this.org$http4s$blaze$server$Http2NodeStage$$F.async((Function1 & Serializable)cb -> this.org$http4s$blaze$server$Http2NodeStage$$F.delay(() -> this.$anonfun$2$$anonfun$1(complete, cb, bytesRead, maxlen)));
        Stream stream = Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(t));
        return Stream$OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatMap((Function1 & Serializable)_$2 -> Stream$.MODULE$.chunk(_$2), NotGiven$.MODULE$.value());
    }

    private void checkAndRunRequest(Seq<Tuple2<String, String>> hs, boolean endStream) {
        ListBuffer headers = new ListBuffer();
        ObjectRef method = ObjectRef.create(null);
        ObjectRef scheme = ObjectRef.create(null);
        ObjectRef path = ObjectRef.create(null);
        LongRef contentLength = LongRef.create((long)-1L);
        ObjectRef error = ObjectRef.create((Object)"");
        BooleanRef pseudoDone = BooleanRef.create((boolean)false);
        hs.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                String string3 = PseudoHeaders$.MODULE$.Method();
                String string4 = string;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((Method)method$1.elem == null) {
                        Either<ParseFailure, Method> either = Method$.MODULE$.fromString(v);
                        if (either instanceof Right) {
                            Method m = (Method)((Right)either).value();
                            method$1.elem = m;
                        } else if (either instanceof Left) {
                            ParseFailure e = (ParseFailure)((Left)either).value();
                            error$1.elem = new StringBuilder(18).append((String)error$1.elem).append(" Invalid method: ").append(e).append(" ").toString();
                        } else {
                            throw new MatchError(either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':method' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
                String string5 = PseudoHeaders$.MODULE$.Scheme();
                String string6 = string;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((String)scheme$1.elem == null) {
                        scheme$1.elem = v;
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':scheme' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
                String string7 = PseudoHeaders$.MODULE$.Path();
                String string8 = string;
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    if ((Uri)path$1.elem == null) {
                        Either<ParseFailure, Uri> either = Uri$.MODULE$.requestTarget(v);
                        if (either instanceof Right) {
                            Uri p = (Uri)((Right)either).value();
                            path$1.elem = p;
                        } else if (either instanceof Left) {
                            ParseFailure e = (ParseFailure)((Left)either).value();
                            error$1.elem = new StringBuilder(15).append((String)error$1.elem).append(" Invalid path: ").append(e).toString();
                        } else {
                            throw new MatchError(either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    error$1.elem = new StringBuilder(34).append((String)error$1.elem).append("Multiple ':path' headers defined. ").toString();
                    return BoxedUnit.UNIT;
                }
                String string9 = PseudoHeaders$.MODULE$.Authority();
                String string10 = string;
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    if (pseudoDone$1.elem) {
                        error$1.elem = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                String k = string;
                Tuple2 h = tuple2;
                if (k.startsWith(":")) {
                    error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(25).append("Invalid pseudo header: ").append(h).append(". ").toString()).toString();
                    return BoxedUnit.UNIT;
                }
                String k2 = string;
                if (!HeaderNames$.MODULE$.validH2HeaderKey(k2)) {
                    error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(22).append("Invalid header key: ").append(k2).append(". ").toString()).toString();
                    return BoxedUnit.UNIT;
                }
            }
            Tuple2 hs = tuple2;
            pseudoDone$1.elem = true;
            Tuple2 tuple22 = hs;
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                String string11 = (String)tuple22._2();
                String string12 = HeaderNames$.MODULE$.Connection();
                String string13 = string;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    Tuple2 h = tuple22;
                    error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(46).append("HTTP/2 forbids connection specific headers: ").append(h).append(". ").toString()).toString();
                    return BoxedUnit.UNIT;
                }
                String string14 = HeaderNames$.MODULE$.ContentLength();
                String string15 = string;
                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                    String v = string11;
                    if (contentLength$1.elem < 0L) {
                        BoxedUnit boxedUnit;
                        try {
                            long sz = Long.parseLong(v);
                            if (sz != 0L && endStream) {
                                error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(44).append("Nonzero content length (").append(sz).append(") for end of stream.").toString()).toString();
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (sz < 0L) {
                                error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(25).append("Negative content length: ").append(sz).toString()).toString();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                contentLength$1.elem = sz;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            error$1.elem = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(26).append("Invalid content-length: ").append(v).append(". ").toString()).toString();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    error$1.elem = new StringBuilder(40).append((String)error$1.elem).append("Received multiple content-length headers").toString();
                    return BoxedUnit.UNIT;
                }
                String string16 = HeaderNames$.MODULE$.TE();
                String string17 = string;
                if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                    String v = string11;
                    if (!v.equalsIgnoreCase("trailers")) {
                        error$1.elem = new StringBuilder(55).append((String)error$1.elem).append("HTTP/2 forbids TE header values other than 'trailers'. ").toString();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                String k = string;
                String v = string11;
                String string18 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return headers.$plus$eq((Object)Header$ToRaw$.MODULE$.keyValuesToRaw((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string18, (Object)v)));
            }
            throw new MatchError((Object)tuple22);
        });
        if ((Method)method.elem == null || (String)scheme.elem == null || (Uri)path.elem == null) {
            error.elem = new StringBuilder(0).append((String)error.elem).append(new StringBuilder(69).append("Invalid request: missing pseudo headers. Method: ").append((Method)method.elem).append(", Scheme: ").append((String)scheme.elem).append(", path: ").append((Uri)path.elem).append(". ").toString()).toString();
        }
        if (((String)error.elem).length() > 0) {
            this.closePipeline((Option)Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, (String)error.elem)));
            return;
        }
        Stream<Nothing$, Object> body = endStream ? package$.MODULE$.EmptyBody() : this.getBody(contentLength.elem);
        List hs2 = Headers$.MODULE$.apply((scala.collection.immutable.Seq<Header.ToRaw>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.scalaCollectionSeqToRaw(headers.result(), (Function1 & Serializable)h -> Header$ToRaw$.MODULE$.identityToRaw((Header.ToRaw)h))}));
        Request<Nothing$> req = Request$.MODULE$.apply((Method)method.elem, (Uri)path.elem, HttpVersion$.MODULE$.HTTP$div2(), hs2, body, (Vault)this.attributes.apply());
        this.executionContext().execute(new Runnable(req, this){
            private final Request req$1;
            private final /* synthetic */ Http2NodeStage $outer;
            {
                this.req$1 = req$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.defer(this::$anonfun$4), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                Object action = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)this.$outer.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler.apply((Object)this.req$1), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)_$3 -> this.$outer.org$http4s$blaze$server$Http2NodeStage$$renderResponse(_$3));
                Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(action, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                Object fa = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        return this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.unit();
                    }
                    if (either instanceof Left) {
                        Throwable t = (Throwable)((Left)either).value();
                        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0 & Serializable)() -> {
                            this.$anonfun$6$$anonfun$1(t);
                            return BoxedUnit.UNIT;
                        }), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                        Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F));
                        return ApplyOps$.MODULE$.$times$greater$extension(object2, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0 & Serializable)() -> {
                            this.$anonfun$6$$anonfun$2();
                            return BoxedUnit.UNIT;
                        }), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                    }
                    throw new MatchError((Object)either);
                });
                this.$outer.org$http4s$blaze$server$Http2NodeStage$$dispatcher.unsafeRunSync(fa);
            }

            private final Object $anonfun$4() {
                return this.$outer.org$http4s$blaze$server$Http2NodeStage$$raceTimeout.apply((Object)this.req$1);
            }

            private final void $anonfun$6$$anonfun$1(Throwable t$1) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error(new StringBuilder(23).append("Error running request: ").append(this.req$1).toString(), t$1);
                    return;
                }
            }

            private final void $anonfun$6$$anonfun$2() {
                this.$outer.closePipeline((Option)None$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$4(), $anonfun$5(org.http4s.Response ), $anonfun$6(scala.util.Either ), $anonfun$adapted$1(java.lang.Throwable ), $anonfun$6$$anonfun$adapted$1()}, serializedLambda);
            }
        });
    }

    public F org$http4s$blaze$server$Http2NodeStage$$renderResponse(Response<F> resp) {
        ArrayBuffer hs = new ArrayBuffer(16);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)PseudoHeaders$.MODULE$.Status());
        hs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Integer.toString(resp.status().code())));
        Headers$.MODULE$.foreach$extension(resp.headers(), (Function1<Header.Raw, BoxedUnit>)(JProcedure1 & Serializable)h -> {
            CIString cIString = h.name();
            CIString cIString2 = Transfer$minusEncoding$.MODULE$.name();
            if (cIString == null ? cIString2 != null : !((Object)cIString).equals(cIString2)) {
                CIString cIString3 = h.name();
                CIString cIString4 = Header$.MODULE$.apply(Connection$.MODULE$.headerInstance()).name();
                if (cIString3 == null ? cIString4 != null : !((Object)cIString3).equals(cIString4)) {
                    hs.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)h.name().toString().toLowerCase(Locale.ROOT), (Object)h.value()));
                    return;
                }
            }
        });
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(new Http2Writer<F>(this, (Seq<Tuple2<String, String>>)hs, this.org$http4s$blaze$server$Http2NodeStage$$F).writeEntityBody((Stream)resp.body()), this.org$http4s$blaze$server$Http2NodeStage$$F);
        return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.org$http4s$blaze$server$Http2NodeStage$$F), this.org$http4s$blaze$server$Http2NodeStage$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                this.closePipeline((Option)None$.MODULE$);
                return;
            }
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (Command$EOF$.MODULE$.equals(throwable)) {
                    this.stageShutdown();
                    return;
                }
                Throwable t = throwable;
                this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    private final void $init$$$anonfun$1() {
        this.stageShutdown();
    }

    private final Option $anonfun$2$$anonfun$1(BooleanRef complete$2, Function1 cb$1, LongRef bytesRead$2, long maxlen$2) {
        if (complete$2.elem) {
            cb$1.apply(org.http4s.blazecore.util.package$.MODULE$.End());
        } else {
            this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                    if (streamFrame instanceof DataFrame) {
                        DataFrame dataFrame = DataFrame$.MODULE$.unapply((DataFrame)streamFrame);
                        boolean bl = dataFrame._1();
                        ByteBuffer byteBuffer = dataFrame._2();
                        boolean last = bl;
                        ByteBuffer bytes = byteBuffer;
                        complete$3.elem = last;
                        bytesRead$3.elem += (long)bytes.remaining();
                        if (complete$3.elem && maxlen$2 > 0L && bytesRead$3.elem != maxlen$2) {
                            String msg = new StringBuilder(38).append("Entity too small. Expected ").append(maxlen$2).append(", received ").append(bytesRead$3.elem).toString();
                            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                            this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                            return;
                        }
                        if (maxlen$2 > 0L && bytesRead$3.elem > maxlen$2) {
                            String msg = new StringBuilder(47).append("Entity too large. Expected ").append(maxlen$2).append(", received bytesRead").toString();
                            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                            this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                            return;
                        }
                        cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply(Chunk$.MODULE$.array(bytes.array(), ClassTag$.MODULE$.apply(Byte.TYPE)))));
                        return;
                    }
                    if (streamFrame instanceof HeadersFrame) {
                        HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                        Priority priority = headersFrame._1();
                        boolean bl = headersFrame._2();
                        Seq<Tuple2<String, String>> seq = headersFrame._3();
                        if (bl) {
                            Seq<Tuple2<String, String>> ts = seq;
                            Logger Logger_this = this.logger();
                            if (Logger_this.isWarnEnabled()) {
                                Logger_this.warn(new StringBuilder(21).append("Discarding trailers: ").append(ts).toString());
                            }
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply(Chunk$.MODULE$.empty())));
                            return;
                        }
                    }
                    StreamFrame other = streamFrame;
                    String msg = new StringBuilder(48).append("Received invalid frame while accumulating body: ").append(other).toString();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info(msg);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                    cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable throwable = ((Failure)try_).exception();
                    if (Command$EOF$.MODULE$.equals(throwable)) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isDebugEnabled()) {
                            Logger_this.debug("EOF while accumulating body");
                        }
                        cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply("Received premature EOF.")));
                        this.closePipeline((Option)None$.MODULE$);
                        return;
                    }
                    Throwable t = throwable;
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in getBody().", t);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Failed to read body");
                    cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)e));
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                    return;
                }
                throw new MatchError((Object)try_);
            }, this.executionContext());
        }
        return this.shutdownStageToken;
    }
}

