/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.http4s.internal.package$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketFrame$Binary$;
import org.http4s.websocket.WebSocketFrame$Text$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class WSFrameAggregator
implements MidStage<WebSocketFrame, WebSocketFrame> {
    private Logger logger;
    private Head _prevStage;
    private Tail _nextStage;
    private final Accumulator accumulator;

    public WSFrameAggregator() {
        Stage.$init$(this);
        Tail.$init$(this);
        Head.$init$(this);
        this.accumulator = new Accumulator();
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    @Override
    public Tail _nextStage() {
        return this._nextStage;
    }

    @Override
    public void _nextStage_$eq(Tail x$1) {
        this._nextStage = x$1;
    }

    @Override
    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$(this, cmd);
    }

    @Override
    public String name() {
        return "WebSocket Frame Aggregator";
    }

    @Override
    public Future<WebSocketFrame> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.channelRead(size, this.channelRead$default$2()).onComplete((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                this.readLoop(f, (Promise<WebSocketFrame>)p);
                return BoxedUnit.UNIT;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                return p.failure(t);
            }
            throw new MatchError((Object)try_);
        }, Execution$.MODULE$.directec());
        return p.future();
    }

    private void readLoop(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            this.handleHead(frame, p);
            return;
        }
        if (webSocketFrame instanceof WebSocketFrame.Binary) {
            this.handleHead(frame, p);
            return;
        }
        if (webSocketFrame instanceof WebSocketFrame.Continuation) {
            WebSocketFrame.Continuation c = (WebSocketFrame.Continuation)webSocketFrame;
            if (this.accumulator.isEmpty()) {
                ProtocolException e = new ProtocolException("Invalid state: Received a Continuation frame without accumulated state.");
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Invalid state", (Throwable)e);
                }
                p.failure((Throwable)e);
                return;
            }
            this.accumulator.append(frame);
            if (c.last()) {
                p.success((Object)this.accumulator.take());
                return;
            }
            this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                    this.readLoop(f, p);
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    p.failure(t);
                    return;
                }
                throw new MatchError((Object)try_);
            }, Execution$.MODULE$.trampoline());
            return;
        }
        WebSocketFrame f = webSocketFrame;
        p.success((Object)f);
    }

    private void handleHead(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        if (!this.accumulator.isEmpty()) {
            ProtocolException e = new ProtocolException("Invalid state: Received a head frame with accumulated state");
            this.accumulator.clear();
            p.failure((Throwable)e);
            return;
        }
        if (frame.last()) {
            p.success((Object)frame);
            return;
        }
        this.accumulator.append(frame);
        this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                this.readLoop(f, p);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                p.failure(t);
                return;
            }
            throw new MatchError((Object)try_);
        }, Execution$.MODULE$.directec());
    }

    @Override
    public Future<BoxedUnit> writeRequest(WebSocketFrame data) {
        return this.channelWrite(data);
    }

    @Override
    public Future<BoxedUnit> writeRequest(Seq<WebSocketFrame> data) {
        return this.channelWrite((Seq)data);
    }

    public static final class Accumulator {
        private final Queue<WebSocketFrame> queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        private int size = 0;

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void append(WebSocketFrame frame) {
            WebSocketFrame webSocketFrame;
            if (this.queue.isEmpty() && !((webSocketFrame = frame) instanceof WebSocketFrame.Text) && !(webSocketFrame instanceof WebSocketFrame.Binary)) {
                WebSocketFrame f = webSocketFrame;
                throw package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(f.getClass().getName()).toString());
            }
            this.size += frame.length();
            this.queue.$plus$eq((Object)frame);
        }

        public WebSocketFrame take() {
            boolean bl;
            WebSocketFrame webSocketFrame = (WebSocketFrame)this.queue.head();
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                bl = true;
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                bl = false;
            } else {
                WebSocketFrame f = webSocketFrame;
                AssertionError e = package$.MODULE$.bug(new StringBuilder(32).append("Shouldn't get here. Wrong type: ").append(f.getClass().getName()).toString());
                throw e;
            }
            boolean isText = bl;
            ObjectRef out = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
            this.go$1(out);
            this.size = 0;
            if (isText) {
                return WebSocketFrame$Text$.MODULE$.apply((ByteVector)out.elem);
            }
            return WebSocketFrame$Binary$.MODULE$.apply((ByteVector)out.elem, WebSocketFrame$Binary$.MODULE$.$lessinit$greater$default$2());
        }

        public void clear() {
            this.size = 0;
            this.queue.clear();
        }

        private final void go$1(ObjectRef out$1) {
            while (!this.queue.isEmpty()) {
                ByteVector frame = ((WebSocketFrame)this.queue.dequeue()).data();
                out$1.elem = ((ByteVector)out$1.elem).$plus$plus(frame);
            }
        }
    }
}

