/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Cancelable$;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor$;
import org.http4s.blaze.util.TickWheelExecutor$AlreadyShutdownException$;
import org.http4s.blaze.util.TickWheelExecutor$Cancel$;
import org.http4s.blaze.util.TickWheelExecutor$Node$;
import org.http4s.blaze.util.TickWheelExecutor$Register$;
import org.http4s.blaze.util.TickWheelExecutor$Tail$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public class TickWheelExecutor {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TickWheelExecutor.class.getDeclaredField("Tail$lzy1"));
    private final int wheelSize;
    private final Duration tick;
    public final TickWheelExecutor$Register$ Register$lzy1;
    public final TickWheelExecutor$Cancel$ Cancel$lzy1;
    private volatile Object Tail$lzy1;
    public final Logger org$http4s$blaze$util$TickWheelExecutor$$logger;
    private volatile boolean alive;
    private final long tickNanos;
    private final double _tickInv;
    public final AtomicReference<ScheduleEvent> org$http4s$blaze$util$TickWheelExecutor$$head;
    private final Bucket[] clockFace;
    public final TickWheelExecutor$Node$ Node$lzy1;

    public static int DefaultWheelSize() {
        return TickWheelExecutor$.MODULE$.DefaultWheelSize();
    }

    public static int $lessinit$greater$default$1() {
        return TickWheelExecutor$.MODULE$.$lessinit$greater$default$1();
    }

    public static Duration $lessinit$greater$default$2() {
        return TickWheelExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public TickWheelExecutor(int wheelSize, Duration tick) {
        this.wheelSize = wheelSize;
        this.tick = tick;
        this.Register$lzy1 = new TickWheelExecutor$Register$(this);
        this.Cancel$lzy1 = new TickWheelExecutor$Cancel$(this);
        this.Node$lzy1 = new TickWheelExecutor$Node$();
        Predef$.MODULE$.require(wheelSize > 0, TickWheelExecutor::$init$$$anonfun$1);
        Predef$.MODULE$.require(tick.isFinite() && tick.toNanos() != 0L, TickWheelExecutor::$init$$$anonfun$2);
        this.org$http4s$blaze$util$TickWheelExecutor$$logger = LoggerFactory.getLogger((String)"org.http4s.blaze.util.TickWheelExecutor");
        this.alive = true;
        this.tickNanos = tick.toNanos();
        this._tickInv = 1.0 / (double)this.tickNanos;
        this.org$http4s$blaze$util$TickWheelExecutor$$head = new AtomicReference<TickWheelExecutor$Tail$>(this.Tail());
        this.clockFace = (Bucket[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), wheelSize).map((Function1 & Serializable)_$1 -> this.$init$$$anonfun$3(BoxesRunTime.unboxToInt((Object)_$1))).toArray(ClassTag$.MODULE$.apply(Bucket.class));
        Thread thread = new Thread(this){
            private final /* synthetic */ TickWheelExecutor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("blaze-tick-wheel-executor");
            }

            public void run() {
                this.$outer.org$http4s$blaze$util$TickWheelExecutor$$cycle(System.nanoTime());
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public Duration tick() {
        return this.tick;
    }

    private final TickWheelExecutor$Register$ Register() {
        return this.Register$lzy1;
    }

    public final TickWheelExecutor$Cancel$ org$http4s$blaze$util$TickWheelExecutor$$Cancel() {
        return this.Cancel$lzy1;
    }

    private final TickWheelExecutor$Tail$ Tail() {
        Object object = this.Tail$lzy1;
        if (object instanceof TickWheelExecutor$Tail$) {
            return (TickWheelExecutor$Tail$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TickWheelExecutor$Tail$)this.Tail$lzyINIT1();
    }

    private Object Tail$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Tail$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TickWheelExecutor$Tail$ tickWheelExecutor$Tail$ = null;
                    try {
                        tickWheelExecutor$Tail$ = new TickWheelExecutor$Tail$();
                        object2 = tickWheelExecutor$Tail$ == null ? LazyVals.NullValue$.MODULE$ : tickWheelExecutor$Tail$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Tail$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return tickWheelExecutor$Tail$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void shutdown() {
        this.alive = false;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public Cancelable schedule(Runnable r, Duration timeout) {
        return this.schedule(r, Execution$.MODULE$.directec(), timeout);
    }

    public Cancelable schedule(Runnable r, ExecutionContext ec, Duration timeout) {
        if (this.alive) {
            if (!timeout.isFinite()) {
                return Cancelable$.MODULE$.NoopCancel();
            }
            long nanos = timeout.toNanos();
            if (nanos > 0L) {
                long expires = nanos + System.nanoTime();
                Node node = new Node(this, r, ec, expires, null, null, this.org$http4s$blaze$util$TickWheelExecutor$$Node().$lessinit$greater$default$6());
                this.go$1(node);
                return node;
            }
            try {
                ec.execute(r);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    this.onNonFatal(t);
                }
                throw throwable;
            }
            return Cancelable$.MODULE$.NoopCancel();
        }
        throw TickWheelExecutor$AlreadyShutdownException$.MODULE$;
    }

    private void handleTasks() {
        ScheduleEvent tasks = this.org$http4s$blaze$util$TickWheelExecutor$$head.getAndSet(this.Tail());
        this.go$2(tasks);
    }

    public void org$http4s$blaze$util$TickWheelExecutor$$cycle(long lastTickTime) {
        while (true) {
            this.handleTasks();
            long thisTickTime = System.nanoTime();
            long lastTick = (long)((double)lastTickTime * this._tickInv);
            long thisTick = (long)((double)thisTickTime * this._tickInv);
            long ticks = package$.MODULE$.min(thisTick - lastTick, (long)this.wheelSize);
            this.go$3(ticks, lastTick, thisTickTime, 0L);
            if (!this.alive) break;
            long nextTickTime = (thisTick + 1L) * this.tickNanos;
            long sleep = nextTickTime - System.nanoTime();
            if (sleep > 0L) {
                Thread.sleep(sleep / 1000000L);
            }
            lastTickTime = thisTickTime;
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.wheelSize).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.clockFace[i] = null;
        });
    }

    public void onNonFatal(Throwable t) {
        Logger Logger_this = this.org$http4s$blaze$util$TickWheelExecutor$$logger;
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error("Non-Fatal Exception caught while executing scheduled task", t);
            return;
        }
    }

    private Bucket getBucket(long expiration) {
        long i = (long)((double)expiration * this._tickInv) % (long)this.wheelSize;
        return this.clockFace[(int)i];
    }

    public final TickWheelExecutor$Node$ org$http4s$blaze$util$TickWheelExecutor$$Node() {
        return this.Node$lzy1;
    }

    private static final Object $init$$$anonfun$1() {
        return "Need finite size number of ticks";
    }

    private static final Object $init$$$anonfun$2() {
        return "tick duration must be finite";
    }

    private final /* synthetic */ Bucket $init$$$anonfun$3(int _$1) {
        return new Bucket();
    }

    private final void go$1(Node node$1) {
        ScheduleEvent h;
        while (!this.org$http4s$blaze$util$TickWheelExecutor$$head.compareAndSet(h = this.org$http4s$blaze$util$TickWheelExecutor$$head.get(), this.Register().apply(node$1, h))) {
        }
    }

    private final void go$2(ScheduleEvent task) {
        ScheduleEvent scheduleEvent;
        while (true) {
            if ((scheduleEvent = task) instanceof Cancel && ((Cancel)scheduleEvent).org$http4s$blaze$util$TickWheelExecutor$Cancel$$$outer() == this) {
                Cancel cancel = this.org$http4s$blaze$util$TickWheelExecutor$$Cancel().unapply((Cancel)scheduleEvent);
                Node node = cancel._1();
                ScheduleEvent scheduleEvent2 = cancel._2();
                Node n = node;
                ScheduleEvent nxt = scheduleEvent2;
                n.canceled_$eq(true);
                n.unlink();
                task = nxt;
                continue;
            }
            if (!(scheduleEvent instanceof Register) || ((Register)scheduleEvent).org$http4s$blaze$util$TickWheelExecutor$Register$$$outer() != this) break;
            Register register = this.Register().unapply((Register)scheduleEvent);
            Node node = register._1();
            ScheduleEvent scheduleEvent3 = register._2();
            Node n = node;
            ScheduleEvent nxt = scheduleEvent3;
            if (!n.canceled()) {
                this.getBucket(n.expiration()).add(n);
            }
            task = nxt;
        }
        if (this.Tail().equals(scheduleEvent)) {
            return;
        }
        throw new MatchError((Object)scheduleEvent);
    }

    private final void go$3(long ticks$1, long lastTick$1, long thisTickTime$1, long i) {
        while (i < ticks$1) {
            int ii = (int)((lastTick$1 + i) % (long)this.wheelSize);
            this.clockFace[ii].prune(thisTickTime$1);
            ++i;
        }
    }

    public class Bucket {
        private final Node head;

        public Bucket() {
            if (TickWheelExecutor.this == null) {
                throw new NullPointerException();
            }
            this.head = new Node(TickWheelExecutor.this, null, null, -1L, null, null, TickWheelExecutor.this.org$http4s$blaze$util$TickWheelExecutor$$Node().$lessinit$greater$default$6());
        }

        public void prune(long time) {
            this.checkNext$1(time, this.head);
        }

        public void add(Node node) {
            node.insertAfter(this.head);
        }

        public final /* synthetic */ TickWheelExecutor org$http4s$blaze$util$TickWheelExecutor$Bucket$$$outer() {
            return TickWheelExecutor.this;
        }

        private final void checkNext$1(long time$1, Node prev) {
            Node next;
            while ((next = prev.next()) != null) {
                if (next.canceled()) {
                    Logger Logger_this = TickWheelExecutor.this.org$http4s$blaze$util$TickWheelExecutor$$logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Tickwheel has canceled node in bucket: shouldn't get here.");
                    }
                    next.unlink();
                    return;
                }
                if (next.expiresBy(time$1)) {
                    next.run();
                    next.unlink();
                    continue;
                }
                prev = next;
            }
        }
    }

    public class Cancel
    implements ScheduleEvent,
    Product,
    Serializable {
        private final Node node;
        private final ScheduleEvent next;
        private final /* synthetic */ TickWheelExecutor $outer;

        public Cancel(TickWheelExecutor $outer, Node node, ScheduleEvent next) {
            this.node = node;
            this.next = next;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cancel)) return false;
            if (((Cancel)object).org$http4s$blaze$util$TickWheelExecutor$Cancel$$$outer() != this.$outer) return false;
            Cancel cancel = (Cancel)object;
            Node node = this.node();
            Node node2 = cancel.node();
            if (node == null) {
                if (node2 != null) {
                    return false;
                }
            } else if (!node.equals(node2)) return false;
            ScheduleEvent scheduleEvent = this.next();
            ScheduleEvent scheduleEvent2 = cancel.next();
            if (scheduleEvent == null) {
                if (scheduleEvent2 != null) {
                    return false;
                }
            } else if (!scheduleEvent.equals(scheduleEvent2)) return false;
            if (!cancel.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Cancel;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Cancel";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "node";
            }
            if (1 == n2) {
                return "next";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Node node() {
            return this.node;
        }

        public ScheduleEvent next() {
            return this.next;
        }

        public Cancel copy(Node node, ScheduleEvent next) {
            return new Cancel(this.$outer, node, next);
        }

        public Node copy$default$1() {
            return this.node();
        }

        public ScheduleEvent copy$default$2() {
            return this.next();
        }

        public Node _1() {
            return this.node();
        }

        public ScheduleEvent _2() {
            return this.next();
        }

        public final /* synthetic */ TickWheelExecutor org$http4s$blaze$util$TickWheelExecutor$Cancel$$$outer() {
            return this.$outer;
        }
    }

    public final class Node
    implements Cancelable {
        private final Runnable r;
        private final ExecutionContext ec;
        private final long expiration;
        private Node prev;
        private Node next;
        private boolean canceled;
        private final /* synthetic */ TickWheelExecutor $outer;

        public Node(TickWheelExecutor $outer, Runnable r, ExecutionContext ec, long expiration, Node prev, Node next, boolean canceled) {
            this.r = r;
            this.ec = ec;
            this.expiration = expiration;
            this.prev = prev;
            this.next = next;
            this.canceled = canceled;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public long expiration() {
            return this.expiration;
        }

        public Node prev() {
            return this.prev;
        }

        public void prev_$eq(Node x$1) {
            this.prev = x$1;
        }

        public Node next() {
            return this.next;
        }

        public void next_$eq(Node x$1) {
            this.next = x$1;
        }

        public boolean canceled() {
            return this.canceled;
        }

        public void canceled_$eq(boolean x$1) {
            this.canceled = x$1;
        }

        public void unlink() {
            if (this.prev() != null) {
                this.prev().next_$eq(this.next());
            }
            if (this.next() != null) {
                this.next().prev_$eq(this.prev());
            }
            this.prev_$eq(null);
            this.next_$eq(null);
        }

        public void insertAfter(Node node) {
            Node n = node.next();
            node.next_$eq(this);
            if (n != null) {
                n.prev_$eq(this);
            }
            this.prev_$eq(node);
            this.next_$eq(n);
        }

        public boolean expiresBy(long now) {
            return now >= this.expiration();
        }

        @Override
        public void cancel() {
            this.go$4();
        }

        public void run() {
            try {
                this.ec.execute(this.r);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    this.$outer.onNonFatal(t);
                }
                throw throwable;
            }
        }

        public final /* synthetic */ TickWheelExecutor org$http4s$blaze$util$TickWheelExecutor$Node$$$outer() {
            return this.$outer;
        }

        private final void go$4() {
            ScheduleEvent h;
            while (!this.$outer.org$http4s$blaze$util$TickWheelExecutor$$head.compareAndSet(h = this.$outer.org$http4s$blaze$util$TickWheelExecutor$$head.get(), this.$outer.org$http4s$blaze$util$TickWheelExecutor$$Cancel().apply(this, h))) {
            }
        }
    }

    public class Register
    implements ScheduleEvent,
    Product,
    Serializable {
        private final Node node;
        private final ScheduleEvent next;
        private final /* synthetic */ TickWheelExecutor $outer;

        public Register(TickWheelExecutor $outer, Node node, ScheduleEvent next) {
            this.node = node;
            this.next = next;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Register)) return false;
            if (((Register)object).org$http4s$blaze$util$TickWheelExecutor$Register$$$outer() != this.$outer) return false;
            Register register = (Register)object;
            Node node = this.node();
            Node node2 = register.node();
            if (node == null) {
                if (node2 != null) {
                    return false;
                }
            } else if (!node.equals(node2)) return false;
            ScheduleEvent scheduleEvent = this.next();
            ScheduleEvent scheduleEvent2 = register.next();
            if (scheduleEvent == null) {
                if (scheduleEvent2 != null) {
                    return false;
                }
            } else if (!scheduleEvent.equals(scheduleEvent2)) return false;
            if (!register.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Register;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Register";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "node";
            }
            if (1 == n2) {
                return "next";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Node node() {
            return this.node;
        }

        public ScheduleEvent next() {
            return this.next;
        }

        public Register copy(Node node, ScheduleEvent next) {
            return new Register(this.$outer, node, next);
        }

        public Node copy$default$1() {
            return this.node();
        }

        public ScheduleEvent copy$default$2() {
            return this.next();
        }

        public Node _1() {
            return this.node();
        }

        public ScheduleEvent _2() {
            return this.next();
        }

        public final /* synthetic */ TickWheelExecutor org$http4s$blaze$util$TickWheelExecutor$Register$$$outer() {
            return this.$outer;
        }
    }

    public interface ScheduleEvent {
    }
}

