/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore;

import cats.Applicative;
import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.syntax.EitherObjectOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$OptionStreamOps$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Headers$;
import org.http4s.InvalidBodyException$;
import org.http4s.Request;
import org.http4s.blaze.http.parser.BaseExceptions;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blazecore.Http1Stage$;
import org.http4s.blazecore.util.CachingChunkWriter;
import org.http4s.blazecore.util.CachingStaticWriter;
import org.http4s.blazecore.util.CachingStaticWriter$;
import org.http4s.blazecore.util.FlushingChunkWriter;
import org.http4s.blazecore.util.Http1Writer;
import org.http4s.blazecore.util.IdentityWriter;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Transfer$minusEncoding;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.http4s.syntax.package$header$;
import org.http4s.util.Renderer$;
import org.http4s.util.StringWriter;
import org.http4s.util.Writer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.VolatileObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.NotGiven$;
import scala.util.Success;
import scala.util.Try;

public interface Http1Stage<F> {
    public static void encodeHeaders(Iterable<Header.Raw> iterable, Writer writer, boolean bl) {
        Http1Stage$.MODULE$.encodeHeaders(iterable, writer, bl);
    }

    public static void $init$(Http1Stage $this) {
        $this.org$http4s$blazecore$Http1Stage$_setter_$org$http4s$blazecore$Http1Stage$$shutdownCancelToken_$eq(Some$.MODULE$.apply($this.F().delay((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        })));
    }

    public ExecutionContext executionContext();

    public Async<F> F();

    public Dispatcher<F> dispatcher();

    public int chunkBufferMaxSize();

    public Option<ByteBuffer> doParseContent(ByteBuffer var1);

    public boolean contentComplete();

    public static boolean checkCloseConnection$(Http1Stage $this, Connection conn, StringWriter rr) {
        return $this.checkCloseConnection(conn, rr);
    }

    default public boolean checkCloseConnection(Connection conn, StringWriter rr) {
        if (conn.hasKeepAlive()) {
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Found Keep-Alive header");
            }
            return false;
        }
        if (conn.hasClose()) {
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Found Connection:Close header");
            }
            rr.$less$less("Connection:close\r\n");
            return true;
        }
        Logger Logger_this = ((TailStage)((Object)this)).logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(66).append("Unknown connection header: '").append(package$header$.MODULE$.http4sHeaderSyntax(conn, Connection$.MODULE$.headerInstance()).value()).append("'. Closing connection upon completion.").toString());
        }
        rr.$less$less("Connection:close\r\n");
        return true;
    }

    public static boolean checkRequestCloseConnection$(Http1Stage $this, Option conn, int minorVersion, Writer rr) {
        return $this.checkRequestCloseConnection((Option<Connection>)conn, minorVersion, rr);
    }

    default public boolean checkRequestCloseConnection(Option<Connection> conn, int minorVersion, Writer rr) {
        block7: {
            if (BoxesRunTime.unboxToBoolean((Object)conn.fold(Http1Stage::checkRequestCloseConnection$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.hasClose()))) {
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace(new StringBuilder(68).append("Closing ").append(conn).append(" due to explicit close option in request's Connection header").toString());
                }
                if (minorVersion >= 1) {
                    rr.$less$less("Connection: close\r\n");
                }
                return true;
            }
            if (minorVersion >= 1) {
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace(new StringBuilder(50).append("Keeping ").append(conn).append(" alive per default behavior of HTTP >= 1.1").toString());
                }
                return false;
            }
            if (BoxesRunTime.unboxToBoolean((Object)conn.fold(Http1Stage::checkRequestCloseConnection$$anonfun$3, (Function1 & Serializable)_$3 -> _$3.hasKeepAlive()))) {
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace(new StringBuilder(79).append("Keeping ").append(conn).append(" alive due to explicit keep-alive option in request's Connection header").toString());
                }
                return false;
            }
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (!Logger_this.isTraceEnabled()) break block7;
            Logger_this.trace(new StringBuilder(41).append("Closing ").append(conn).append(" per default behavior of HTTP/1.0").toString());
        }
        return true;
    }

    public static Http1Writer getEncoder$(Http1Stage $this, Request req, StringWriter rr, int minor, boolean closeOnFinish) {
        return $this.getEncoder(req, rr, minor, closeOnFinish);
    }

    default public Http1Writer<F> getEncoder(Request<F> req, StringWriter rr, int minor, boolean closeOnFinish) {
        List headers = req.headers();
        return this.getEncoder(Headers$.MODULE$.get$extension(headers, Header$Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())), Headers$.MODULE$.get$extension(headers, Header$Select$.MODULE$.recurringHeadersWithMerge(Transfer$minusEncoding$.MODULE$.headerSemigroupInstance(), Transfer$minusEncoding$.MODULE$.headerInstance())), Headers$.MODULE$.get$extension(headers, Header$Select$.MODULE$.singleHeaders(Content$minusLength$.MODULE$.headerInstance())), req.trailerHeaders((Applicative)this.F()), rr, minor, closeOnFinish, Http1Stage$.MODULE$.org$http4s$blazecore$Http1Stage$$$omitEmptyContentLength(req));
    }

    public static Http1Writer getEncoder$(Http1Stage $this, Option connectionHeader, Option bodyEncoding, Option lengthHeader, Object trailer, StringWriter rr, int minor, boolean closeOnFinish, boolean omitEmptyContentLength) {
        return $this.getEncoder((Option<Connection>)connectionHeader, (Option<Transfer$minusEncoding>)bodyEncoding, (Option<Content$minusLength>)lengthHeader, trailer, rr, minor, closeOnFinish, omitEmptyContentLength);
    }

    default public Http1Writer<F> getEncoder(Option<Connection> connectionHeader, Option<Transfer$minusEncoding> bodyEncoding, Option<Content$minusLength> lengthHeader, F trailer, StringWriter rr, int minor, boolean closeOnFinish, boolean omitEmptyContentLength) {
        Option<Content$minusLength> option = lengthHeader;
        if (option instanceof Some) {
            Content$minusLength h = (Content$minusLength)((Some)option).value();
            if (bodyEncoding.forall((Function1 & Serializable)_$4 -> !_$4.hasChunked()) || minor == 0) {
                bodyEncoding.foreach((Function1)(JProcedure1 & Serializable)enc -> {
                    Logger Logger_this = ((TailStage)((Object)this)).logger();
                    if (Logger_this.isWarnEnabled()) {
                        Logger_this.warn(new StringBuilder(64).append("Unsupported transfer encoding: '").append(package$header$.MODULE$.http4sHeaderSyntax(enc, Transfer$minusEncoding$.MODULE$.headerInstance()).value()).append("' for HTTP 1.").append(minor).append(". Stripping header.").toString());
                        return;
                    }
                });
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace("Using static encoder");
                }
                rr.$less$less(h, Renderer$.MODULE$.headerSelectRenderer(Header$Select$.MODULE$.singleHeaders(Content$minusLength$.MODULE$.headerInstance()))).$less$less("\r\n");
                rr.$less$less(!closeOnFinish && minor == 0 && connectionHeader.isEmpty() ? "Connection: keep-alive\r\n\r\n" : "\r\n");
                return new IdentityWriter<F>(h.length(), (TailStage)((Object)this), this.F());
            }
        }
        if (minor == 0) {
            if (closeOnFinish) {
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace("Using static encoder");
                }
                rr.$less$less("\r\n");
                return new IdentityWriter<F>(-1L, (TailStage)((Object)this), this.F());
            }
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Using static encoder without length");
            }
            return new CachingStaticWriter<F>((TailStage)((Object)this), CachingStaticWriter$.MODULE$.$lessinit$greater$default$2(), this.F());
        }
        Option<Transfer$minusEncoding> option2 = bodyEncoding;
        if (option2 instanceof Some) {
            Logger Logger_this;
            Logger Logger_this2;
            Transfer$minusEncoding enc2 = (Transfer$minusEncoding)((Some)option2).value();
            if (!enc2.hasChunked() && (Logger_this2 = ((TailStage)((Object)this)).logger()).isWarnEnabled()) {
                Logger_this2.warn(new StringBuilder(64).append("Unsupported transfer encoding: '").append(package$header$.MODULE$.http4sHeaderSyntax(enc2, Transfer$minusEncoding$.MODULE$.headerInstance()).value()).append("' for HTTP 1.").append(minor).append(". Stripping header.").toString());
            }
            if (lengthHeader.isDefined() && (Logger_this = ((TailStage)((Object)this)).logger()).isWarnEnabled()) {
                Logger_this.warn("Both Content-Length and Transfer-Encoding headers defined. Stripping Content-Length.");
            }
            return new FlushingChunkWriter<F>((TailStage)((Object)this), trailer, this.F(), this.executionContext(), this.dispatcher());
        }
        if (None$.MODULE$.equals(option2)) {
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Using Caching Chunk Encoder");
            }
            return new CachingChunkWriter<F>((TailStage)((Object)this), trailer, this.chunkBufferMaxSize(), omitEmptyContentLength, this.F(), this.executionContext(), this.dispatcher());
        }
        throw new MatchError(option2);
    }

    public static Tuple2 collectBodyFromParser$(Http1Stage $this, ByteBuffer buffer, Function0 eofCondition) {
        return $this.collectBodyFromParser(buffer, (Function0<Either<Throwable, Option<Chunk<Object>>>>)eofCondition);
    }

    default public Tuple2<Stream<F, Object>, Function0<Future<ByteBuffer>>> collectBodyFromParser(ByteBuffer buffer, Function0<Either<Throwable, Option<Chunk<Object>>>> eofCondition) {
        if (this.contentComplete()) {
            if (buffer.remaining() == 0) {
                return Http1Stage$.org$http4s$blazecore$Http1Stage$$$CachedEmptyBody;
            }
            return Tuple2$.MODULE$.apply(package$.MODULE$.EmptyBody(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)buffer));
        }
        if (buffer.hasRemaining()) {
            Option<ByteBuffer> option = this.doParseContent(buffer);
            if (option instanceof Some) {
                ByteBuffer byteBuffer;
                ByteBuffer buff = byteBuffer = (ByteBuffer)((Some)option).value();
                if (this.contentComplete()) {
                    Stream stream = (Stream)Predef$.MODULE$.ArrowAssoc(Stream$.MODULE$.chunk(Chunk$.MODULE$.byteBuffer(buff)));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stream, Http1Stage$.MODULE$.org$http4s$blazecore$Http1Stage$$$futureBufferThunk(buffer));
                }
                ByteBuffer buff2 = byteBuffer;
                Tuple2<Stream<F, Object>, Function0<Future<ByteBuffer>>> tuple2 = this.streamingBody(buffer, eofCondition);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Stream rst = (Stream)tuple2._1();
                Function0 end = (Function0)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)rst, (Object)end);
                Stream rst2 = (Stream)tuple22._1();
                Function0 end2 = (Function0)tuple22._2();
                return Tuple2$.MODULE$.apply(Stream$.MODULE$.chunk(Chunk$.MODULE$.byteBuffer(buff2)).$plus$plus(() -> Http1Stage.collectBodyFromParser$$anonfun$2(rst2)), (Object)end2);
            }
            if (None$.MODULE$.equals(option)) {
                if (this.contentComplete()) {
                    if (buffer.hasRemaining()) {
                        Stream stream = (Stream)Predef$.MODULE$.ArrowAssoc(package$.MODULE$.EmptyBody());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)stream, Http1Stage$.MODULE$.org$http4s$blazecore$Http1Stage$$$futureBufferThunk(buffer));
                    }
                    return Http1Stage$.org$http4s$blazecore$Http1Stage$$$CachedEmptyBody;
                }
                return this.streamingBody(buffer, eofCondition);
            }
            throw new MatchError(option);
        }
        return this.streamingBody(buffer, eofCondition);
    }

    public Some<F> org$http4s$blazecore$Http1Stage$$shutdownCancelToken();

    public void org$http4s$blazecore$Http1Stage$_setter_$org$http4s$blazecore$Http1Stage$$shutdownCancelToken_$eq(Some var1);

    private Tuple2<Stream<F, Object>, Function0<Future<ByteBuffer>>> streamingBody(ByteBuffer buffer, Function0<Either<Throwable, Option<Chunk<Object>>>> eofCondition) {
        VolatileObjectRef currentBuffer = VolatileObjectRef.create((Object)buffer);
        Object t = this.F().async((Function1 & Serializable)cb -> this.F().delay(() -> this.$anonfun$1$$anonfun$1(currentBuffer, cb, eofCondition)));
        Stream stream = Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(t));
        return Tuple2$.MODULE$.apply(Stream$OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatMap((Function1 & Serializable)_$5 -> Stream$.MODULE$.chunk(_$5), NotGiven$.MODULE$.value()), (Function0 & Serializable)() -> this.drainBody((ByteBuffer)currentBuffer$5.elem));
    }

    public static void fatalError$(Http1Stage $this, Throwable t, String msg) {
        $this.fatalError(t, msg);
    }

    default public void fatalError(Throwable t, String msg) {
        Logger Logger_this = ((TailStage)((Object)this)).logger();
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error(new StringBuilder(13).append("Fatal Error: ").append(msg).toString(), t);
        }
        ((TailStage)((Object)this)).stageShutdown();
        ((TailStage)((Object)this)).closePipeline((Option<Throwable>)Some$.MODULE$.apply((Object)t));
    }

    public static Future drainBody$(Http1Stage $this, ByteBuffer buffer) {
        return $this.drainBody(buffer);
    }

    default public Future<ByteBuffer> drainBody(ByteBuffer buffer) {
        block3: {
            Logger Logger_this = ((TailStage)((Object)this)).logger();
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace(new StringBuilder(15).append("Draining body: ").append(buffer).toString());
            }
            while (!this.contentComplete() && this.doParseContent(buffer).nonEmpty()) {
            }
            if (this.contentComplete()) {
                return Future$.MODULE$.successful((Object)buffer);
            }
            Logger Logger_this2 = ((TailStage)((Object)this)).logger();
            if (!Logger_this2.isInfoEnabled()) break block3;
            Logger_this2.info("HTTP body not read to completion. Dropping connection.");
        }
        return Future$.MODULE$.failed((Throwable)Command$EOF$.MODULE$);
    }

    private void $init$$$anonfun$1() {
        ((TailStage)((Object)this)).stageShutdown();
    }

    private static boolean checkRequestCloseConnection$$anonfun$1() {
        return false;
    }

    private static boolean checkRequestCloseConnection$$anonfun$3() {
        return false;
    }

    private static Stream collectBodyFromParser$$anonfun$2(Stream rst$1) {
        return rst$1;
    }

    private void go$1(VolatileObjectRef currentBuffer$3, Function1 cb$2, Function0 eofCondition$3) {
        block8: {
            try {
                Option<ByteBuffer> option;
                Option<ByteBuffer> parseResult = this.doParseContent((ByteBuffer)currentBuffer$3.elem);
                Logger Logger_this = ((TailStage)((Object)this)).logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug(new StringBuilder(34).append("Parse result: ").append(parseResult).append(", content complete: ").append(this.contentComplete()).toString());
                }
                if ((option = parseResult) instanceof Some) {
                    ByteBuffer result = (ByteBuffer)((Some)option).value();
                    Chunk chunk = (Chunk)package.all$.MODULE$.catsSyntaxOptionId(Chunk$.MODULE$.byteBuffer(result));
                    cb$2.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)OptionIdOps$.MODULE$.some$extension((Object)chunk)));
                    break block8;
                }
                if (None$.MODULE$.equals(option)) {
                    if (this.contentComplete()) {
                        cb$2.apply(org.http4s.blazecore.util.package$.MODULE$.End());
                    } else {
                        ((TailStage)((Object)this)).channelRead(((TailStage)((Object)this)).channelRead$default$1(), ((TailStage)((Object)this)).channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Try try_ = x$1;
                            if (try_ instanceof Success) {
                                ByteBuffer b = (ByteBuffer)((Success)try_).value();
                                currentBuffer$4.elem = BufferTools$.MODULE$.concatBuffers((ByteBuffer)currentBuffer$4.elem, b);
                                this.go$1(currentBuffer$3, cb$2, eofCondition$3);
                                return;
                            }
                            if (try_ instanceof Failure) {
                                Throwable throwable = ((Failure)try_).exception();
                                if (Command$EOF$.MODULE$.equals(throwable)) {
                                    cb$2.apply(eofCondition$3.apply());
                                    return;
                                }
                                Throwable t = throwable;
                                Logger Logger_this = ((TailStage)((Object)this)).logger();
                                if (Logger_this.isErrorEnabled()) {
                                    Logger_this.error("Unexpected error reading body.", t);
                                }
                                cb$2.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)t));
                                return;
                            }
                            throw new MatchError((Object)try_);
                        }, this.executionContext());
                    }
                    break block8;
                }
                throw new MatchError(option);
            }
            catch (BaseExceptions.ParserException t) {
                this.fatalError(t, "Error parsing request body");
                cb$2.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)InvalidBodyException$.MODULE$.apply(t.getMessage())));
            }
            catch (Throwable t) {
                this.fatalError(t, "Error collecting body");
                cb$2.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)t));
            }
        }
    }

    private Option $anonfun$1$$anonfun$1(VolatileObjectRef currentBuffer$2, Function1 cb$1, Function0 eofCondition$2) {
        if (!this.contentComplete()) {
            this.go$1(currentBuffer$2, cb$1, eofCondition$2);
        } else {
            cb$1.apply(org.http4s.blazecore.util.package$.MODULE$.End());
        }
        return this.org$http4s$blazecore$Http1Stage$$shutdownCancelToken();
    }
}

