/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore.util;

import cats.effect.kernel.Async;
import fs2.Chunk;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blazecore.util.EntityBodyWriter;
import org.http4s.blazecore.util.Http1Writer;
import org.http4s.blazecore.util.Http1Writer$;
import org.http4s.blazecore.util.IdentityWriter$;
import org.http4s.blazecore.util.package$;
import org.http4s.util.StringWriter;
import org.slf4j.Logger;
import scala.$less$colon$less$;
import scala.Function$;
import scala.Function1;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class IdentityWriter<F>
implements Http1Writer<F> {
    private Promise wroteHeader;
    private final long size;
    private final TailStage<ByteBuffer> out;
    private final Async F;
    private ByteBuffer headers;
    private long bodyBytesWritten;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(IdentityWriter$.class.getDeclaredField("logger$lzy1"));

    public IdentityWriter(long size, TailStage<ByteBuffer> out, Async<F> F) {
        this.size = size;
        this.out = out;
        this.F = F;
        EntityBodyWriter.$init$(this);
        this.headers = null;
        this.bodyBytesWritten = 0L;
        Statics.releaseFence();
    }

    @Override
    public Promise wroteHeader() {
        return this.wroteHeader;
    }

    @Override
    public void org$http4s$blazecore$util$EntityBodyWriter$_setter_$wroteHeader_$eq(Promise x$0) {
        this.wroteHeader = x$0;
    }

    @Override
    public Async<F> F() {
        return this.F;
    }

    private boolean willOverflow(int count) {
        if (this.size < 0L) {
            return false;
        }
        return (long)count + this.bodyBytesWritten > this.size;
    }

    @Override
    public Future<BoxedUnit> writeHeaders(StringWriter headerWriter) {
        this.headers = Http1Writer$.MODULE$.headersToByteBuffer(headerWriter.result());
        return package$.MODULE$.FutureUnit();
    }

    @Override
    public Future<BoxedUnit> writeBodyChunk(Chunk<Object> chunk, boolean flush) {
        if (this.willOverflow(chunk.size())) {
            String msg = new StringBuilder(81).append("Will not write more bytes than what was indicated by the Content-Length header (").append(this.size).append(")").toString();
            Logger Logger_this = IdentityWriter$.MODULE$.org$http4s$blazecore$util$IdentityWriter$$$logger();
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn(msg);
            }
            Chunk<Object> reducedChunk = chunk.take((int)(this.size - this.bodyBytesWritten));
            return this.writeBodyChunk(reducedChunk, true).flatMap((Function1 & Serializable)_$2 -> Future$.MODULE$.failed((Throwable)new IllegalArgumentException(msg)), package$.MODULE$.parasitic());
        }
        ByteBuffer b = chunk.toByteBuffer($less$colon$less$.MODULE$.refl());
        this.bodyBytesWritten += (long)b.remaining();
        if (this.headers != null) {
            ByteBuffer h = this.headers;
            this.headers = null;
            return this.out.channelWrite((Seq<ByteBuffer>)scala.package$.MODULE$.Nil().$colon$colon((Object)b).$colon$colon((Object)h));
        }
        return this.out.channelWrite(b);
    }

    @Override
    public Future<Object> writeEnd(Chunk<Object> chunk) {
        String msg;
        block1: {
            long total = this.bodyBytesWritten + (long)chunk.size();
            if (this.size < 0L || total >= this.size) {
                boolean bl = this.size < 0L;
                return this.writeBodyChunk(chunk, true).map((Function1 & Serializable)y -> BoxesRunTime.unboxToBoolean((Object)Function$.MODULE$.const((Object)BoxesRunTime.boxToBoolean((boolean)bl), y)), package$.MODULE$.parasitic());
            }
            msg = new StringBuilder(58).append("Expected `Content-Length: ").append(this.size).append("` bytes, but only ").append(total).append(" were written.").toString();
            Logger Logger_this = IdentityWriter$.MODULE$.org$http4s$blazecore$util$IdentityWriter$$$logger();
            if (!Logger_this.isWarnEnabled()) break block1;
            Logger_this.warn(msg);
        }
        return this.writeBodyChunk(chunk, true).flatMap((Function1 & Serializable)_$3 -> Future$.MODULE$.failed((Throwable)new IllegalStateException(msg)), package$.MODULE$.parasitic());
    }
}

