/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server;

import cats.effect.SyncIO;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address$;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.http4s.Platform$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.Uri$Authority$;
import org.http4s.Uri$Ipv4Address$;
import org.http4s.Uri$Ipv6Address$;
import org.http4s.Uri$Path$;
import org.http4s.Uri$RegName$;
import org.http4s.Uri$Scheme$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.Function0;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public abstract class Server {
    private final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.server.Server");

    public abstract InetSocketAddress address();

    public SocketAddress<IpAddress> addressIp4s() {
        return SocketAddress$.MODULE$.fromInetSocketAddress(this.address());
    }

    public abstract boolean isSecure();

    public Uri baseUri() {
        Product product;
        Some some = Some$.MODULE$.apply((Object)(this.isSecure() ? Uri$Scheme$.MODULE$.https() : Uri$Scheme$.MODULE$.http()));
        InetAddress inetAddress = this.address().getAddress();
        if (inetAddress instanceof Inet4Address) {
            Inet4Address ipv4 = (Inet4Address)inetAddress;
            product = Uri$Ipv4Address$.MODULE$.apply(Ipv4Address$.MODULE$.fromInet4Address(ipv4));
        } else if (inetAddress instanceof Inet6Address) {
            Inet6Address ipv6 = (Inet6Address)inetAddress;
            product = Uri$Ipv6Address$.MODULE$.apply(Ipv6Address$.MODULE$.fromInet6Address(ipv6));
        } else {
            InetAddress weird = inetAddress;
            ((SyncIO)this.logger.warn((Function0<String>)((Function0 & Serializable)() -> Server.$anonfun$1(weird)))).unsafeRunSync();
            product = Uri$RegName$.MODULE$.apply(weird.getHostAddress());
        }
        Uri.Ipv4Address ipv4Address = product;
        Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.address().getPort()));
        Option<Uri.UserInfo> option = Uri$Authority$.MODULE$.$lessinit$greater$default$1();
        return Uri$.MODULE$.apply((Option<Uri.Scheme>)some, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(option, ipv4Address, (Option<Object>)some2)), Uri$Path$.MODULE$.Root(), Uri$.MODULE$.$lessinit$greater$default$4(), Uri$.MODULE$.$lessinit$greater$default$5());
    }

    private static final String $anonfun$1(InetAddress weird$1) {
        return new StringBuilder(26).append("Unexpected address type ").append(weird$1.getClass()).append(": ").append(weird$1).toString();
    }
}

