/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.websocket.FrameTranscoder$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.package$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class FrameTranscoder {
    private final boolean isClient;

    public FrameTranscoder(boolean isClient) {
        this.isClient = isClient;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public ByteBuffer[] frameToBuffer(WebSocketFrame in) {
        int size = 2;
        if (this.isClient()) {
            size += 4;
        }
        if (in.length() >= 126) {
            size = in.length() <= 65535 ? (size += 2) : (size += 8);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.isClient() ? size + in.length() : size);
        int opcode = in.opcode();
        if (in.length() > 125 && (opcode == package$.MODULE$.PING() || opcode == package$.MODULE$.PONG() || opcode == package$.MODULE$.CLOSE())) {
            throw new TranscodeError(new StringBuilder(36).append("Invalid PING frame: frame too long: ").append(in.length()).toString());
        }
        int b1 = in.last() ? opcode | package$.MODULE$.FINISHED() : opcode;
        buff.put(Predef$.MODULE$.int2Integer(b1).byteValue());
        int b2 = 0;
        if (this.isClient()) {
            b2 = package$.MODULE$.MASK();
        }
        b2 = in.length() < 126 ? (b2 |= in.length()) : (in.length() <= 65535 ? (b2 |= 0x7E) : (b2 |= 0x7F));
        buff.put(Predef$.MODULE$.int2Integer(b2).byteValue());
        if (in.length() > 125 && in.length() <= 65535) {
            buff.put((byte)(in.length() >>> 8 & 0xFF)).put((byte)(in.length() & 0xFF));
        } else if (in.length() > 65535) {
            buff.putLong(in.length());
        }
        if (this.isClient() && in.length() > 0) {
            int mask = (int)(Math.random() * (double)Integer.MAX_VALUE);
            byte[] maskBits = new byte[]{(byte)(mask >>> 24 & 0xFF), (byte)(mask >>> 16 & 0xFF), (byte)(mask >>> 8 & 0xFF), (byte)(mask >>> 0 & 0xFF)};
            buff.put(maskBits);
            ByteVector data = in.data();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), in.length()).foreach((Function1 & Serializable)i -> buff.put((byte)(data.apply(BoxesRunTime.unboxToInt((Object)i)) ^ maskBits[BoxesRunTime.unboxToInt((Object)i) & 3])));
            buff.flip();
            return new ByteBuffer[]{buff};
        }
        buff.flip();
        return new ByteBuffer[]{buff, in.data().toByteBuffer()};
    }

    public WebSocketFrame bufferToFrame(ByteBuffer in) {
        byte[] byArray;
        boolean masked;
        if (in.remaining() < 2 || FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$$getMsgLength(in) < 0) {
            return null;
        }
        int opcode = in.get(0) & package$.MODULE$.OP_CODE();
        boolean finished = (in.get(0) & package$.MODULE$.FINISHED()) != 0;
        boolean bl = masked = (in.get(1) & package$.MODULE$.MASK()) != 0;
        if (masked && this.isClient()) {
            throw new TranscodeError("Client received a masked message");
        }
        int bodyOffset = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$$lengthOffset(in);
        if (masked) {
            bodyOffset += 4;
            byArray = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$$getMask(in);
        } else {
            byArray = null;
        }
        byte[] m = byArray;
        int oldLim = in.limit();
        int bodylen = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$$bodyLength(in);
        in.position(bodyOffset);
        in.limit(in.position() + bodylen);
        ByteBuffer slice = in.slice();
        in.position(in.limit());
        in.limit(oldLim);
        return package$.MODULE$.makeFrame(opcode, ByteVector$.MODULE$.view(FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$$decodeBinary(slice, m)), finished);
    }

    public static final class TranscodeError
    extends Exception {
        private final String message;

        public TranscodeError(String message) {
            this.message = message;
            super(message);
        }

        public String message() {
            return this.message;
        }
    }
}

