/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.statistics;

import java.io.Serializable;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.openmole.tool.dtw.dtw.DTW;
import org.openmole.tool.dtw.dtw.FastDTW;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;
import org.openmole.tool.dtw.util.DistanceFunctionFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface Stat {
    public static double head$(Stat $this, Seq sequence) {
        return $this.head((Seq<Object>)sequence);
    }

    default public double head(Seq<Object> sequence) {
        return BoxesRunTime.unboxToDouble((Object)sequence.head());
    }

    public static double sum$(Stat $this, Seq sequence) {
        return $this.sum((Seq<Object>)sequence);
    }

    default public double sum(Seq<Object> sequence) {
        return BoxesRunTime.unboxToDouble((Object)sequence.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static Seq normalise$(Stat $this, Seq p) {
        return $this.normalise((Seq<Object>)p);
    }

    default public Seq<Object> normalise(Seq<Object> p) {
        double sum = BoxesRunTime.unboxToDouble((Object)p.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (Seq)p.map((Function1)(JFunction1.mcDD.sp & Serializable)_$1 -> _$1 / sum);
    }

    public static double median$(Stat $this, Seq sequence) {
        return $this.median((Seq<Object>)sequence);
    }

    default public double median(Seq<Object> sequence) {
        Object object = Predef$.MODULE$.doubleArrayOps((double[])sequence.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        Object object2 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.filterNot$extension(object, (Function1)(JFunction1.mcZD.sp & Serializable)_$2 -> Predef$.MODULE$.double2Double(_$2).isNaN()));
        double[] sortedSerie = (double[])ArrayOps$.MODULE$.sorted$extension(object2, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        Object object3 = Predef$.MODULE$.doubleArrayOps(sortedSerie);
        int size = ArrayOps$.MODULE$.size$extension(object3);
        if (size == sequence.size()) {
            if (size % 2 == 0) {
                return (sortedSerie[size / 2] + sortedSerie[size / 2 - 1]) / (double)2;
            }
            return sortedSerie[size / 2];
        }
        return Double.NaN;
    }

    public static double medianAbsoluteDeviation$(Stat $this, Seq sequence) {
        return $this.medianAbsoluteDeviation((Seq<Object>)sequence);
    }

    default public double medianAbsoluteDeviation(Seq<Object> sequence) {
        double m = this.median(sequence);
        return this.median((Seq<Object>)((Seq)sequence.map((Function1)(JFunction1.mcDD.sp & Serializable)v -> package$.MODULE$.abs(v - m))));
    }

    public static double average$(Stat $this, Seq sequence) {
        return $this.average((Seq<Object>)sequence);
    }

    default public double average(Seq<Object> sequence) {
        return BoxesRunTime.unboxToDouble((Object)sequence.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)sequence.size();
    }

    public static double meanSquaredError$(Stat $this, Seq sequence) {
        return $this.meanSquaredError((Seq<Object>)sequence);
    }

    default public double meanSquaredError(Seq<Object> sequence) {
        return this.variance(sequence);
    }

    public static double variance$(Stat $this, Seq sequence) {
        return $this.variance((Seq<Object>)sequence);
    }

    default public double variance(Seq<Object> sequence) {
        double avg = this.average(sequence);
        return this.average((Seq<Object>)((Seq)sequence.map((Function1)(JFunction1.mcDD.sp & Serializable)v -> package$.MODULE$.pow(v - avg, 2.0))));
    }

    public static double rootMeanSquaredError$(Stat $this, Seq sequence) {
        return $this.rootMeanSquaredError((Seq<Object>)sequence);
    }

    default public double rootMeanSquaredError(Seq<Object> sequence) {
        return this.standardDeviation(sequence);
    }

    public static double standardDeviation$(Stat $this, Seq sequence) {
        return $this.standardDeviation((Seq<Object>)sequence);
    }

    default public double standardDeviation(Seq<Object> sequence) {
        return package$.MODULE$.sqrt(this.variance(sequence));
    }

    public static Seq normalize$(Stat $this, Seq sequence) {
        return $this.normalize((Seq<Object>)sequence);
    }

    default public Seq<Object> normalize(Seq<Object> sequence) {
        double sum = BoxesRunTime.unboxToDouble((Object)sequence.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (Seq)sequence.map((Function1)(JFunction1.mcDD.sp & Serializable)_$3 -> _$3 / sum);
    }

    public static double absoluteDistance$(Stat $this, Seq v1, Seq v2) {
        return $this.absoluteDistance((Seq<Object>)v1, (Seq<Object>)v2);
    }

    default public double absoluteDistance(Seq<Object> v1, Seq<Object> v2) {
        DoubleRef distance = DoubleRef.create((double)0.0);
        ((IterableOnceOps)v1.zip(v2)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double v1v = tuple2._1$mcD$sp();
                double v2v = tuple2._2$mcD$sp();
                distance$1.elem += Math.abs(v1v - v2v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return distance.elem;
    }

    public static double squareDistance$(Stat $this, Seq v1, Seq v2) {
        return $this.squareDistance((Seq<Object>)v1, (Seq<Object>)v2);
    }

    default public double squareDistance(Seq<Object> v1, Seq<Object> v2) {
        DoubleRef distance = DoubleRef.create((double)0.0);
        ((IterableOnceOps)v1.zip(v2)).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                double v1v = tuple2._1$mcD$sp();
                double v2v = tuple2._2$mcD$sp();
                distance$2.elem += Math.pow(v1v - v2v, 2.0);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return distance.elem;
    }

    public static double dynamicTimeWarpingDistance$(Stat $this, Seq v1, Seq v2, boolean fast) {
        return $this.dynamicTimeWarpingDistance((Seq<Object>)v1, (Seq<Object>)v2, fast);
    }

    default public double dynamicTimeWarpingDistance(Seq<Object> v1, Seq<Object> v2, boolean fast) {
        TimeSeries ta = new TimeSeries((double[])v1.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        TimeSeries tb = new TimeSeries((double[])v2.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        DistanceFunction df = DistanceFunctionFactory.EUCLIDEAN_DIST_FN;
        if (fast) {
            return FastDTW.getWarpDistBetween((TimeSeries)ta, (TimeSeries)tb, (DistanceFunction)df);
        }
        return DTW.getWarpDistBetween((TimeSeries)ta, (TimeSeries)tb, (DistanceFunction)df);
    }

    public static boolean dynamicTimeWarpingDistance$default$3$(Stat $this) {
        return $this.dynamicTimeWarpingDistance$default$3();
    }

    default public boolean dynamicTimeWarpingDistance$default$3() {
        return true;
    }

    public static double confidenceInterval$(Stat $this, Seq sequence, double p) {
        return $this.confidenceInterval((Seq<Object>)sequence, p);
    }

    default public double confidenceInterval(Seq<Object> sequence, double p) {
        int n = sequence.size();
        int df = n - 1;
        if (df < 1) {
            return 0.0;
        }
        double pp = 1.0 - (1.0 - p) / 2.0;
        double t = Stat.studentTInv$1(pp, df);
        return t * this.rootMeanSquaredError(sequence) / package$.MODULE$.sqrt((double)n);
    }

    public static double confidenceInterval$default$2$(Stat $this) {
        return $this.confidenceInterval$default$2();
    }

    default public double confidenceInterval$default$2() {
        return 0.95;
    }

    public static Option ksTest$(Stat $this, Seq d1, Seq d2) {
        return $this.ksTest((Seq<Object>)d1, (Seq<Object>)d2);
    }

    default public Option<Object> ksTest(Seq<Object> d1, Seq<Object> d2) {
        return this.kolmogorovSmirnovTest(d1, d2);
    }

    public static Option kolmogorovSmirnovTest$(Stat $this, Seq d1, Seq d2) {
        return $this.kolmogorovSmirnovTest((Seq<Object>)d1, (Seq<Object>)d2);
    }

    default public Option<Object> kolmogorovSmirnovTest(Seq<Object> d1, Seq<Object> d2) {
        if (d1.size() < 2 || d2.size() < 2) {
            return None$.MODULE$;
        }
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)test.kolmogorovSmirnovTest((double[])this.normalise(d1).toArray(ClassTag$.MODULE$.apply(Double.TYPE)), (double[])this.normalise(d2).toArray(ClassTag$.MODULE$.apply(Double.TYPE)))));
    }

    public static double ksDivergence$(Stat $this, Seq p, Seq q) {
        return $this.ksDivergence((Seq<Object>)p, (Seq<Object>)q);
    }

    default public double ksDivergence(Seq<Object> p, Seq<Object> q) {
        return this.kolmogorovSmirnovDivergence(p, q);
    }

    public static double kolmogorovSmirnovDivergence$(Stat $this, Seq p, Seq q) {
        return $this.kolmogorovSmirnovDivergence((Seq<Object>)p, (Seq<Object>)q);
    }

    default public double kolmogorovSmirnovDivergence(Seq<Object> p, Seq<Object> q) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)this.normalise(p).zip(this.normalise(q))).map((Function1 & Serializable)x$1 -> {
            double x = x$1._1$mcD$sp();
            double y = x$1._2$mcD$sp();
            return package$.MODULE$.abs(x - y);
        })).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
    }

    public static Option ksTestGaussian$(Stat $this, Seq data, double mu, double sigma) {
        return $this.ksTestGaussian((Seq<Object>)data, mu, sigma);
    }

    default public Option<Object> ksTestGaussian(Seq<Object> data, double mu, double sigma) {
        if (data.size() < 2) {
            return None$.MODULE$;
        }
        KolmogorovSmirnovTest test = new KolmogorovSmirnovTest();
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)test.kolmogorovSmirnovTest((RealDistribution)new NormalDistribution(null, mu, sigma), (double[])data.toArray(ClassTag$.MODULE$.apply(Double.TYPE)))));
    }

    public static double klDivergence$(Stat $this, Seq p1, Seq p2) {
        return $this.klDivergence((Seq<Object>)p1, (Seq<Object>)p2);
    }

    default public double klDivergence(Seq<Object> p1, Seq<Object> p2) {
        return this.kullbackLeiblerDivergence(p1, p2, this.kullbackLeiblerDivergence$default$3());
    }

    public static double kullbackLeiblerDivergence$(Stat $this, Seq p, Seq q, Option epsilon) {
        return $this.kullbackLeiblerDivergence((Seq<Object>)p, (Seq<Object>)q, (Option<Object>)epsilon);
    }

    default public double kullbackLeiblerDivergence(Seq<Object> p, Seq<Object> q, Option<Object> epsilon) {
        double epsilonValue = BoxesRunTime.unboxToDouble((Object)epsilon.map((Function1)(JFunction1.mcDD.sp & Serializable)e -> Math.max(0.0, e)).getOrElse(Stat::$anonfun$3));
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)this.normalise(p).zip(this.normalise(q))).map((Function1 & Serializable)x$1 -> {
            double x = x$1._1$mcD$sp();
            double y = x$1._2$mcD$sp();
            double yValue = Math.max(epsilonValue, y);
            if (yValue == 0.0 || x == 0.0) {
                return 0.0;
            }
            return x * package$.MODULE$.log(x / yValue);
        })).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public static Option kullbackLeiblerDivergence$default$3$(Stat $this) {
        return $this.kullbackLeiblerDivergence$default$3();
    }

    default public Option<Object> kullbackLeiblerDivergence$default$3() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0E-10));
    }

    public static double jeffreysDivergence$(Stat $this, Seq p, Seq q, Option epsilon) {
        return $this.jeffreysDivergence((Seq<Object>)p, (Seq<Object>)q, (Option<Object>)epsilon);
    }

    default public double jeffreysDivergence(Seq<Object> p, Seq<Object> q, Option<Object> epsilon) {
        return this.kullbackLeiblerDivergence(p, q, epsilon) + this.kullbackLeiblerDivergence(q, p, epsilon);
    }

    public static Option jeffreysDivergence$default$3$(Stat $this) {
        return $this.jeffreysDivergence$default$3();
    }

    default public Option<Object> jeffreysDivergence$default$3() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0E-10));
    }

    public static List probabilityDistribution$(Stat $this, Seq s, int beans) {
        return $this.probabilityDistribution((Seq<Object>)s, beans);
    }

    default public List<Object> probabilityDistribution(Seq<Object> s, int beans) {
        Seq ssorted = (Seq)s.sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
        double smin = BoxesRunTime.unboxToDouble((Object)ssorted.head());
        double smax = BoxesRunTime.unboxToDouble((Object)ssorted.last());
        double step = (smax - smin) / (double)beans;
        int size = ssorted.size();
        return Stat.recurse$1(step, smax, BigDecimal$.MODULE$.apply(smin), ssorted.toList(), (List)Nil$.MODULE$).map((Function1)(JFunction1.mcDI.sp & Serializable)_$6 -> (double)_$6 / (double)size);
    }

    public static double percentile$(Stat $this, Seq s, double n) {
        return $this.percentile((Seq<Object>)s, n);
    }

    default public double percentile(Seq<Object> s, double n) {
        return BoxesRunTime.unboxToDouble((Object)this.percentile(s, (Seq<Object>)((Seq)((SeqOps)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)n), (List)Nil$.MODULE$)))).head());
    }

    public static Seq percentile$(Stat $this, Seq s, Seq n) {
        return $this.percentile((Seq<Object>)s, (Seq<Object>)n);
    }

    default public Seq<Object> percentile(Seq<Object> s, Seq<Object> n2) {
        Percentile c = new Percentile();
        c.setData((double[])s.toArray(ClassTag$.MODULE$.apply(Double.TYPE)));
        return (Seq)n2.map((Function1)(JFunction1.mcDD.sp & Serializable)n -> c.evaluate(n));
    }

    private static double normalInv$1(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("parameter p must be in the range [0, 1]");
        }
        double[] a = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
        double[] b = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
        double[] c = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
        double[] d = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
        double plow = 0.02425;
        double phigh = 1.0 - plow;
        if (p < plow) {
            double q = package$.MODULE$.sqrt((double)-2 * package$.MODULE$.log(p));
            return (((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0);
        }
        if (phigh < p) {
            double q = package$.MODULE$.sqrt((double)-2 * package$.MODULE$.log(1.0 - p));
            return -(((((c[0] * q + c[1]) * q + c[2]) * q + c[3]) * q + c[4]) * q + c[5]) / ((((d[0] * q + d[1]) * q + d[2]) * q + d[3]) * q + 1.0);
        }
        double q = p - 0.5;
        double r = q * q;
        return (((((a[0] * r + a[1]) * r + a[2]) * r + a[3]) * r + a[4]) * r + a[5]) * q / (((((b[0] * r + b[1]) * r + b[2]) * r + b[3]) * r + b[4]) * r + 1.0);
    }

    private static double normalInv$default$1$1() {
        return 0.95;
    }

    private static double studentTInv$1(double p, int df) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("parameter p must be in the range [0, 1]");
        }
        if (df <= 0) {
            throw new IllegalArgumentException("parameter df must be positive");
        }
        double z1 = package$.MODULE$.abs(Stat.normalInv$1(p));
        double z2 = z1 * z1;
        double[] h = new double[]{0.25 * z1 * (z2 + 1.0), 0.010416667 * z1 * ((5.0 * z2 + 16.0) * z2 + 3.0), 0.002604167 * z1 * (((3.0 * z2 + 19.0) * z2 + 17.0) * z2 - 15.0), 1.0851E-5 * z1 * ((((79.0 * z2 + 776.0) * z2 + 1482.0) * z2 - 1920.0) * z2 - 945.0)};
        DoubleRef x = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(h.length - 1), 0).by(-1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            x$1.elem = (x$1.elem + h[i]) / (double)df;
        });
        if (p >= 0.5) {
            return z1 + x.elem;
        }
        return -(z1 + x.elem);
    }

    private static double studentTInv$default$1$1() {
        return 0.95;
    }

    private static int studentTInv$default$2$1() {
        return 10;
    }

    private static double $anonfun$3() {
        return 0.0;
    }

    private static int bean$1(List ssorted$tailLocal1$1, BigDecimal highBound$1) {
        return ssorted$tailLocal1$1.takeWhile((Function1)(JFunction1.mcZD.sp & Serializable)_$4 -> BigDecimal$.MODULE$.double2bigDecimal(_$4).$less$eq((Object)highBound$1)).size();
    }

    private static List recurse$1(double step$1, double smax$1, BigDecimal lowBound, List ssorted, List beans) {
        while (true) {
            BigDecimal highBound;
            if ((highBound = lowBound.$plus(BigDecimal$.MODULE$.double2bigDecimal(step$1))).$greater$eq((Object)BigDecimal$.MODULE$.double2bigDecimal(smax$1))) {
                int n = ssorted.size();
                return beans.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).reverse();
            }
            BigDecimal bigDecimal = highBound;
            List list = (List)ssorted.dropWhile((Function1)(JFunction1.mcZD.sp & Serializable)_$5 -> BigDecimal$.MODULE$.double2bigDecimal(_$5).$less$eq((Object)highBound));
            int n = Stat.bean$1(ssorted, highBound);
            List list2 = beans.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            lowBound = bigDecimal;
            ssorted = list;
            beans = list2;
        }
    }
}

