/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.InputStream;
import org.json4s.AsJsonInput;
import org.json4s.AsJsonInput$;
import org.json4s.FileInput;
import org.json4s.FileInput$;
import org.json4s.JValue;
import org.json4s.JsonInput;
import org.json4s.MappingException;
import org.json4s.Reader;
import org.json4s.ReaderInput;
import org.json4s.ReaderInput$;
import org.json4s.StreamInput;
import org.json4s.StreamInput$;
import org.json4s.StringInput;
import org.json4s.StringInput$;
import org.json4s.Writer;
import org.json4s.jackson.Json4sScalaModule;
import org.json4s.jackson.JsonMethods$;
import org.json4s.prefs.EmptyValueStrategy;
import org.json4s.prefs.EmptyValueStrategy$;
import scala.MatchError;
import scala.Option;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

public interface JsonMethods
extends org.json4s.JsonMethods<JValue> {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(JsonMethods$.class, "0bitmap$1");

    public static void $init$(JsonMethods $this) {
    }

    public static ObjectMapper org$json4s$jackson$JsonMethods$$_defaultMapper$(JsonMethods $this) {
        return $this.org$json4s$jackson$JsonMethods$$_defaultMapper();
    }

    /*
     * WARNING - void declaration
     */
    default public ObjectMapper org$json4s$jackson$JsonMethods$$_defaultMapper() {
        void var1_1;
        ObjectMapper m = new ObjectMapper();
        m.registerModule((Module)new Json4sScalaModule());
        m.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true);
        return var1_1;
    }

    public static ObjectMapper mapper$(JsonMethods $this) {
        return $this.mapper();
    }

    default public ObjectMapper mapper() {
        return this.org$json4s$jackson$JsonMethods$$_defaultMapper();
    }

    public static JValue parse$(JsonMethods $this, Object in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput evidence$1) {
        return $this.parse(in, useBigDecimalForDouble, useBigIntForLong, evidence$1);
    }

    @Override
    default public <A> JValue parse(A in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput<A> evidence$1) {
        JValue jValue;
        ObjectReader reader = this.mapper().readerFor(JValue.class);
        reader = useBigDecimalForDouble ? reader.with(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) : reader.without(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        reader = useBigIntForLong ? reader.with(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS) : reader.without(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS);
        JsonInput jsonInput = AsJsonInput$.MODULE$.asJsonInput(in, evidence$1);
        if (jsonInput instanceof StringInput) {
            String string;
            StringInput stringInput = StringInput$.MODULE$.unapply((StringInput)jsonInput);
            String s = string = stringInput._1();
            jValue = (JValue)reader.readValue(s);
        } else if (jsonInput instanceof ReaderInput) {
            java.io.Reader reader2;
            ReaderInput readerInput = ReaderInput$.MODULE$.unapply((ReaderInput)jsonInput);
            java.io.Reader rdr = reader2 = readerInput._1();
            jValue = (JValue)reader.readValue(rdr);
        } else if (jsonInput instanceof StreamInput) {
            InputStream inputStream;
            StreamInput streamInput = StreamInput$.MODULE$.unapply((StreamInput)jsonInput);
            InputStream stream = inputStream = streamInput._1();
            jValue = (JValue)reader.readValue(stream);
        } else if (jsonInput instanceof FileInput) {
            File file;
            FileInput fileInput = FileInput$.MODULE$.unapply((FileInput)jsonInput);
            File file2 = file = fileInput._1();
            jValue = (JValue)reader.readValue(file2);
        } else {
            throw new MatchError((Object)jsonInput);
        }
        return jValue;
    }

    public static boolean parse$default$2$(JsonMethods $this) {
        return $this.parse$default$2();
    }

    @Override
    default public boolean parse$default$2() {
        return false;
    }

    public static boolean parse$default$3$(JsonMethods $this) {
        return $this.parse$default$3();
    }

    @Override
    default public boolean parse$default$3() {
        return true;
    }

    public static Option parseOpt$(JsonMethods $this, Object in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput evidence$2) {
        return $this.parseOpt(in, useBigDecimalForDouble, useBigIntForLong, evidence$2);
    }

    @Override
    default public <A> Option<JValue> parseOpt(A in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput<A> evidence$2) {
        return Exception$.MODULE$.allCatch().opt(() -> this.parseOpt$$anonfun$1(in, useBigDecimalForDouble, useBigIntForLong, evidence$2));
    }

    public static boolean parseOpt$default$2$(JsonMethods $this) {
        return $this.parseOpt$default$2();
    }

    @Override
    default public boolean parseOpt$default$2() {
        return false;
    }

    public static boolean parseOpt$default$3$(JsonMethods $this) {
        return $this.parseOpt$default$3();
    }

    @Override
    default public boolean parseOpt$default$3() {
        return true;
    }

    public static JValue render$(JsonMethods $this, JValue value, boolean alwaysEscapeUnicode, EmptyValueStrategy emptyValueStrategy) {
        return $this.render(value, alwaysEscapeUnicode, emptyValueStrategy);
    }

    @Override
    default public JValue render(JValue value, boolean alwaysEscapeUnicode, EmptyValueStrategy emptyValueStrategy) {
        if (this.mapper().isEnabled(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature()) != alwaysEscapeUnicode) {
            this.mapper().getFactory().configure(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature(), alwaysEscapeUnicode);
        }
        return emptyValueStrategy.replaceEmpty(value);
    }

    public static boolean render$default$2$(JsonMethods $this) {
        return $this.render$default$2();
    }

    @Override
    default public boolean render$default$2() {
        return false;
    }

    public static EmptyValueStrategy render$default$3$(JsonMethods $this) {
        return $this.render$default$3();
    }

    @Override
    default public EmptyValueStrategy render$default$3() {
        return EmptyValueStrategy$.MODULE$.default();
    }

    public static String compact$(JsonMethods $this, JValue d) {
        return $this.compact(d);
    }

    @Override
    default public String compact(JValue d) {
        return this.mapper().writeValueAsString((Object)d);
    }

    public static String pretty$(JsonMethods $this, JValue d) {
        return $this.pretty(d);
    }

    @Override
    default public String pretty(JValue d) {
        ObjectWriter writer = this.mapper().writerWithDefaultPrettyPrinter();
        return writer.writeValueAsString((Object)d);
    }

    public static JValue asJValue$(JsonMethods $this, Object obj, Writer writer) {
        return $this.asJValue(obj, writer);
    }

    default public <T> JValue asJValue(T obj, Writer<T> writer) {
        return writer.write(obj);
    }

    public static Object fromJValue$(JsonMethods $this, JValue json, Reader reader) {
        return $this.fromJValue(json, reader);
    }

    default public <T> T fromJValue(JValue json, Reader<T> reader) {
        Either<MappingException, T> either = reader.readEither(json);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                MappingException x = (MappingException)((Left)either).value();
                throw x;
            }
            throw new MatchError(either);
        }
        Object x = ((Right)either).value();
        return (T)x;
    }

    public static JsonNode asJsonNode$(JsonMethods $this, JValue jv) {
        return $this.asJsonNode(jv);
    }

    default public JsonNode asJsonNode(JValue jv) {
        return this.mapper().valueToTree((Object)jv);
    }

    public static JValue fromJsonNode$(JsonMethods $this, JsonNode jn) {
        return $this.fromJsonNode(jn);
    }

    default public JValue fromJsonNode(JsonNode jn) {
        return (JValue)this.mapper().treeToValue((TreeNode)jn, JValue.class);
    }

    private JValue parseOpt$$anonfun$1(Object in$1, boolean useBigDecimalForDouble$1, boolean useBigIntForLong$1, AsJsonInput evidence$2$1) {
        return this.parse(in$1, useBigDecimalForDouble$1, useBigIntForLong$1, evidence$2$1);
    }
}

