/*
 * Decompiled with CFR 0.152.
 */
package gears.async;

import gears.async.Scheduler;
import gears.async.Suspension;
import gears.async.VThreadScheduler$;
import gears.async.VThreadSupport$;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;

public final class VThreadSupport {
    public static <R> R boundary(Function1<VThreadLabel<R>, R> function1) {
        return VThreadSupport$.MODULE$.boundary(function1);
    }

    public static /* synthetic */ void resumeAsync(Suspension suspension, Object object, Scheduler scheduler) {
        VThreadSupport$.MODULE$.resumeAsync(suspension, object, scheduler);
    }

    public static <T, R> void resumeAsync(VThreadSuspension<T, R> vThreadSuspension, T t, VThreadScheduler$ vThreadScheduler$) {
        VThreadSupport$.MODULE$.resumeAsync(vThreadSuspension, t, vThreadScheduler$);
    }

    public static /* synthetic */ void scheduleBoundary(Function1 function1, Scheduler scheduler) {
        VThreadSupport$.MODULE$.scheduleBoundary(function1, scheduler);
    }

    public static void scheduleBoundary(Function1<VThreadLabel<BoxedUnit>, BoxedUnit> function1, VThreadScheduler$ vThreadScheduler$) {
        VThreadSupport$.MODULE$.scheduleBoundary(function1, vThreadScheduler$);
    }

    public static <T, R> T suspend(Function1<VThreadSuspension<T, R>, R> function1, VThreadLabel<R> vThreadLabel) {
        return VThreadSupport$.MODULE$.suspend(function1, vThreadLabel);
    }

    public static final class VThreadLabel<R> {
        private Option<R> result = None$.MODULE$;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();

        public void clearResult() {
            this.lock.lock();
            this.result = None$.MODULE$;
            this.lock.unlock();
        }

        public void setResult(R data) {
            this.lock.lock();
            try {
                this.result = Some$.MODULE$.apply(data);
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public R waitResult() {
            Object object;
            this.lock.lock();
            try {
                while (this.result.isEmpty()) {
                    this.cond.await();
                }
                object = this.result.get();
            }
            finally {
                this.lock.unlock();
            }
            return (R)object;
        }
    }

    public static final class VThreadSuspension<T, R>
    implements Suspension<T, R> {
        private final VThreadLabel l;
        private Option<T> nextInput;
        private final ReentrantLock lock;
        private final Condition cond;

        public VThreadSuspension(VThreadLabel<R> l) {
            this.l = l;
            this.nextInput = None$.MODULE$;
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
        }

        public VThreadLabel<R> l() {
            return this.l;
        }

        public void setInput(T data) {
            this.lock.lock();
            try {
                this.nextInput = Some$.MODULE$.apply(data);
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public T waitInput() {
            Object object;
            this.lock.lock();
            try {
                while (this.nextInput.isEmpty()) {
                    this.cond.await();
                }
                object = this.nextInput.get();
            }
            finally {
                this.lock.unlock();
            }
            return (T)object;
        }

        @Override
        public R resume(T arg) {
            this.l().clearResult();
            this.setInput(arg);
            return this.l().waitResult();
        }
    }
}

