/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import jsat.DataStore;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.SparseVector;
import jsat.linear.SubVector;
import jsat.linear.Vec;
import jsat.math.OnLineStatistics;
import jsat.utils.IntList;

public class ColumnMajorStore
implements DataStore {
    private boolean sparse;
    int size = 0;
    List<Vec> columns;
    List<IntList> cat_columns;
    CategoricalData[] cat_info;

    public ColumnMajorStore(boolean sparse) {
        this(0, null, sparse);
    }

    public ColumnMajorStore() {
        this(0, null);
    }

    @Override
    public CategoricalData[] getCategoricalDataInfo() {
        return this.cat_info;
    }

    public ColumnMajorStore(int numNumeric, CategoricalData[] cat_info) {
        this(numNumeric, cat_info, true);
    }

    public ColumnMajorStore(int numNumeric, CategoricalData[] cat_info, boolean sparse) {
        int i;
        this.columns = new ArrayList<Vec>(numNumeric);
        for (i = 0; i < numNumeric; ++i) {
            this.columns.add(sparse ? new SparseVector(10) : new DenseVector(10));
        }
        this.cat_info = cat_info;
        this.cat_columns = new ArrayList<IntList>();
        for (i = 0; i < (cat_info == null ? 0 : cat_info.length); ++i) {
            this.cat_columns.add(new IntList());
        }
        this.sparse = sparse;
    }

    public ColumnMajorStore(ColumnMajorStore toCopy) {
        this.columns = new ArrayList<Vec>(toCopy.columns.size());
        for (Vec v : toCopy.columns) {
            this.columns.add(v.clone());
        }
        this.cat_columns = new ArrayList<IntList>(toCopy.cat_columns.size());
        for (IntList cv : toCopy.cat_columns) {
            this.cat_columns.add(new IntList(cv));
        }
        if (toCopy.cat_info != null) {
            this.cat_info = CategoricalData.copyOf(toCopy.cat_info);
        }
        this.size = toCopy.size;
        this.sparse = toCopy.sparse;
    }

    @Override
    public boolean rowMajor() {
        return false;
    }

    @Override
    public void setCategoricalDataInfo(CategoricalData[] cat_info) {
        this.cat_info = cat_info;
    }

    @Override
    public int numCategorical() {
        return this.cat_columns.size();
    }

    @Override
    public int numNumeric() {
        return this.columns.size();
    }

    @Override
    public void setNumNumeric(int d) {
        if (d < 0) {
            throw new RuntimeException("Can not store a negative number of features (" + d + ")");
        }
        while (this.columns.size() < d) {
            this.columns.add(this.sparse ? new SparseVector(10) : new DenseVector(10));
        }
        while (this.columns.size() > d) {
            this.columns.remove(this.columns.size() - 1);
        }
    }

    @Override
    public void addDataPoint(DataPoint dp) {
        IntList col;
        int d;
        Vec x = dp.getNumericalValues();
        int[] x_c = dp.getCategoricalValues();
        int pos = this.size++;
        while (this.columns.size() < x.length()) {
            this.columns.add(this.sparse ? new SparseVector(this.size) : new DenseVector(this.size));
        }
        while (this.cat_columns.size() < x_c.length) {
            Object newCol = new int[this.size];
            Arrays.fill((int[])newCol, -1);
            this.cat_columns.add(IntList.view((int[])newCol));
        }
        for (IndexValue iv : x) {
            int d2 = iv.getIndex();
            double v = iv.getValue();
            Vec x_d = this.columns.get(d2);
            if (x_d.length() <= pos) {
                x_d.setLength(this.size * 2);
            }
            x_d.set(pos, v);
        }
        for (d = 0; d < x_c.length; ++d) {
            col = this.cat_columns.get(d);
            while (col.size() <= pos) {
                col.add(-1);
            }
            col.set(pos, x_c[d]);
        }
        for (d = x_c.length; d < this.cat_columns.size(); ++d) {
            col = this.cat_columns.get(d);
            while (col.size() <= pos) {
                col.add(-1);
            }
        }
    }

    @Override
    public Vec getNumericColumn(int i) {
        return this.columns.get(i);
    }

    @Override
    public DataPoint getDataPoint(int i) {
        int j;
        if (i >= this.size) {
            throw new IndexOutOfBoundsException("Requested datapoint " + i + " but index has only " + this.size + " datums");
        }
        int d_n = this.numNumeric();
        int d_c = this.numCategorical();
        Vec x = this.sparse ? new SparseVector(d_n) : new DenseVector(d_n);
        int[] cat = new int[d_c];
        for (j = 0; j < d_n; ++j) {
            Vec col_j = this.columns.get(j);
            if (col_j.length() <= i) continue;
            x.set(j, col_j.get(i));
        }
        for (j = 0; j < d_c; ++j) {
            cat[j] = this.cat_columns.get(j).get(i);
        }
        if (this.sparse && x.nnz() > d_n / 2) {
            x = new DenseVector(x);
        }
        return new DataPoint(x, cat, this.cat_info);
    }

    @Override
    public void setDataPoint(int i, DataPoint dp) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException("Requested datapoint " + i + " but index has only " + this.size + " datums");
        }
        int d_n = this.numNumeric();
        int d_c = this.numCategorical();
        Vec x = dp.getNumericalValues();
        int[] cat = dp.getCategoricalValues();
        for (int j = 0; j < d_n; ++j) {
            Vec tmp = this.columns.get(j);
            tmp.set(i, 0.0);
        }
        for (IndexValue iv : x) {
            this.columns.get(iv.getIndex()).set(i, iv.getValue());
        }
        for (int j = 0; j < d_c; ++j) {
            this.cat_columns.get(j).set(i, cat[j]);
        }
    }

    @Override
    public void finishAdding() {
        if (this.cat_info == null) {
            this.cat_info = new CategoricalData[this.numCategorical()];
            for (int j = 0; j < this.cat_info.length; ++j) {
                int options = this.cat_columns.get(j).streamInts().max().orElse(1);
                this.cat_info[j] = new CategoricalData(Math.max(options, 1));
            }
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Vec v = this.columns.get(i);
            v.setLength(this.size);
        }
    }

    @Override
    public Vec[] getNumericColumns(Set<Integer> skipColumns) {
        Vec[] toRet = new Vec[this.numNumeric()];
        for (int j = 0; j < toRet.length; ++j) {
            if (skipColumns.contains(j)) continue;
            toRet[j] = this.columns.get(j);
            if (toRet[j].length() == this.size()) continue;
            toRet[j] = new SubVector(0, this.size, toRet[j]);
        }
        return toRet;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public OnLineStatistics getSparsityStats() {
        OnLineStatistics stats = new OnLineStatistics();
        for (Vec v : this.columns) {
            if (v.isSparse()) {
                stats.add((double)v.nnz() / (double)this.size);
                continue;
            }
            stats.add(1.0);
        }
        return stats;
    }

    @Override
    public ColumnMajorStore clone() {
        return new ColumnMajorStore(this);
    }

    @Override
    public ColumnMajorStore emptyClone() {
        return new ColumnMajorStore(this.columns.size(), this.cat_info, this.sparse);
    }

    @Override
    public int[] getCatColumn(int i) {
        if (i < 0 || i >= this.numCategorical()) {
            throw new IndexOutOfBoundsException("There is no index for column " + i);
        }
        return Arrays.copyOf(this.cat_columns.get(i).streamInts().toArray(), this.size());
    }
}

