/*
 * Decompiled with CFR 0.152.
 */
package jsat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jsat.DataSet;
import jsat.DataStore;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.regression.RegressionDataSet;

public class SimpleDataSet
extends DataSet<SimpleDataSet> {
    public SimpleDataSet(List<DataPoint> datapoints) {
        super(datapoints.get(0).numNumericalValues(), datapoints.get(0).getCategoricalData());
        for (DataPoint dp : datapoints) {
            this.add(dp);
        }
    }

    public SimpleDataSet(DataStore datapoints) {
        super(datapoints);
    }

    public SimpleDataSet(int numerical, CategoricalData[] categories) {
        super(numerical, categories);
    }

    public void add(DataPoint dp) {
        this.base_add(dp, 1.0);
    }

    @Override
    protected SimpleDataSet getSubset(List<Integer> indicies) {
        if (this.datapoints.rowMajor()) {
            SimpleDataSet newData = new SimpleDataSet(this.numNumerVals, this.categories);
            for (int i : indicies) {
                newData.add(this.getDataPoint(i));
            }
            return newData;
        }
        int new_n = indicies.size();
        HashMap<Integer, Integer> old_indx_to_new = new HashMap<Integer, Integer>(indicies.size());
        for (int new_i = 0; new_i < indicies.size(); ++new_i) {
            old_indx_to_new.put(indicies.get(new_i), new_i);
        }
        DataStore new_ds = this.datapoints.emptyClone();
        Iterator<DataPoint> data_iter = this.datapoints.getRowIter();
        int orig_pos = 0;
        while (data_iter.hasNext()) {
            DataPoint dp = data_iter.next();
            if (old_indx_to_new.containsKey(orig_pos)) {
                DataPoint new_dp = new DataPoint(dp.getNumericalValues().clone(), Arrays.copyOf(dp.getCategoricalValues(), this.getNumCategoricalVars()), this.categories);
                new_ds.addDataPoint(new_dp);
            }
            ++orig_pos;
        }
        new_ds.finishAdding();
        return new SimpleDataSet(new_ds);
    }

    public ClassificationDataSet asClassificationDataSet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a non-negative value");
        }
        if (this.getNumCategoricalVars() == 0) {
            throw new IllegalArgumentException("Dataset has no categorical variables, can not create classification dataset");
        }
        if (index >= this.getNumCategoricalVars()) {
            throw new IllegalArgumentException("Index " + index + " is larger than number of categorical features " + this.getNumCategoricalVars());
        }
        return new ClassificationDataSet(this, index);
    }

    public RegressionDataSet asRegressionDataSet(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be a non-negative value");
        }
        if (this.getNumNumericalVars() == 0) {
            throw new IllegalArgumentException("Dataset has no numeric variables, can not create regression dataset");
        }
        if (index >= this.getNumNumericalVars()) {
            throw new IllegalArgumentException("Index " + index + " i larger than number of numeric features " + this.getNumNumericalVars());
        }
        RegressionDataSet rds = new RegressionDataSet(this.datapoints.toList(), index);
        for (int i = 0; i < this.size(); ++i) {
            rds.setWeight(i, this.getWeight(i));
        }
        return rds;
    }

    public List<DataPoint> getList() {
        return this.datapoints.toList();
    }

    public SimpleDataSet shallowClone() {
        return new SimpleDataSet(new ArrayList<DataPoint>(this.datapoints.toList()));
    }

    public SimpleDataSet emptyClone() {
        SimpleDataSet sds = new SimpleDataSet(this.numNumerVals, this.categories);
        return sds;
    }

    @Override
    public SimpleDataSet getTwiceShallowClone() {
        return (SimpleDataSet)super.getTwiceShallowClone();
    }
}

