/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.parameters.Parameterized;
import jsat.utils.concurrent.ParallelUtils;

public class ArcX4
implements Classifier,
Parameterized {
    private static final long serialVersionUID = 3831448932874147550L;
    private Classifier weakLearner;
    private int iterations;
    private double coef = 1.0;
    private double expo = 4.0;
    private CategoricalData predicing;
    private Classifier[] hypoths;

    public ArcX4(Classifier weakLearner, int iterations) {
        this.setWeakLearner(weakLearner);
        this.setIterations(iterations);
    }

    public void setWeakLearner(Classifier weakLearner) {
        if (!weakLearner.supportsWeightedData()) {
            throw new RuntimeException("Weak learners must support weighted data samples");
        }
        this.weakLearner = weakLearner;
    }

    public Classifier getWeakLearner() {
        return this.weakLearner;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setCoefficient(double coef) {
        if (coef <= 0.0 || Double.isInfinite(coef) || Double.isNaN(coef)) {
            throw new ArithmeticException("The coefficient must be a positive constant");
        }
        this.coef = coef;
    }

    public double getCoefficient() {
        return this.coef;
    }

    public void setExponent(double expo) {
        if (expo <= 0.0 || Double.isInfinite(expo) || Double.isNaN(expo)) {
            throw new ArithmeticException("The exponent must be a positive constant");
        }
        this.expo = expo;
    }

    public double getExponent() {
        return this.expo;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.predicing.getNumOfCategories());
        for (Classifier hypoth : this.hypoths) {
            cr.incProb(hypoth.classify(data).mostLikely(), 1.0);
        }
        cr.normalize();
        return cr;
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        ClassificationDataSet cds = dataSet.shallowClone();
        int[] errors = new int[cds.size()];
        this.hypoths = new Classifier[this.iterations];
        for (int t = 0; t < this.hypoths.length; ++t) {
            for (int i = 0; i < cds.size(); ++i) {
                cds.setWeight(i, 1.0 + this.coef * Math.pow(errors[i], this.expo));
            }
            Classifier hypoth = this.weakLearner.clone();
            hypoth.train(cds, parallel);
            this.hypoths[t] = hypoth;
            ParallelUtils.run(parallel, errors.length, (start, end) -> {
                for (int i = start; i < end; ++i) {
                    if (hypoth.classify(cds.getDataPoint(i)).mostLikely() == cds.getDataPointCategory(i)) continue;
                    int n = i;
                    errors[n] = errors[n] + 1;
                }
            });
        }
        this.predicing = cds.getPredicting();
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public ArcX4 clone() {
        ArcX4 clone = new ArcX4(this.weakLearner.clone(), this.iterations);
        clone.coef = this.coef;
        clone.expo = this.expo;
        if (this.predicing != null) {
            clone.predicing = this.predicing.clone();
        }
        if (this.hypoths != null) {
            clone.hypoths = new Classifier[this.hypoths.length];
            for (int i = 0; i < clone.hypoths.length; ++i) {
                clone.hypoths[i] = this.hypoths[i].clone();
            }
        }
        return clone;
    }
}

