/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.svm;

import java.util.ArrayList;
import java.util.Arrays;
import jsat.DataSet;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.classifiers.WarmClassifier;
import jsat.classifiers.calibration.BinaryScoreClassifier;
import jsat.classifiers.svm.SupportVectorLearner;
import jsat.distributions.Distribution;
import jsat.distributions.LogUniform;
import jsat.distributions.kernels.KernelTrick;
import jsat.distributions.kernels.LinearKernel;
import jsat.exceptions.FailedToFitException;
import jsat.exceptions.UntrainedModelException;
import jsat.linear.ConstantVector;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;
import jsat.regression.WarmRegressor;
import jsat.utils.ListUtils;

public class PlattSMO
extends SupportVectorLearner
implements BinaryScoreClassifier,
WarmRegressor,
Parameterized,
WarmClassifier {
    private static final long serialVersionUID = 1533410993462673127L;
    protected double b = 0.0;
    protected double b_low;
    protected double b_up;
    private double C = 1.0;
    private double tolerance = 0.001;
    private double eps = 1.0E-7;
    private double epsilon = 0.01;
    private int maxIterations = 10000;
    private boolean modificationOne = true;
    protected double[] fcache;
    private int i_up;
    private int i_low;
    private double[] alpha_s;
    private boolean[] I0;
    private boolean[] I0_a;
    private boolean[] I0_b;
    private boolean[] I1;
    private boolean[] I2;
    private boolean[] I3;
    private boolean[] I4;
    protected double[] label;
    protected Vec weights;

    public PlattSMO() {
        this(new LinearKernel());
    }

    public PlattSMO(KernelTrick kf) {
        super(kf, SupportVectorLearner.CacheMode.NONE);
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        if (this.vecs == null) {
            throw new UntrainedModelException("Classifier has yet to be trained");
        }
        CategoricalResults cr = new CategoricalResults(2);
        double sum = this.getScore(data);
        if (sum > 0.0) {
            cr.setProb(1, 1.0);
        } else {
            cr.setProb(0, 1.0);
        }
        return cr;
    }

    @Override
    public double getScore(DataPoint dp) {
        return this.kEvalSum(dp.getNumericalValues()) - this.b;
    }

    @Override
    public void train(ClassificationDataSet dataSet, Classifier warmSolution, boolean parallel) {
        this.train(dataSet, warmSolution);
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        this.train(dataSet);
    }

    @Override
    public void train(ClassificationDataSet dataSet, Classifier warmSolution) {
        this.trainC_warm_and_normal(dataSet, warmSolution);
    }

    @Override
    public void train(ClassificationDataSet dataSet) {
        this.trainC_warm_and_normal(dataSet, null);
    }

    /*
     * Exception decompiling
     */
    private void trainC_warm_and_normal(ClassificationDataSet dataSet, Classifier warmSolution) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateSet(int i1, double a1, double C2) {
        this.I0[i1] = a1 > 0.0 && a1 < C2;
    }

    private double fuzzyClamp(double val, double max) {
        return this.fuzzyClamp(val, max, max * 1.0E-7);
    }

    private double fuzzyClamp(double val, double max, double e) {
        if (val > max - e) {
            return max;
        }
        if (val < e) {
            return 0.0;
        }
        return val;
    }

    private void updateSetR(int i, double C2) {
        double a_i = this.alphas[i];
        double as_i = this.alpha_s[i];
        this.I0_a[i] = 0.0 < a_i && a_i < C2;
        this.I0_b[i] = 0.0 < as_i && as_i < C2;
        this.I0[i] = this.I0_a[i] || this.I0_b[i];
        this.I1[i] = a_i == 0.0 && as_i == 0.0;
        this.I2[i] = a_i == 0.0 && as_i == C2;
        this.I3[i] = a_i == C2 && as_i == 0.0;
    }

    private void updateSetsLabeled(int i1, double a1, double C2) {
        double y_i = this.label[i1];
        this.I1[i1] = a1 == 0.0 && y_i == 1.0;
        this.I2[i1] = a1 == C2 && y_i == -1.0;
        this.I3[i1] = a1 == C2 && y_i == 1.0;
        this.I4[i1] = a1 == 0.0 && y_i == -1.0;
    }

    protected boolean takeStep(int i1, int i2) {
        double a2;
        double k22;
        double H;
        double L;
        if (i1 == i2) {
            return false;
        }
        double alpha1 = this.alphas[i1];
        double alpha2 = this.alphas[i2];
        double y1 = this.label[i1];
        double y2 = this.label[i2];
        double F1 = this.fcache[i1];
        double F2 = this.fcache[i2];
        double C1 = this.C * this.weights.get(i1);
        double C2 = this.C * this.weights.get(i2);
        double s = y1 * y2;
        if (y1 != y2) {
            L = Math.max(0.0, alpha2 - alpha1);
            H = Math.min(C2, C1 + alpha2 - alpha1);
        } else {
            L = Math.max(0.0, alpha1 + alpha2 - C1);
            H = Math.min(C2, alpha1 + alpha2);
        }
        if (L >= H) {
            return false;
        }
        double k11 = this.kEval(i1, i1);
        double k12 = this.kEval(i1, i2);
        double eta = 2.0 * k12 - k11 - (k22 = this.kEval(i2, i2));
        if (eta < 0.0) {
            a2 = alpha2 - y2 * (F1 - F2) / eta;
            if (a2 < L) {
                a2 = L;
            } else if (a2 > H) {
                a2 = H;
            }
        } else {
            double L1 = alpha1 + s * (alpha2 - L);
            double f1 = y1 * F1 - alpha1 * k11 - s * alpha2 * k12;
            double f2 = y2 * F2 - alpha2 * k22 - s * alpha1 * k12;
            double Lobj = -0.5 * L1 * L1 * k11 - 0.5 * L * L * k22 - s * L * L1 * k12 - L1 * f1 - L * f2;
            double H12 = alpha1 + s * (alpha2 - H);
            double Hobj = -0.5 * H12 * H12 * k11 - 0.5 * H * H * k22 - s * H * H12 * k12 - H12 * f1 - H * f2;
            a2 = Lobj > Hobj + this.eps ? L : (Lobj < Hobj - this.eps ? H : alpha2);
        }
        a2 = this.fuzzyClamp(a2, C2);
        if (Math.abs(a2 - alpha2) < this.eps * (a2 + alpha2 + this.eps)) {
            return false;
        }
        double a1 = alpha1 + s * (alpha2 - a2);
        a1 = this.fuzzyClamp(a1, C1);
        double newF1C = F1 + y1 * (a1 - alpha1) * k11 + y2 * (a2 - alpha2) * k12;
        double newF2C = F2 + y1 * (a1 - alpha1) * k12 + y2 * (a2 - alpha2) * k22;
        this.updateSet(i1, a1, C1);
        this.updateSet(i2, a2, C2);
        this.updateSetsLabeled(i1, a1, C1);
        this.updateSetsLabeled(i2, a2, C2);
        this.fcache[i1] = newF1C;
        this.fcache[i2] = newF2C;
        this.b_low = Double.NEGATIVE_INFINITY;
        this.b_up = Double.POSITIVE_INFINITY;
        this.i_low = -1;
        this.i_up = -1;
        for (int i = 0; i < this.I0.length; ++i) {
            double bCand;
            if (!this.I0[i]) continue;
            if (i != i1 && i != i2) {
                int n = i;
                this.fcache[n] = this.fcache[n] + (y1 * (a1 - alpha1) * this.kEval(i1, i) + y2 * (a2 - alpha2) * this.kEval(i2, i));
            }
            if ((bCand = this.fcache[i]) > this.b_low) {
                this.i_low = i;
                this.b_low = bCand;
            }
            if (!(bCand < this.b_up)) continue;
            this.i_up = i;
            this.b_up = bCand;
        }
        for (int i : new int[]{i1, i2}) {
            double bCand;
            if ((this.I3[i] || this.I4[i]) && (bCand = this.fcache[i]) > this.b_low) {
                this.i_low = i;
                this.b_low = bCand;
            }
            if (!this.I1[i] && !this.I2[i] || !((bCand = this.fcache[i]) < this.b_up)) continue;
            this.i_up = i;
            this.b_up = bCand;
        }
        this.alphas[i1] = a1;
        this.alphas[i2] = a2;
        return true;
    }

    protected boolean takeStepR(int i1, int i2) {
        int i;
        double k22;
        if (i1 == i2) {
            return false;
        }
        double alpha1 = this.alphas[i1];
        double alpha2 = this.alphas[i2];
        double alpha1_S = this.alpha_s[i1];
        double alpha2_S = this.alpha_s[i2];
        double F1 = this.fcache[i1];
        double F2 = this.fcache[i2];
        double C1 = this.C * this.weights.get(i1);
        double C2 = this.C * this.weights.get(i2);
        double k11 = this.kEval(i1, i1);
        double k12 = this.kEval(i2, i1);
        double eta = -2.0 * k12 + k11 + (k22 = this.kEval(i2, i2));
        if (eta < 0.0) {
            eta = 0.0;
        }
        double gamma = alpha1 - alpha1_S + alpha2 - alpha2_S;
        boolean finished = false;
        boolean case4 = false;
        boolean case3 = false;
        boolean case2 = false;
        boolean case1 = false;
        double alpha1_old = alpha1;
        double alpha1_oldS = alpha1_S;
        double alpha2_old = alpha2;
        double alpha2_oldS = alpha2_S;
        double deltaPhi = F1 - F2;
        while (!finished) {
            double a1;
            double a2;
            double H;
            double L;
            if (!case1 && (alpha1 > 0.0 || alpha1_S == 0.0 && deltaPhi > 0.0) && (alpha2 > 0.0 || alpha2_S == 0.0 && deltaPhi < 0.0)) {
                L = Math.max(0.0, gamma - C1);
                if (L < (H = Math.min(C2, gamma))) {
                    a2 = Math.max(L, Math.min(alpha2 - deltaPhi / eta, H));
                    a2 = this.fuzzyClamp(a2, C2);
                    a1 = alpha1 - (a2 - alpha2);
                    if (Math.abs(alpha1 - (a1 = this.fuzzyClamp(a1, C1))) > 1.0E-10 || Math.abs(a2 - alpha2) > 1.0E-10) {
                        deltaPhi += (a2 - alpha2) * eta;
                        alpha1 = a1;
                        alpha2 = a2;
                    }
                } else {
                    finished = true;
                }
                case1 = true;
                continue;
            }
            if (!case2 && (alpha1 > 0.0 || alpha1_S == 0.0 && deltaPhi > 2.0 * this.epsilon) && (alpha2_S > 0.0 || alpha2 == 0.0 && deltaPhi > 2.0 * this.epsilon)) {
                L = Math.max(0.0, -gamma);
                if (L < (H = Math.min(C2, -gamma + C1))) {
                    a2 = Math.max(L, Math.min(alpha2_S + (deltaPhi - 2.0 * this.epsilon) / eta, H));
                    a2 = this.fuzzyClamp(a2, C2);
                    a1 = alpha1 + (a2 - alpha2_S);
                    if (Math.abs(alpha1 - (a1 = this.fuzzyClamp(a1, C1))) > 1.0E-10 || Math.abs(alpha2_S - a2) > 1.0E-10) {
                        deltaPhi += (alpha2_S - a2) * eta;
                        alpha1 = a1;
                        alpha2_S = a2;
                    }
                } else {
                    finished = true;
                }
                case2 = true;
                continue;
            }
            if (!case3 && (alpha1_S > 0.0 || alpha1 == 0.0 && deltaPhi < -2.0 * this.epsilon) && (alpha2 > 0.0 || alpha2_S == 0.0 && deltaPhi < -2.0 * this.epsilon)) {
                L = Math.max(0.0, gamma);
                if (L < (H = Math.min(C2, C1 + gamma))) {
                    a2 = Math.max(L, Math.min(alpha2 - (deltaPhi + 2.0 * this.epsilon) / eta, H));
                    a2 = this.fuzzyClamp(a2, C2);
                    a1 = alpha1_S + (a2 - alpha2);
                    if (Math.abs(alpha1_S - (a1 = this.fuzzyClamp(a1, C1))) > 1.0E-10 || Math.abs(alpha2 - a2) > 1.0E-10) {
                        deltaPhi += (a2 - alpha2) * eta;
                        alpha1_S = a1;
                        alpha2 = a2;
                    }
                } else {
                    finished = true;
                }
                case3 = true;
                continue;
            }
            if (!case4 && (alpha1_S > 0.0 || alpha1 == 0.0 && deltaPhi < 0.0) && (alpha2_S > 0.0 || alpha2 == 0.0 && deltaPhi > 0.0)) {
                L = Math.max(0.0, -gamma - C1);
                if (L < (H = Math.min(C2, -gamma))) {
                    a2 = Math.max(L, Math.min(alpha2_S + deltaPhi / eta, H));
                    a2 = this.fuzzyClamp(a2, C2);
                    a1 = alpha1_S - (a2 - alpha2_S);
                    if (Math.abs(alpha1_S - (a1 = this.fuzzyClamp(a1, C1))) > 1.0E-10 || Math.abs(alpha2_S - a2) > 1.0E-10) {
                        deltaPhi += (alpha2_S - a2) * eta;
                        alpha1_S = a1;
                        alpha2_S = a2;
                    }
                } else {
                    finished = true;
                }
                case4 = true;
                continue;
            }
            finished = true;
        }
        if (alpha1 == alpha1_old && alpha1_S == alpha1_oldS && alpha2 == alpha2_old && alpha2_S == alpha2_oldS) {
            return false;
        }
        this.alphas[i1] = alpha1;
        this.alphas[i2] = alpha2;
        this.alpha_s[i1] = alpha1_S;
        this.alpha_s[i2] = alpha2_S;
        double ceof1 = alpha1 - alpha1_old - (alpha1_S - alpha1_oldS);
        double ceof2 = alpha2 - alpha2_old - (alpha2_S - alpha2_oldS);
        for (i = 0; i < this.I0.length; ++i) {
            if (!this.I0[i] || i == i1 || i == i2) continue;
            int n = i;
            this.fcache[n] = this.fcache[n] - (ceof1 * this.kEval(i1, i) + ceof2 * this.kEval(i2, i));
        }
        int n = i1;
        this.fcache[n] = this.fcache[n] - (ceof1 * k11 + ceof2 * k12);
        int n2 = i2;
        this.fcache[n2] = this.fcache[n2] - (ceof1 * k12 + ceof2 * k22);
        this.updateSetR(i1, C1);
        this.updateSetR(i2, C2);
        this.b_low = Double.NEGATIVE_INFINITY;
        this.b_up = Double.POSITIVE_INFINITY;
        this.i_low = -1;
        this.i_up = -1;
        for (i = 0; i < this.I0.length; ++i) {
            if (!this.I0[i]) continue;
            this.updateThreshold(i);
        }
        this.updateThreshold(i1);
        this.updateThreshold(i2);
        if (this.i_low == -1 || this.i_up == -1) {
            throw new FailedToFitException("BUG: Imposible code block reached. Please report");
        }
        return true;
    }

    private void updateThreshold(int i) {
        double Fi = this.fcache[i];
        double F_tilde_i = this.b_low;
        if (this.I0_b[i] || this.I2[i]) {
            F_tilde_i = Fi + this.epsilon;
        } else if (this.I0_a[i] || this.I1[i]) {
            F_tilde_i = Fi - this.epsilon;
        }
        double F_bar_i = this.b_up;
        if (this.I0_a[i] || this.I3[i]) {
            F_bar_i = Fi - this.epsilon;
        } else if (this.I0_b[i] || this.I1[i]) {
            F_bar_i = Fi + this.epsilon;
        }
        if (this.b_low < F_tilde_i) {
            this.b_low = F_tilde_i;
            this.i_low = i;
        }
        if (this.b_up > F_bar_i) {
            this.b_up = F_bar_i;
            this.i_up = i;
        }
    }

    private int examineExample(int i2) {
        double F2;
        double y2 = this.label[i2];
        if (this.I0[i2]) {
            F2 = this.fcache[i2];
        } else {
            this.fcache[i2] = F2 = this.decisionFunction(i2) - y2;
            if ((this.I1[i2] || this.I2[i2]) && F2 < this.b_up) {
                this.b_up = F2;
                this.i_up = i2;
            } else if ((this.I3[i2] || this.I4[i2]) && F2 > this.b_low) {
                this.b_low = F2;
                this.i_low = i2;
            }
        }
        boolean optimal = true;
        int i1 = -1;
        boolean I0_contains_i2 = this.I0[i2];
        if ((I0_contains_i2 || this.I1[i2] || this.I2[i2]) && this.b_low - F2 > this.tolerance * 2.0) {
            optimal = false;
            i1 = this.i_low;
        }
        if ((I0_contains_i2 || this.I3[i2] || this.I4[i2]) && F2 - this.b_up > this.tolerance * 2.0) {
            optimal = false;
            i1 = this.i_up;
        }
        if (optimal) {
            return 0;
        }
        if (I0_contains_i2) {
            i1 = this.b_low - F2 > F2 - this.b_up ? this.i_low : this.i_up;
        }
        if (this.takeStep(i1, i2)) {
            return 1;
        }
        return 0;
    }

    private int examineExampleR(int i2) {
        double F2;
        double y2 = this.label[i2];
        if (this.I0[i2]) {
            F2 = this.fcache[i2];
        } else {
            this.fcache[i2] = F2 = y2 - this.decisionFunctionR(i2);
            if (this.I1[i2]) {
                if (F2 + this.eps < this.b_up) {
                    this.b_up = F2 + this.epsilon;
                    this.i_up = i2;
                } else if (F2 - this.epsilon > this.b_low) {
                    this.b_low = F2 - this.epsilon;
                    this.i_low = i2;
                }
            } else if (this.I2[i2] && F2 + this.epsilon > this.b_low) {
                this.b_low = F2 + this.epsilon;
                this.i_low = i2;
            } else if (this.I3[i2] && F2 - this.epsilon < this.b_up) {
                this.b_up = F2 - this.epsilon;
                this.i_up = i2;
            }
        }
        boolean optimal = true;
        int i1 = -1;
        double F2mEps = F2 - this.epsilon;
        double F2pEps = F2 + this.epsilon;
        double tol2 = 2.0 * this.tolerance;
        if (this.I0_a[i2]) {
            if (this.b_low - F2mEps > tol2) {
                optimal = false;
                i1 = this.i_low;
                if (F2mEps - this.b_up > this.b_low - F2mEps) {
                    i1 = this.i_up;
                }
            } else if (F2mEps - this.b_up > tol2) {
                optimal = false;
                i1 = this.i_up;
                if (this.b_low - F2mEps > F2mEps - this.b_up) {
                    i1 = this.i_low;
                }
            }
        } else if (this.I0_b[i2]) {
            if (this.b_low - F2pEps > tol2) {
                optimal = false;
                i1 = this.i_low;
                if (F2pEps - this.b_up > this.b_low - F2pEps) {
                    i1 = this.i_up;
                }
            } else if (F2pEps - this.b_up > tol2) {
                optimal = false;
                i1 = this.i_up;
                if (this.b_low - F2pEps > F2pEps - this.b_up) {
                    i1 = this.i_low;
                }
            }
        } else if (this.I1[i2]) {
            if (this.b_low - F2pEps > tol2) {
                optimal = false;
                i1 = this.i_low;
                if (F2pEps - this.b_up > this.b_low - F2pEps) {
                    i1 = this.i_up;
                }
            } else if (F2mEps - this.b_up > tol2) {
                optimal = false;
                i1 = this.i_up;
                if (this.b_low - F2mEps > F2mEps - this.b_up) {
                    i1 = this.i_low;
                }
            }
        } else if (this.I2[i2]) {
            if (F2pEps - this.b_up > tol2) {
                optimal = false;
                i1 = this.i_up;
            }
        } else if (this.I3[i2] && this.b_low - F2mEps > tol2) {
            optimal = false;
            i1 = this.i_low;
        }
        if (optimal) {
            return 0;
        }
        if (this.takeStepR(i1, i2)) {
            return 1;
        }
        return 0;
    }

    protected double decisionFunction(int v) {
        double sum = 0.0;
        for (int i = 0; i < this.vecs.size(); ++i) {
            if (!(this.alphas[i] > 0.0)) continue;
            sum += this.alphas[i] * this.label[i] * this.kEval(v, i);
        }
        return sum;
    }

    protected double decisionFunctionR(int v) {
        double sum = 0.0;
        for (int i = 0; i < this.vecs.size(); ++i) {
            if (this.alphas[i] == this.alpha_s[i]) continue;
            sum += (this.alphas[i] - this.alpha_s[i]) * this.kEval(v, i);
        }
        return sum;
    }

    @Override
    public PlattSMO clone() {
        PlattSMO copy = new PlattSMO(this.getKernel().clone());
        copy.C = this.C;
        if (this.alphas != null) {
            copy.alphas = Arrays.copyOf(this.alphas, this.alphas.length);
        }
        if (this.alpha_s != null) {
            copy.alpha_s = Arrays.copyOf(this.alpha_s, this.alpha_s.length);
        }
        if (this.weights != null) {
            copy.weights = this.weights.clone();
        }
        copy.b = this.b;
        copy.eps = this.eps;
        copy.epsilon = this.epsilon;
        copy.maxIterations = this.maxIterations;
        if (this.label != null) {
            copy.label = Arrays.copyOf(this.label, this.label.length);
        }
        copy.tolerance = this.tolerance;
        if (this.vecs != null) {
            copy.vecs = new ArrayList(this.vecs);
        }
        copy.setCacheMode(this.getCacheMode());
        copy.setCacheValue(this.getCacheValue());
        return copy;
    }

    @Override
    public boolean supportsWeightedData() {
        return true;
    }

    @Parameter.WarmParameter(prefLowToHigh=true)
    public void setC(double C2) {
        if (C2 <= 0.0) {
            throw new ArithmeticException("C must be a positive constant");
        }
        this.C = C2;
    }

    public double getC() {
        return this.C;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setModificationOne(boolean modificationOne) {
        this.modificationOne = modificationOne;
    }

    public boolean isModificationOne() {
        return this.modificationOne;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public double regress(DataPoint data) {
        return this.kEvalSum(data.getNumericalValues()) + this.b;
    }

    @Override
    public void train(RegressionDataSet dataSet, boolean parallel) {
        this.train(dataSet);
    }

    public void setEpsilon(double epsilon) {
        if (Double.isNaN(epsilon) || Double.isInfinite(epsilon) || epsilon <= 0.0) {
            throw new IllegalArgumentException("epsilon must be in (0, infty), not " + epsilon);
        }
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public void train(RegressionDataSet dataSet, Regressor warmSolution, boolean parallel) {
        this.train(dataSet, warmSolution);
    }

    @Override
    public void train(RegressionDataSet dataSet) {
        this.train(dataSet, (Regressor)null);
    }

    @Override
    public void train(RegressionDataSet dataSet, Regressor warmSolution) {
        int N = dataSet.size();
        this.vecs = new ArrayList(N);
        this.label = new double[N];
        this.fcache = new double[N];
        this.b = 0.0;
        this.weights = new DenseVector(N);
        boolean allWeightsAreOne = true;
        for (int i = 0; i < N; ++i) {
            DataPoint dataPoint = dataSet.getDataPoint(i);
            this.vecs.add(dataPoint.getNumericalValues());
            this.fcache[i] = this.label[i] = dataSet.getTargetValue(i);
            this.weights.set(i, dataSet.getWeight(i));
            if (dataSet.getWeight(i) == 1.0) continue;
            allWeightsAreOne = false;
        }
        if (allWeightsAreOne) {
            this.weights = new ConstantVector(1.0, N);
        }
        this.setCacheMode(this.getCacheMode());
        this.I0 = new boolean[N];
        this.I0_a = new boolean[N];
        this.I0_b = new boolean[N];
        this.I1 = new boolean[N];
        this.I2 = new boolean[N];
        this.I3 = new boolean[N];
        this.alphas = new double[N];
        this.alpha_s = new double[N];
        this.i_low = 0;
        this.i_up = 0;
        Arrays.fill(this.I1, true);
        this.b_up = this.b_low = dataSet.getTargetValue(this.i_up);
        this.b_up += this.eps;
        this.b_low -= this.eps;
        boolean examinAll = true;
        if (warmSolution != null) {
            int i;
            examinAll = false;
            this.b_low = -1.7976931348623157E308;
            this.b_up = Double.MAX_VALUE;
            for (i = 0; i < N; ++i) {
                double err = this.label[i] - warmSolution.regress(dataSet.getDataPoint(i));
                err = Math.abs(err) < this.epsilon ? 0.0 : (err -= Math.signum(err) * this.epsilon);
                double C_i = this.C * this.weights.get(i);
                this.alphas[i] = this.fuzzyClamp(err, C_i, 1.0E-6);
                this.alpha_s[i] = this.fuzzyClamp(-err, C_i, 1.0E-6);
            }
            for (i = 0; i < N; ++i) {
                double C_i = this.C * this.weights.get(i);
                double F_i = this.fcache[i] = this.label[i] - this.decisionFunctionR(i);
                this.updateSetR(i, C_i);
                if (this.I0[i] || this.I1[i] || this.I3[i]) {
                    this.b_up = Math.min(this.b_up, F_i);
                }
                if (!this.I0[i] && !this.I1[i] && !this.I2[i]) continue;
                this.b_low = Math.max(this.b_low, F_i);
            }
            this.b_up -= this.epsilon;
            this.b_low += this.epsilon;
        }
        int numChanged = 0;
        int examinAllCount = 0;
        int iter = 0;
        while ((examinAll || numChanged > 0) && iter < this.maxIterations) {
            int i;
            ++iter;
            numChanged = 0;
            if (examinAll) {
                for (i = 0; i < N; ++i) {
                    numChanged += this.examineExampleR(i);
                }
                ++examinAllCount;
            } else if (this.modificationOne) {
                for (i = 0; i < this.I0.length; ++i) {
                    if (!this.I0[i]) continue;
                    numChanged += this.examineExampleR(i);
                    if (!(this.b_up > this.b_low - 2.0 * this.tolerance)) continue;
                    numChanged = 0;
                    break;
                }
            } else {
                boolean inner_loop_success = true;
                do {
                    if (inner_loop_success != this.takeStepR(this.i_up, this.i_low)) continue;
                    ++numChanged;
                } while (inner_loop_success && this.b_up < this.b_low - 2.0 * this.tolerance);
                numChanged = 0;
            }
            if (examinAll) {
                examinAll = false;
                continue;
            }
            if (numChanged != 0) continue;
            examinAll = true;
        }
        this.b = (this.b_up + this.b_low) / 2.0;
        int supportVectorCount = 0;
        for (int i = 0; i < N; ++i) {
            if (this.alphas[i] == 0.0 && this.alpha_s[i] == 0.0) continue;
            ListUtils.swap(this.vecs, supportVectorCount, i);
            this.alphas[supportVectorCount++] = this.alphas[i] - this.alpha_s[i];
        }
        this.vecs = new ArrayList(this.vecs.subList(0, supportVectorCount));
        this.alphas = Arrays.copyOfRange(this.alphas, 0, supportVectorCount);
        this.label = null;
        this.fcache = null;
        this.I4 = null;
        this.I3 = null;
        this.I2 = null;
        this.I1 = null;
        this.I0_b = null;
        this.I0_a = null;
        this.I0 = null;
        this.setCacheMode(null);
        this.setAlphas(this.alphas);
    }

    @Override
    public boolean warmFromSameDataOnly() {
        return false;
    }

    public static Distribution guessC(DataSet d) {
        return new LogUniform(0.1, 100.0);
    }
}

