/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.dissimilarity;

import jsat.DataSet;
import jsat.clustering.dissimilarity.ClusterDissimilarity;

public abstract class AbstractClusterDissimilarity
implements ClusterDissimilarity {
    public static double getDistance(double[][] distanceMatrix, int i, int j) {
        if (i > j) {
            int tmp = j;
            j = i;
            i = tmp;
        }
        return distanceMatrix[i][j - i - 1];
    }

    public static void setDistance(double[][] distanceMatrix, int i, int j, double dist) {
        if (i > j) {
            int tmp = j;
            j = i;
            i = tmp;
        }
        distanceMatrix[i][j - i - 1] = dist;
    }

    public static double[][] createDistanceMatrix(DataSet dataSet, ClusterDissimilarity cd) {
        double[][] distances = new double[dataSet.size()][];
        for (int i = 0; i < distances.length; ++i) {
            distances[i] = new double[dataSet.size() - i - 1];
            for (int j = i + 1; j < distances.length; ++j) {
                distances[i][j - i - 1] = cd.distance(dataSet.getDataPoint(i), dataSet.getDataPoint(j));
            }
        }
        return distances;
    }

    @Override
    public abstract ClusterDissimilarity clone();
}

