/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.ClusterEvaluation;

public class Completeness
implements ClusterEvaluation {
    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        if (!(dataSet instanceof ClassificationDataSet)) {
            throw new RuntimeException("Completeness can only be calcuate for classification data sets");
        }
        ClassificationDataSet cds = (ClassificationDataSet)dataSet;
        int clusters = 0;
        for (int clusterID : designations) {
            clusters = Math.max(clusterID + 1, clusters);
        }
        int C2 = cds.getPredicting().getNumOfCategories();
        int K = clusters;
        double[][] A2 = new double[C2][K];
        double[] class_sum = new double[C2];
        double[] cluster_sum = new double[K];
        double n = 0.0;
        for (int i = 0; i < designations.length; ++i) {
            int cluster = designations[i];
            if (cluster < 0) continue;
            int label = cds.getDataPointCategory(i);
            double weight = cds.getWeight(i);
            double[] dArray = A2[label];
            int n2 = cluster;
            dArray[n2] = dArray[n2] + weight;
            int n3 = label;
            class_sum[n3] = class_sum[n3] + weight;
            int n4 = cluster;
            cluster_sum[n4] = cluster_sum[n4] + weight;
            n += weight;
        }
        double h_kc = 0.0;
        double h_k = 0.0;
        for (int c = 0; c < C2; ++c) {
            for (int k = 0; k < K; ++k) {
                if (cluster_sum[k] > 0.0 && c == 0) {
                    h_k -= cluster_sum[k] / n * (Math.log(cluster_sum[k]) - Math.log(n));
                }
                if (A2[c][k] == 0.0 || class_sum[c] == 0.0) continue;
                h_kc -= A2[c][k] / n * (Math.log(A2[c][k]) - Math.log(class_sum[c]));
            }
        }
        if (h_k == 0.0) {
            return 0.0;
        }
        return h_kc / h_k;
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        throw new UnsupportedOperationException("Completeness requires the true data set labels, call evaluate(int[] designations, DataSet dataSet) instead");
    }

    @Override
    public double naturalScore(double evaluate_score) {
        return 1.0 - evaluate_score;
    }

    @Override
    public Completeness clone() {
        return new Completeness();
    }
}

