/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.ClusterEvaluation;

public class Homogeneity
implements ClusterEvaluation {
    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        if (!(dataSet instanceof ClassificationDataSet)) {
            throw new RuntimeException("Homogeneity can only be calcuate for classification data sets");
        }
        ClassificationDataSet cds = (ClassificationDataSet)dataSet;
        int clusters = 0;
        for (int clusterID : designations) {
            clusters = Math.max(clusterID + 1, clusters);
        }
        int C2 = cds.getPredicting().getNumOfCategories();
        int K = clusters;
        double[][] A2 = new double[C2][K];
        double[] class_sum = new double[C2];
        double[] cluster_sum = new double[K];
        double n = 0.0;
        for (int i = 0; i < designations.length; ++i) {
            int cluster = designations[i];
            if (cluster < 0) continue;
            int label = cds.getDataPointCategory(i);
            double weight = cds.getWeight(i);
            double[] dArray = A2[label];
            int n2 = cluster;
            dArray[n2] = dArray[n2] + weight;
            int n3 = label;
            class_sum[n3] = class_sum[n3] + weight;
            int n4 = cluster;
            cluster_sum[n4] = cluster_sum[n4] + weight;
            n += weight;
        }
        double h_ck = 0.0;
        double h_c = 0.0;
        for (int c = 0; c < C2; ++c) {
            if (class_sum[c] > 0.0) {
                h_c -= class_sum[c] / n * (Math.log(class_sum[c]) - Math.log(n));
            }
            for (int k = 0; k < K; ++k) {
                if (A2[c][k] == 0.0 || cluster_sum[k] == 0.0) continue;
                h_ck -= A2[c][k] / n * (Math.log(A2[c][k]) - Math.log(cluster_sum[k]));
            }
        }
        if (h_c == 0.0) {
            return 0.0;
        }
        return h_ck / h_c;
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        throw new UnsupportedOperationException("Homogeneity requires the true data set labels, call evaluate(int[] designations, DataSet dataSet) instead");
    }

    @Override
    public double naturalScore(double evaluate_score) {
        return 1.0 - evaluate_score;
    }

    @Override
    public Homogeneity clone() {
        return new Homogeneity();
    }
}

