/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.List;
import jsat.DataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.ClusterEvaluation;
import jsat.clustering.evaluation.Completeness;
import jsat.clustering.evaluation.Homogeneity;

public class VMeasure
implements ClusterEvaluation {
    private double beta;

    public VMeasure(double beta) {
        if (beta < 0.0) {
            throw new IllegalArgumentException("Beta must be positive, not " + beta);
        }
        this.beta = beta;
    }

    public VMeasure() {
        this(1.0);
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        double c;
        if (!(dataSet instanceof ClassificationDataSet)) {
            throw new RuntimeException("VMeasure can only be calcuate for classification data sets");
        }
        Homogeneity homo = new Homogeneity();
        Completeness comp = new Completeness();
        double h = homo.naturalScore(homo.evaluate(designations, dataSet));
        double v = this.beta * h + (c = comp.naturalScore(comp.evaluate(designations, dataSet))) == 0.0 ? 0.0 : (1.0 + this.beta) * h * c / (this.beta * h + c);
        return 1.0 - v;
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        throw new UnsupportedOperationException("VMeasure requires the true data set labels, call evaluate(int[] designations, DataSet dataSet) instead");
    }

    @Override
    public double naturalScore(double evaluate_score) {
        return 1.0 - evaluate_score;
    }

    @Override
    public VMeasure clone() {
        return new VMeasure(this.beta);
    }
}

