/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.ClusterFailureException;
import jsat.clustering.KClusterer;
import jsat.clustering.KClustererBase;
import jsat.clustering.evaluation.ClusterEvaluation;

public class DivisiveLocalClusterer
extends KClustererBase {
    private static final long serialVersionUID = 8616401472810067778L;
    private KClusterer baseClusterer;
    private ClusterEvaluation clusterEvaluation;

    public DivisiveLocalClusterer(KClusterer baseClusterer, ClusterEvaluation clusterEvaluation) {
        this.baseClusterer = baseClusterer;
        this.clusterEvaluation = clusterEvaluation;
    }

    public DivisiveLocalClusterer(DivisiveLocalClusterer toCopy) {
        this(toCopy.baseClusterer.clone(), toCopy.clusterEvaluation.clone());
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.size()), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, boolean parallel, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.size()), parallel, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, boolean parallel, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.size()];
        }
        int[][] subDesignation = new int[clusters][];
        int[][] originalPositions = new int[clusters][dataSet.size()];
        double[] splitEvaluation = new double[clusters];
        PriorityQueue<Integer> clusterToSplit = new PriorityQueue<Integer>(clusters, (t, t1) -> Double.compare(splitEvaluation[t], splitEvaluation[t1]));
        clusterToSplit.add(0);
        Arrays.fill(designations, 0);
        this.baseClusterer.cluster(dataSet, 2, parallel, designations);
        subDesignation[0] = Arrays.copyOf(designations, designations.length);
        for (int i = 0; i < originalPositions[0].length; ++i) {
            originalPositions[0][i] = i;
        }
        ArrayList<DataPoint> dpSubC1 = new ArrayList<DataPoint>();
        ArrayList<DataPoint> dpSubC2 = new ArrayList<DataPoint>();
        for (int k = 1; k < clusters; ++k) {
            int useSplit = (Integer)clusterToSplit.poll();
            int newClusterID = k;
            dpSubC1.clear();
            dpSubC2.clear();
            for (int i = 0; i < subDesignation[useSplit].length; ++i) {
                int origPos = originalPositions[useSplit][i];
                if (subDesignation[useSplit][i] == 0) {
                    dpSubC1.add(dataSet.getDataPoint(origPos));
                    continue;
                }
                dpSubC2.add(dataSet.getDataPoint(origPos));
                designations[origPos] = newClusterID;
            }
            this.computeSubClusterSplit(subDesignation, useSplit, dpSubC1, dataSet, designations, originalPositions, splitEvaluation, clusterToSplit, parallel);
            this.computeSubClusterSplit(subDesignation, newClusterID, dpSubC2, dataSet, designations, originalPositions, splitEvaluation, clusterToSplit, parallel);
        }
        return designations;
    }

    private void computeSubClusterSplit(int[][] subDesignation, int originalCluster, List<DataPoint> listOfDataPointsInCluster, DataSet fullDataSet, int[] fullDesignations, int[][] originalPositions, double[] splitEvaluation, PriorityQueue<Integer> clusterToSplit, boolean parallel) {
        subDesignation[originalCluster] = new int[listOfDataPointsInCluster.size()];
        int pos = 0;
        for (int i = 0; i < fullDataSet.size(); ++i) {
            if (fullDesignations[i] != originalCluster) continue;
            originalPositions[originalCluster][pos++] = i;
        }
        SimpleDataSet dpSubC1DataSet = new SimpleDataSet(listOfDataPointsInCluster);
        try {
            this.baseClusterer.cluster((DataSet)dpSubC1DataSet, 2, parallel, subDesignation[originalCluster]);
            splitEvaluation[originalCluster] = this.clusterEvaluation.evaluate(subDesignation[originalCluster], dpSubC1DataSet);
            clusterToSplit.add(originalCluster);
        }
        catch (ClusterFailureException ex) {
            splitEvaluation[originalCluster] = Double.POSITIVE_INFINITY;
        }
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, boolean parallel, int[] designations) {
        return this.cluster(dataSet, lowK, parallel, designations);
    }

    @Override
    public DivisiveLocalClusterer clone() {
        return new DivisiveLocalClusterer(this);
    }
}

