/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform.visualization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.datatransform.visualization.MDS;
import jsat.datatransform.visualization.VisualizationTransform;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.utils.FibHeap;
import jsat.utils.concurrent.ParallelUtils;

public class Isomap
implements VisualizationTransform {
    private DistanceMetric dm = new EuclideanDistance();
    private VectorCollection<VecPaired<Vec, Integer>> vc = new DefaultVectorCollection<VecPaired<Vec, Integer>>();
    private int searchNeighbors = 15;
    private MDS mds = new MDS();
    private boolean c_isomap = false;

    public Isomap() {
        this(15, false);
    }

    public Isomap(int searchNeighbors) {
        this(searchNeighbors, false);
    }

    public Isomap(int searchNeighbors, boolean c_isomap) {
        this.setNeighbors(searchNeighbors);
        this.setCIsomap(c_isomap);
    }

    public void setNeighbors(int searchNeighbors) {
        if (searchNeighbors < 2) {
            throw new IllegalArgumentException("number of neighbors considered must be at least 2, not " + searchNeighbors);
        }
        this.searchNeighbors = searchNeighbors;
    }

    public int getNeighbors() {
        return this.searchNeighbors;
    }

    public void setCIsomap(boolean c_isomap) {
        this.c_isomap = c_isomap;
    }

    public boolean isCIsomap() {
        return this.c_isomap;
    }

    @Override
    public <Type extends DataSet> Type transform(DataSet<Type> d, boolean parallel) {
        int N = d.size();
        DenseMatrix delta = new DenseMatrix(N, N);
        for (int i2 = 0; i2 < N; ++i2) {
            for (int j = 0; j < N; ++j) {
                if (i2 == j) {
                    ((Matrix)delta).set(i2, j, 0.0);
                    continue;
                }
                ((Matrix)delta).set(i2, j, Double.MAX_VALUE);
            }
        }
        ArrayList<VecPaired<Vec, Integer>> vecs = new ArrayList<VecPaired<Vec, Integer>>(N);
        for (int i3 = 0; i3 < N; ++i3) {
            vecs.add(new VecPaired<Vec, Integer>(d.getDataPoint(i3).getNumericalValues(), i3));
        }
        this.vc.build(parallel, vecs, this.dm);
        List<Double> cache = this.dm.getAccelerationCache(vecs, parallel);
        int knn = this.searchNeighbors + 1;
        ArrayList neighborGraph = new ArrayList();
        for (int i4 = 0; i4 < N; ++i4) {
            neighborGraph.add(null);
        }
        double[] avgNeighborDist = new double[N];
        ParallelUtils.run(parallel, N, i -> {
            List<VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = this.vc.search((Vec)((VecPaired)vecs.get(i)).getVector(), knn);
            neighborGraph.set(i, neighbors);
            for (int z = 1; z < neighbors.size(); ++z) {
                VecPaired<VecPaired<Vec, Integer>, Double> neighbor = neighbors.get(z);
                double dist = neighbor.getPair();
                int n = i;
                avgNeighborDist[n] = avgNeighborDist[n] + dist;
            }
            int n = i;
            avgNeighborDist[n] = avgNeighborDist[n] / (double)(neighbors.size() - 1);
        });
        if (this.c_isomap) {
            int i5 = 0;
            for (List neighbors : neighborGraph) {
                for (VecPaired neighbor : neighbors) {
                    neighbor.setPair((Double)neighbor.getPair() / Math.sqrt(avgNeighborDist[(Integer)((VecPaired)neighbor.getVector()).getPair()] + avgNeighborDist[i5] + 1.0E-6));
                }
                ++i5;
            }
        }
        ParallelUtils.run(parallel, N, k -> {
            double[] tmp_dist = this.dijkstra(neighborGraph, k);
            for (int i = 0; i < N; ++i) {
                tmp_dist[i] = Math.min(tmp_dist[i], delta.get(k, i));
                delta.set(i, k, tmp_dist[i]);
                delta.set(k, i, tmp_dist[i]);
            }
        });
        double largest_natural_dist_tmp = 0.0;
        for (int i6 = 0; i6 < N; ++i6) {
            for (int j = i6 + 1; j < N; ++j) {
                if (!(((Matrix)delta).get(i6, j) < Double.MAX_VALUE)) continue;
                largest_natural_dist_tmp = Math.max(largest_natural_dist_tmp, ((Matrix)delta).get(i6, j));
            }
        }
        double largest_natural_dist = largest_natural_dist_tmp;
        ParallelUtils.run(parallel, N, i -> {
            for (int j = i + 1; j < N; ++j) {
                double d_ij = delta.get(i, j);
                if (!(d_ij >= Double.MAX_VALUE)) continue;
                d_ij = 10.0 * this.dm.dist(i, j, (List<? extends Vec>)vecs, cache) + 1.5 * largest_natural_dist;
                delta.set(i, j, d_ij);
                delta.set(j, i, d_ij);
            }
        });
        SimpleDataSet emedded = this.mds.transform(delta, parallel);
        DataSet<Type> transformed = d.shallowClone();
        transformed.replaceNumericFeatures(emedded.getDataVectors());
        return (Type)transformed;
    }

    private double[] dijkstra(List<List<? extends VecPaired<VecPaired<Vec, Integer>, Double>>> neighborGraph, int sourceIndex) {
        int N = neighborGraph.size();
        double[] dist = new double[N];
        Arrays.fill(dist, Double.POSITIVE_INFINITY);
        dist[sourceIndex] = 0.0;
        ArrayList<FibHeap.FibNode<Integer>> nodes = new ArrayList<FibHeap.FibNode<Integer>>(N);
        FibHeap<Integer> Q = new FibHeap<Integer>();
        for (int i = 0; i < N; ++i) {
            nodes.add(null);
        }
        nodes.set(sourceIndex, Q.insert(sourceIndex, dist[sourceIndex]));
        while (Q.size() > 0) {
            FibHeap.FibNode u = Q.removeMin();
            int u_indx = (Integer)u.getValue();
            List<? extends VecPaired<VecPaired<Vec, Integer>, Double>> neighbors = neighborGraph.get(u_indx);
            for (int z = 1; z < neighbors.size(); ++z) {
                VecPaired<VecPaired<Vec, Integer>, Double> neighbor = neighbors.get(z);
                int j = neighbor.getVector().getPair();
                double u_j_dist = neighbor.getPair();
                double alt = dist[u_indx] + u_j_dist;
                if (!(alt < dist[j])) continue;
                dist[j] = alt;
                if (nodes.get(j) == null) {
                    nodes.set(j, Q.insert(j, alt));
                    continue;
                }
                Q.decreaseKey((FibHeap.FibNode)nodes.get(j), alt);
            }
        }
        return dist;
    }

    @Override
    public int getTargetDimension() {
        return this.mds.getTargetDimension();
    }

    @Override
    public boolean setTargetDimension(int target) {
        return this.mds.setTargetDimension(target);
    }
}

