/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import jsat.DataSet;
import jsat.distributions.Distribution;
import jsat.distributions.discrete.UniformDiscrete;
import jsat.distributions.kernels.BaseKernelTrick;
import jsat.linear.Vec;

public class PolynomialKernel
extends BaseKernelTrick {
    private static final long serialVersionUID = 9123109691782934745L;
    private double degree;
    private double alpha;
    private double c;

    public PolynomialKernel(double degree, double alpha, double c) {
        this.degree = degree;
        this.alpha = alpha;
        this.c = c;
    }

    public PolynomialKernel(double degree) {
        this(degree, 1.0, 1.0);
    }

    public void setAlpha(double alpha) {
        if (Double.isInfinite(alpha) || Double.isNaN(alpha) || alpha == 0.0) {
            throw new IllegalArgumentException("alpha must be a real non zero value, not " + alpha);
        }
        this.alpha = alpha;
    }

    public void setC(double c) {
        if (c < 0.0 || Double.isNaN(c) || Double.isInfinite(c)) {
            throw new IllegalArgumentException("C must be non negative, not " + c);
        }
        this.c = c;
    }

    public void setDegree(double d) {
        this.degree = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getC() {
        return this.c;
    }

    public double getDegree() {
        return this.degree;
    }

    @Override
    public double eval(Vec a, Vec b) {
        return Math.pow(this.c + a.dot(b) * this.alpha, this.degree);
    }

    @Override
    public String toString() {
        return "Polynomial Kernel ( degree=" + this.degree + ", c=" + this.c + ", alpha=" + this.alpha + ")";
    }

    public static Distribution guessDegree(DataSet d) {
        return new UniformDiscrete(2, 9);
    }

    @Override
    public PolynomialKernel clone() {
        return new PolynomialKernel(this.degree, this.alpha, this.c);
    }
}

