/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import jsat.linear.DenseMatrix;
import jsat.linear.Matrix;
import jsat.linear.RowColumnOps;
import jsat.linear.TransposeView;
import jsat.math.Complex;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;

public class EigenValueDecomposition
implements Serializable {
    private static final long serialVersionUID = -7169205761148043008L;
    private int n;
    private double[] d;
    private double[] e;
    private Matrix V;
    private Matrix H;
    private boolean complexResult;

    private void tred2() {
        int i;
        int j;
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V.get(this.n - 1, j);
        }
        for (i = this.n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    this.d[j2] = this.V.get(i - 1, j2);
                    this.V.set(i, j2, 0.0);
                    this.V.set(j2, i, 0.0);
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                Arrays.fill(this.e, 0, i, 0.0);
                for (j4 = 0; j4 < i; ++j4) {
                    f = this.d[j4];
                    this.V.set(j4, i, f);
                    g = this.e[j4] + this.V.get(j4, j4) * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += this.V.get(k2, j4) * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V.get(k2, j4) * f;
                    }
                    this.e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n = j4;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j4] * this.d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n = j3;
                    this.e[n] = this.e[n] - hh * this.d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = this.d[j3];
                    g = this.e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        this.V.increment(k3, j3, -(f * this.e[k3] + g * this.d[k3]));
                    }
                    this.d[j3] = this.V.get(i - 1, j3);
                    this.V.set(i, j3, 0.0);
                }
            }
            this.d[i] = h;
        }
        for (i = 0; i < this.n - 1; ++i) {
            this.V.set(this.n - 1, i, this.V.get(i, i));
            this.V.set(i, i, 1.0);
            double h = this.d[i + 1];
            if (h != 0.0) {
                for (int k = 0; k <= i; ++k) {
                    this.d[k] = this.V.get(k, i + 1) / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    double g = 0.0;
                    for (int k = 0; k <= i; ++k) {
                        g += this.V.get(k, i + 1) * this.V.get(k, j5);
                    }
                    RowColumnOps.addMultCol(this.V, j5, 0, i + 1, -g, this.d);
                }
            }
            RowColumnOps.fillCol(this.V, i + 1, 0, i + 1, 0.0);
        }
        for (j = 0; j < this.n; ++j) {
            this.d[j] = this.V.get(this.n - 1, j);
            this.V.set(this.n - 1, j, 0.0);
        }
        this.V.set(this.n - 1, this.n - 1, 1.0);
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < this.n; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Math.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = Math.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        EigenValueDecomposition.columnOpTransform(this.V, 0, this.n - 1, i2, c, s, 1);
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int k = i;
            double p = this.d[i];
            for (int j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            RowColumnOps.swapCol(this.V, i, k);
        }
    }

    private void orthes() {
        double[] ort = new double[this.n];
        int low = 0;
        int high = this.n - 1;
        for (int m = low + 1; m <= high - 1; ++m) {
            double d;
            double tmp;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.H.get(i, m - 1));
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                ort[i] = tmp = this.H.get(i, m - 1) / scale;
                h += tmp * tmp;
            }
            double g = Math.sqrt(h);
            tmp = ort[m];
            if (d > 0.0) {
                g = -g;
            }
            ort[m] = tmp - g;
            this.orthesApplyHouseholder(m, high, ort, h -= tmp * g);
            int n = m;
            ort[n] = ort[n] * scale;
            this.H.set(m, m - 1, scale * g);
        }
        for (int j = 0; j < this.n; ++j) {
            for (int i = 0; i < this.n; ++i) {
                this.V.set(i, j, i == j ? 1.0 : 0.0);
            }
        }
        this.orthesAccumulateTransforamtions(high, low, ort);
    }

    private void hqr2() {
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double[] cr = new double[2];
        double norm = this.hqr2GetNormStart(nn, low, high);
        int iter = 0;
        block0: while (n >= low) {
            int m;
            int l;
            for (l = n; l > low; --l) {
                s = Math.abs(this.H.get(l - 1, l - 1)) + Math.abs(this.H.get(l, l));
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.H.get(l, l - 1)) < eps * s) break;
            }
            if (l == n) {
                this.H.increment(n, n, exshift);
                this.d[n] = this.H.get(n, n);
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                this.hqr2FoundTwoRoots(exshift, n, nn, low, high);
                n -= 2;
                iter = 0;
                continue;
            }
            double x = this.H.get(n, n);
            double y = 0.0;
            double w = 0.0;
            if (l < n) {
                y = this.H.get(n - 1, n - 1);
                w = Math.pow(this.H.get(n, n - 1), 2.0);
            }
            if (iter == 10) {
                exshift += x;
                RowColumnOps.addDiag(this.H, low, n + 1, -x);
                s = Math.abs(this.H.get(n, n - 1)) + Math.abs(this.H.get(n - 1, n - 2));
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    RowColumnOps.addDiag(this.H, low, n + 1, -s);
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.H.get(m, m);
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H.get(m + 1, m) + this.H.get(m, m + 1);
                q = this.H.get(m + 1, m + 1) - z - r - s;
                r = this.H.get(m + 2, m + 1);
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(this.H.get(m + 1, m + 1))))) break;
            }
            for (int i = m + 2; i <= n; ++i) {
                this.H.set(i, i - 2, 0.0);
                if (i <= m + 2) continue;
                this.H.set(i, i - 3, 0.0);
            }
            for (int k = m; k <= n - 1; ++k) {
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H.get(k, k - 1);
                    q = this.H.get(k + 1, k - 1);
                    r = notlast ? this.H.get(k + 2, k - 1) : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block0;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.H.set(k, k - 1, -s * x);
                } else if (l != m) {
                    this.H.set(k, k - 1, -this.H.get(k, k - 1));
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                this.rowOpTransform2(this.H, k, nn - 1, x, k, y, notlast, z, r /= p, q /= p);
                this.columnOpTransform2(this.H, 0, Math.min(n, k + 3), x, k, y, notlast, z, r, q);
                this.columnOpTransform2(this.V, low, high, x, k, y, notlast, z, r, q);
            }
        }
        if (norm == 0.0) {
            return;
        }
        this.backsubtituteFindVectors(nn, z, s, eps, norm, cr);
        for (int i = 0; i < nn; ++i) {
            if (!(i < low | i > high)) continue;
            for (int j = i; j < nn - 1; ++j) {
                this.H.set(i, j, this.V.get(i, j));
            }
        }
        this.backtransform(nn, low, high);
    }

    public EigenValueDecomposition(Matrix A2) {
        this(A2, 1.0E-15);
    }

    public EigenValueDecomposition(Matrix A2, double eps) {
        if (!A2.isSquare()) {
            throw new ArithmeticException("");
        }
        this.n = A2.cols();
        this.d = new double[this.n];
        this.e = new double[this.n];
        if (Matrix.isSymmetric(A2, eps)) {
            Matrix VWork = A2.clone();
            this.V = new TransposeView(VWork);
            this.tred2();
            this.tql2();
            this.V = VWork.transpose();
            this.complexResult = false;
        } else {
            Matrix HWork = A2.transpose();
            this.H = new TransposeView(HWork);
            DenseMatrix VWork = new DenseMatrix(this.n, this.n);
            this.V = new TransposeView(VWork);
            this.orthes();
            this.hqr2();
            this.complexResult = false;
            for (int i = 0; i < this.n; ++i) {
                if (this.e[i] == 0.0) continue;
                this.complexResult = true;
            }
            this.V = ((Matrix)VWork).transpose();
        }
    }

    public void sortByEigenValue(Comparator<Double> cmp) {
        if (this.isComplex()) {
            throw new ArithmeticException("Eigen values can not be sorted due to complex results");
        }
        IndexTable it = new IndexTable(DoubleList.unmodifiableView(this.d, this.d.length), cmp);
        for (int i = 0; i < this.d.length; ++i) {
            RowColumnOps.swapCol(this.V, i, it.index(i));
            double tmp = this.d[i];
            this.d[i] = this.d[it.index(i)];
            this.d[it.index((int)i)] = tmp;
            it.swap(i, it.index(i));
        }
    }

    public Matrix getV() {
        return this.V.clone();
    }

    public Matrix getVRaw() {
        return this.V;
    }

    public Matrix getVT() {
        return this.V.transpose();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    private static void columnOpTransform(Matrix M, int low, int high, int n, double q, double p, int shift) {
        for (int i = low; i <= high; ++i) {
            double z = M.get(i, n + shift);
            M.set(i, n + shift, q * z + p * M.get(i, n));
            M.set(i, n, q * M.get(i, n) - p * z);
        }
    }

    private static void rowOpTransform(Matrix M, int low, int high, int n, double q, double p) {
        for (int j = low; j <= high; ++j) {
            double z = M.get(n - 1, j);
            M.set(n - 1, j, q * z + p * M.get(n, j));
            M.set(n, j, q * M.get(n, j) - p * z);
        }
    }

    private void columnOpTransform2(Matrix M, int low, int high, double x, int k, double y, boolean notlast, double z, double r, double q) {
        for (int i = low; i <= high; ++i) {
            double p = x * M.get(i, k) + y * M.get(i, k + 1);
            if (notlast) {
                M.set(i, k + 2, M.get(i, k + 2) - (p += z * M.get(i, k + 2)) * r);
            }
            M.increment(i, k, -p);
            M.increment(i, k + 1, -p * q);
        }
    }

    private void rowOpTransform2(Matrix M, int low, int high, double x, int k, double y, boolean notlast, double z, double r, double q) {
        for (int j = low; j <= high; ++j) {
            double p = M.get(k, j) + q * M.get(k + 1, j);
            if (notlast) {
                M.set(k + 2, j, M.get(k + 2, j) - (p += r * M.get(k + 2, j)) * z);
            }
            M.increment(k, j, -p * x);
            M.increment(k + 1, j, -p * y);
        }
    }

    public Matrix getD() {
        DenseMatrix X = new DenseMatrix(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            ((Matrix)X).set(i, i, this.d[i]);
            if (this.e[i] > 0.0) {
                ((Matrix)X).set(i, i + 1, this.e[i]);
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            ((Matrix)X).set(i, i - 1, this.e[i]);
        }
        return X;
    }

    public boolean isComplex() {
        return this.complexResult;
    }

    private void hqr2SolveComplexEigenEquation(int i, double p, double q, double eps, double norm, double w, double z, double r, double ra, double sa, double s, double[] cr, int n) {
        double vi;
        double x = this.H.get(i, i + 1);
        double y = this.H.get(i + 1, i);
        double vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
        if (vr == 0.0 & (vi = (this.d[i] - p) * 2.0 * q) == 0.0) {
            vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
        }
        Complex.cDiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi, cr);
        this.H.set(i, n - 1, cr[0]);
        this.H.set(i, n, cr[1]);
        if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
            this.H.set(i + 1, n - 1, (-ra - w * this.H.get(i, n - 1) + q * this.H.get(i, n)) / x);
            this.H.set(i + 1, n, (-sa - w * this.H.get(i, n) - q * this.H.get(i, n - 1)) / x);
        } else {
            Complex.cDiv(-r - y * this.H.get(i, n - 1), -s - y * this.H.get(i, n), z, q, cr);
            this.H.set(i + 1, n - 1, cr[0]);
            this.H.set(i + 1, n, cr[1]);
        }
    }

    private void backsubtituteFindVectors(int nn, double z, double s, double eps, double norm, double[] cr) {
        double r = 0.0;
        for (int n = nn - 1; n >= 0; --n) {
            double t;
            double w;
            int i;
            int l;
            double p = this.d[n];
            double q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H.set(n, n, 1.0);
                for (i = n - 1; i >= 0; --i) {
                    w = this.H.get(i, i) - p;
                    r = 0.0;
                    for (int j = l; j <= n; ++j) {
                        r += this.H.get(i, j) * this.H.get(j, n);
                    }
                    if (this.e[i] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (this.e[i] == 0.0) {
                        if (w != 0.0) {
                            this.H.set(i, n, -r / w);
                        } else {
                            this.H.set(i, n, -r / (eps * norm));
                        }
                    } else {
                        double x = this.H.get(i, i + 1);
                        double y = this.H.get(i + 1, i);
                        q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                        t = (x * s - z * r) / q;
                        this.H.set(i, n, t);
                        if (Math.abs(x) > Math.abs(z)) {
                            this.H.set(i + 1, n, (-r - w * t) / x);
                        } else {
                            this.H.set(i + 1, n, (-s - y * t) / z);
                        }
                    }
                    t = Math.abs(this.H.get(i, n));
                    if (!(eps * t * t > 1.0)) continue;
                    RowColumnOps.divCol(this.H, n, t);
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H.get(n, n - 1)) > Math.abs(this.H.get(n - 1, n))) {
                this.H.set(n - 1, n - 1, q / this.H.get(n, n - 1));
                this.H.set(n - 1, n, -(this.H.get(n, n) - p) / this.H.get(n, n - 1));
            } else {
                Complex.cDiv(0.0, -this.H.get(n - 1, n), this.H.get(n - 1, n - 1) - p, q, cr);
                this.H.set(n - 1, n - 1, cr[0]);
                this.H.set(n - 1, n, cr[1]);
            }
            this.H.set(n, n - 1, 0.0);
            this.H.set(n, n, 1.0);
            for (i = n - 2; i >= 0; --i) {
                double ra = 0.0;
                double sa = 0.0;
                for (int j = l; j <= n; ++j) {
                    ra += this.H.get(i, j) * this.H.get(j, n - 1);
                    sa += this.H.get(i, j) * this.H.get(j, n);
                }
                w = this.H.get(i, i) - p;
                if (this.e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (this.e[i] == 0.0) {
                    Complex.cDiv(-ra, -sa, w, q, cr);
                    this.H.set(i, n - 1, cr[0]);
                    this.H.set(i, n, cr[1]);
                } else {
                    this.hqr2SolveComplexEigenEquation(i, p, q, eps, norm, w, z, r, ra, sa, s, cr, n);
                }
                t = Math.max(Math.abs(this.H.get(i, n - 1)), Math.abs(this.H.get(i, n)));
                if (!(eps * t * t > 1.0)) continue;
                RowColumnOps.multCol(this.H, n - 1, i, n + 1, 1.0 / t);
                RowColumnOps.multCol(this.H, n, i, n + 1, 1.0 / t);
            }
        }
    }

    private double hqr2GetNormStart(int nn, int low, int high) {
        double norm = 0.0;
        for (int i = 0; i < nn; ++i) {
            if (i < low | i > high) {
                this.d[i] = this.H.get(i, i);
                this.e[i] = 0.0;
            }
            for (int j = Math.max(i - 1, 0); j < nn; ++j) {
                norm += Math.abs(this.H.get(i, j));
            }
        }
        return norm;
    }

    private void backtransform(int nn, int low, int high) {
        for (int j = nn - 1; j >= low; --j) {
            for (int i = low; i <= high; ++i) {
                double z = 0.0;
                for (int k = low; k <= Math.min(j, high); ++k) {
                    z += this.V.get(i, k) * this.H.get(k, j);
                }
                this.V.set(i, j, z);
            }
        }
    }

    private void hqr2FoundTwoRoots(double exshift, int n, int nn, int low, int high) {
        double w = this.H.get(n, n - 1) * this.H.get(n - 1, n);
        double p = (this.H.get(n - 1, n - 1) - this.H.get(n, n)) / 2.0;
        double q = p * p + w;
        double z = Math.sqrt(Math.abs(q));
        this.H.increment(n, n, exshift);
        this.H.increment(n - 1, n - 1, exshift);
        double x = this.H.get(n, n);
        if (q >= 0.0) {
            z = p >= 0.0 ? p + z : p - z;
            this.d[n - 1] = x + z;
            this.d[n] = this.d[n - 1];
            if (z != 0.0) {
                this.d[n] = x - w / z;
            }
            this.e[n - 1] = 0.0;
            this.e[n] = 0.0;
            x = this.H.get(n, n - 1);
            double s = Math.abs(x) + Math.abs(z);
            p = x / s;
            q = z / s;
            double r = Math.sqrt(p * p + q * q);
            EigenValueDecomposition.rowOpTransform(this.H, n - 1, nn - 1, n, q /= r, p /= r);
            EigenValueDecomposition.columnOpTransform(this.H, 0, n, n, q, p, -1);
            EigenValueDecomposition.columnOpTransform(this.V, low, high, n, q, p, -1);
        } else {
            this.d[n - 1] = x + p;
            this.d[n] = x + p;
            this.e[n - 1] = z;
            this.e[n] = -z;
        }
    }

    private void orthesAccumulateTransforamtions(int high, int low, double[] ort) {
        for (int m = high - 1; m >= low + 1; --m) {
            if (this.H.get(m, m - 1) == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                ort[i] = this.H.get(i, m - 1);
            }
            for (int j = m; j <= high; ++j) {
                double g = 0.0;
                for (int i = m; i <= high; ++i) {
                    g += ort[i] * this.V.get(i, j);
                }
                g = g / ort[m] / this.H.get(m, m - 1);
                RowColumnOps.addMultCol(this.V, j, m, high + 1, g, ort);
            }
        }
    }

    private void orthesApplyHouseholder(int m, int high, double[] ort, double h) {
        double f;
        for (int j = m; j < this.n; ++j) {
            f = 0.0;
            for (int i = m; i <= high; ++i) {
                f += ort[i] * this.H.get(i, j);
            }
            RowColumnOps.addMultCol(this.H, j, m, high + 1, -(f /= h), ort);
        }
        for (int i = 0; i <= high; ++i) {
            f = 0.0;
            for (int j = m; j <= high; ++j) {
                f += ort[j] * this.H.get(i, j);
            }
            RowColumnOps.addMultRow(this.H, i, m, high + 1, -(f /= h), ort);
        }
    }
}

