/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import jsat.linear.Matrix;
import jsat.linear.Vec;

public class RowColumnOps {
    public static void addDiag(Matrix A2, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A2.increment(i, i, c);
        }
    }

    public static void addRow(Matrix A2, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A2.increment(i, j, c);
        }
    }

    public static void addRow(Matrix A2, int i, double c) {
        RowColumnOps.addRow(A2, i, 0, A2.cols(), c);
    }

    public static void multRow(Matrix A2, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A2.set(i, j, A2.get(i, j) * c);
        }
    }

    public static void multRow(Matrix A2, int i, double c) {
        RowColumnOps.multRow(A2, i, 0, A2.cols(), c);
    }

    public static void multRow(Matrix A2, int i, int start, int to, Vec c) {
        for (int j = start; j < to; ++j) {
            A2.set(i, j, A2.get(i, j) * c.get(j));
        }
    }

    public static void multRow(Matrix A2, int i, Vec c) {
        if (A2.cols() != c.length()) {
            throw new ArithmeticException("Can not perform row update, length miss match " + A2.cols() + " and " + c.length());
        }
        RowColumnOps.multRow(A2, i, 0, c.length(), c);
    }

    public static void multRow(Matrix A2, int i, int start, int to, double[] c) {
        for (int j = start; j < to; ++j) {
            A2.set(i, j, A2.get(i, j) * c[j]);
        }
    }

    public static void multRow(Matrix A2, int i, double[] c) {
        if (A2.cols() != c.length) {
            throw new ArithmeticException("Can not perform row update, length miss match " + A2.cols() + " and " + c.length);
        }
        RowColumnOps.multRow(A2, i, 0, c.length, c);
    }

    public static void divRow(Matrix A2, int i, int start, int to, double c) {
        for (int j = start; j < to; ++j) {
            A2.set(i, j, A2.get(i, j) / c);
        }
    }

    public static void divRow(Matrix A2, int i, double c) {
        RowColumnOps.divRow(A2, i, 0, A2.cols(), c);
    }

    public static void addCol(Matrix A2, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A2.increment(i, j, c);
        }
    }

    public static void addCol(Matrix A2, int j, double c) {
        RowColumnOps.addCol(A2, j, 0, A2.rows(), c);
    }

    public static void multCol(Matrix A2, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A2.set(i, j, A2.get(i, j) * c);
        }
    }

    public static void multCol(Matrix A2, int j, double c) {
        RowColumnOps.multCol(A2, j, 0, A2.rows(), c);
    }

    public static void divCol(Matrix A2, int j, int start, int to, double c) {
        for (int i = start; i < to; ++i) {
            A2.set(i, j, A2.get(i, j) / c);
        }
    }

    public static void divCol(Matrix A2, int j, double c) {
        RowColumnOps.divCol(A2, j, 0, A2.rows(), c);
    }

    public static void divCol(Matrix A2, int j, int start, int to, Vec c) {
        for (int i = start; i < to; ++i) {
            A2.set(i, j, A2.get(i, j) / c.get(i));
        }
    }

    public static void divCol(Matrix A2, int j, int start, int to, double[] c) {
        for (int i = start; i < to; ++i) {
            A2.set(i, j, A2.get(i, j) / c[i]);
        }
    }

    public static void addMultRow(Matrix A2, int i, int start, int to, double t, double[] c) {
        for (int j = start; j < to; ++j) {
            A2.increment(i, j, c[j] * t);
        }
    }

    public static void addMultRow(Matrix A2, int i, int start, int to, double t, Vec c) {
        for (int j = start; j < to; ++j) {
            A2.increment(i, j, c.get(j) * t);
        }
    }

    public static void addMultCol(Matrix A2, int j, int start, int to, double t, double[] c) {
        for (int i = start; i < to; ++i) {
            A2.increment(i, j, c[i] * t);
        }
    }

    public static void addMultCol(Matrix A2, int j, int start, int to, double t, Vec c) {
        for (int i = start; i < to; ++i) {
            A2.increment(i, j, c.get(i) * t);
        }
    }

    public static void swapCol(Matrix A2, int j, int k, int start, int to) {
        for (int i = start; i < to; ++i) {
            double t = A2.get(i, j);
            A2.set(i, j, A2.get(i, k));
            A2.set(i, k, t);
        }
    }

    public static void swapCol(Matrix A2, int j, int k) {
        RowColumnOps.swapCol(A2, j, k, 0, A2.rows());
    }

    public static void swapRow(Matrix A2, int j, int k, int start, int to) {
        for (int i = start; i < to; ++i) {
            double t = A2.get(j, i);
            A2.set(j, i, A2.get(k, i));
            A2.set(k, i, t);
        }
    }

    public static void swapRow(Matrix A2, int j, int k) {
        RowColumnOps.swapCol(A2, j, k, 0, A2.cols());
    }

    public static void fillRow(Matrix A2, int i, int from, int to, double val) {
        for (int j = from; j < to; ++j) {
            A2.set(i, j, val);
        }
    }

    public static void fillCol(Matrix A2, int j, int from, int to, double val) {
        for (int i = from; i < to; ++i) {
            A2.set(i, j, val);
        }
    }
}

