/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.RowColumnOps;
import jsat.linear.TransposeView;
import jsat.linear.Vec;

public class SingularValueDecomposition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1711766946748622002L;
    private Matrix U;
    private Matrix V;
    private double[] s;

    public SingularValueDecomposition(Matrix A2) {
        this(A2, 100);
    }

    public SingularValueDecomposition(Matrix A2, int maxIterations) {
        boolean transposedWord = A2.rows() < A2.cols();
        Matrix AA = transposedWord ? new TransposeView(A2) : A2;
        int m = AA.rows();
        int n = AA.cols();
        int nu = Math.min(m, n);
        this.U = new DenseMatrix(m, nu);
        this.V = new DenseMatrix(n, n);
        this.s = new double[Math.min(m + 1, n)];
        double[] e = new double[n];
        double[] work = new double[m];
        int nct = Math.min(m - 1, n);
        int nrt = Math.max(0, Math.min(n - 2, m));
        this.bidiagonalize(nct, nrt, m, AA, n, e, work);
        int p = Math.min(n, m + 1);
        if (nct < n) {
            this.s[nct] = AA.get(nct, nct);
        }
        if (m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = AA.get(nrt, p - 1);
        }
        e[p - 1] = 0.0;
        this.generateU(nct, nu, m);
        this.generateV(n, nrt, e, nu);
        this.mainIterationLoop(p, e, n, m, maxIterations);
        if (transposedWord) {
            Matrix tmp = this.V;
            this.V = this.U;
            this.U = tmp;
        }
    }

    public SingularValueDecomposition(Matrix U, Matrix V, double[] s) {
        this.U = U;
        this.V = V;
        this.s = s;
    }

    private void bidiagonalize(int nct, int nrt, int m, Matrix A2, int n, double[] e, double[] work) {
        for (int k = 0; k < Math.max(nct, nrt); ++k) {
            int i;
            if (k < nct) {
                this.s[k] = 0.0;
                for (i = k; i < m; ++i) {
                    this.s[k] = Math.hypot(this.s[k], A2.get(i, k));
                }
                if (this.s[k] != 0.0) {
                    if (A2.get(k, k) < 0.0) {
                        this.s[k] = -this.s[k];
                    }
                    RowColumnOps.divCol(A2, k, k, m, this.s[k]);
                    A2.increment(k, k, 1.0);
                }
                this.s[k] = -this.s[k];
            }
            for (int j = k + 1; j < n; ++j) {
                if (k < nct & this.s[k] != 0.0) {
                    int i2;
                    double t = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        t += A2.get(i2, k) * A2.get(i2, j);
                    }
                    t = -t / A2.get(k, k);
                    for (i2 = k; i2 < m; ++i2) {
                        A2.increment(i2, j, t * A2.get(i2, k));
                    }
                }
                e[j] = A2.get(k, j);
            }
            if (k < nct) {
                for (i = k; i < m; ++i) {
                    this.U.set(i, k, A2.get(i, k));
                }
            }
            if (k >= nrt) continue;
            this.superDiagonalCreation(e, k, n, m, work, A2);
        }
    }

    private int sLength() {
        return Math.min(this.U.rows(), this.V.rows());
    }

    private void superDiagonalCreation(double[] e, int k, int n, int m, double[] work, Matrix A2) {
        int i;
        e[k] = 0.0;
        for (i = k + 1; i < n; ++i) {
            e[k] = Math.hypot(e[k], e[i]);
        }
        if (e[k] != 0.0) {
            if (e[k + 1] < 0.0) {
                e[k] = -e[k];
            }
            i = k + 1;
            while (i < n) {
                int n2 = i++;
                e[n2] = e[n2] / e[k];
            }
            int n3 = k + 1;
            e[n3] = e[n3] + 1.0;
        }
        e[k] = -e[k];
        if (k + 1 < m & e[k] != 0.0) {
            int j;
            Arrays.fill(work, k + 1, m, 0.0);
            for (j = k + 1; j < n; ++j) {
                for (int i2 = k + 1; i2 < m; ++i2) {
                    int n4 = i2;
                    work[n4] = work[n4] + e[j] * A2.get(i2, j);
                }
            }
            for (j = k + 1; j < n; ++j) {
                double t = -e[j] / e[k + 1];
                RowColumnOps.addMultCol(A2, j, k + 1, m, t, work);
            }
        }
        for (i = k + 1; i < n; ++i) {
            this.V.set(i, k, e[i]);
        }
    }

    private void generateV(int n, int nrt, double[] e, int nu) {
        for (int k = n - 1; k >= 0; --k) {
            if (k < nrt & e[k] != 0.0) {
                for (int j = k + 1; j < nu; ++j) {
                    int i;
                    double t = 0.0;
                    for (i = k + 1; i < n; ++i) {
                        t += this.V.get(i, k) * this.V.get(i, j);
                    }
                    t = -t / this.V.get(k + 1, k);
                    for (i = k + 1; i < n; ++i) {
                        this.V.increment(i, j, t * this.V.get(i, k));
                    }
                }
            }
            for (int i = 0; i < n; ++i) {
                this.V.set(i, k, 0.0);
            }
            this.V.set(k, k, 1.0);
        }
    }

    private void generateU(int nct, int nu, int m) {
        int i;
        for (int j = nct; j < nu; ++j) {
            for (i = 0; i < m; ++i) {
                this.U.set(i, j, 0.0);
            }
            this.U.set(j, j, 1.0);
        }
        for (int k = nct - 1; k >= 0; --k) {
            if (this.s[k] != 0.0) {
                for (int j = k + 1; j < nu; ++j) {
                    int i2;
                    double t = 0.0;
                    for (i2 = k; i2 < m; ++i2) {
                        t += this.U.get(i2, k) * this.U.get(i2, j);
                    }
                    t = -t / this.U.get(k, k);
                    for (i2 = k; i2 < m; ++i2) {
                        this.U.increment(i2, j, t * this.U.get(i2, k));
                    }
                }
                for (i = k; i < m; ++i) {
                    this.U.set(i, k, -this.U.get(i, k));
                }
                this.U.set(k, k, 1.0 + this.U.get(k, k));
                for (i = 0; i < k - 1; ++i) {
                    this.U.set(i, k, 0.0);
                }
                continue;
            }
            for (i = 0; i < m; ++i) {
                this.U.set(i, k, 0.0);
            }
            this.U.set(k, k, 1.0);
        }
    }

    private void mainIterationLoop(int p, double[] e, int n, int m, int maxIterations) {
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        while (p > 0 && iter < maxIterations) {
            int kase;
            int k;
            for (k = p - 2; k >= -1 && k != -1; --k) {
                if (!(Math.abs(e[k]) <= eps * (Math.abs(this.s[k]) + Math.abs(this.s[k + 1])))) continue;
                e[k] = 0.0;
                break;
            }
            if (k == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k && ks != k; --ks) {
                    double t = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!(Math.abs(this.s[ks]) <= eps * t)) continue;
                    this.s[ks] = 0.0;
                    break;
                }
                if (ks == k) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k = ks;
                }
            }
            ++k;
            switch (kase) {
                case 1: {
                    this.case1(e, p, k, n);
                    break;
                }
                case 2: {
                    this.case2(e, k, p, m);
                    break;
                }
                case 3: {
                    this.case3QRStep(p, e, k, n, m);
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k] <= 0.0) {
                        this.s[k] = this.s[k] < 0.0 ? -this.s[k] : 0.0;
                        RowColumnOps.multCol(this.V, k, 0, pp + 1, -1.0);
                    }
                    while (k < pp && !(this.s[k] >= this.s[k + 1])) {
                        double t = this.s[k];
                        this.s[k] = this.s[k + 1];
                        this.s[k + 1] = t;
                        if (k < n - 1) {
                            RowColumnOps.swapCol(this.V, k, k + 1, 0, n);
                        }
                        if (k < m - 1) {
                            RowColumnOps.swapCol(this.U, k, k + 1, 0, m);
                        }
                        ++k;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    private void case1(double[] e, int p, int k, int n) {
        double f = e[p - 2];
        e[p - 2] = 0.0;
        for (int j = p - 2; j >= k; --j) {
            double t = Math.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            if (j != k) {
                f = -sn * e[j - 1];
                e[j - 1] = cs * e[j - 1];
            }
            this.UVCase12Update(this.V, n, cs, j, sn, p);
        }
    }

    private void case2(double[] e, int k, int p, int m) {
        double f = e[k - 1];
        e[k - 1] = 0.0;
        for (int j = k; j < p; ++j) {
            double t = Math.hypot(this.s[j], f);
            double cs = this.s[j] / t;
            double sn = f / t;
            this.s[j] = t;
            f = -sn * e[j];
            e[j] = cs * e[j];
            this.UVCase12Update(this.U, m, cs, j, sn, k);
        }
    }

    private void UVCase12Update(Matrix UV, int m, double cs, int j, double sn, int k) {
        for (int i = 0; i < m; ++i) {
            double t = cs * UV.get(i, j) + sn * UV.get(i, k - 1);
            UV.set(i, k - 1, -sn * UV.get(i, j) + cs * UV.get(i, k - 1));
            UV.set(i, j, t);
        }
    }

    private void case3QRStep(int p, double[] e, int k, int n, int m) {
        double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k])), Math.abs(e[k]));
        double sp2 = this.s[p - 1] / scale;
        double spm1 = this.s[p - 2] / scale;
        double epm1 = e[p - 2] / scale;
        double sk = this.s[k] / scale;
        double ek = e[k] / scale;
        double b = ((spm1 + sp2) * (spm1 - sp2) + epm1 * epm1) / 2.0;
        double c = sp2 * epm1 * (sp2 * epm1);
        double shift = 0.0;
        if (b != 0.0 | c != 0.0) {
            shift = Math.sqrt(b * b + c);
            if (b < 0.0) {
                shift = -shift;
            }
            shift = c / (b + shift);
        }
        double f = (sk + sp2) * (sk - sp2) + shift;
        double g = sk * ek;
        for (int j = k; j < p - 1; ++j) {
            double t = Math.hypot(f, g);
            double cs = f / t;
            double sn = g / t;
            if (j != k) {
                e[j - 1] = t;
            }
            f = cs * this.s[j] + sn * e[j];
            e[j] = cs * e[j] - sn * this.s[j];
            g = sn * this.s[j + 1];
            this.s[j + 1] = cs * this.s[j + 1];
            this.UVCase3Update(this.V, n, cs, j, sn);
            t = Math.hypot(f, g);
            cs = f / t;
            sn = g / t;
            this.s[j] = t;
            f = cs * e[j] + sn * this.s[j + 1];
            this.s[j + 1] = -sn * e[j] + cs * this.s[j + 1];
            g = sn * e[j + 1];
            e[j + 1] = cs * e[j + 1];
            if (j >= m - 1) continue;
            this.UVCase3Update(this.U, m, cs, j, sn);
        }
        e[p - 2] = f;
    }

    private void UVCase3Update(Matrix UV, int m, double cs, int j, double sn) {
        for (int i = 0; i < m; ++i) {
            double t = cs * UV.get(i, j) + sn * UV.get(i, j + 1);
            UV.set(i, j + 1, -sn * UV.get(i, j) + cs * UV.get(i, j + 1));
            UV.set(i, j, t);
        }
    }

    public Matrix getU() {
        return this.U;
    }

    public Matrix getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return Arrays.copyOf(this.s, this.sLength());
    }

    public Matrix getS() {
        DenseMatrix DS = new DenseMatrix(this.U.rows(), this.V.rows());
        for (int i = 0; i < this.sLength(); ++i) {
            ((Matrix)DS).set(i, i, this.s[i]);
        }
        return DS;
    }

    public double getNorm2() {
        return this.s[0];
    }

    public double getCondition() {
        return this.getNorm2() / this.s[this.sLength() - 1];
    }

    private double getDefaultTolerance() {
        return (double)Math.max(this.U.rows(), this.V.rows()) * (Math.nextUp(this.getNorm2()) - this.getNorm2());
    }

    public int getRank() {
        return this.getRank(this.getDefaultTolerance());
    }

    public boolean isFullRank() {
        return this.getRank() == this.sLength();
    }

    public int getRank(double tol) {
        for (int i = 0; i < this.sLength(); ++i) {
            if (!(this.s[i] <= tol)) continue;
            return i;
        }
        return this.sLength();
    }

    public double[] getInverseSingularValues() {
        return this.getInverseSingularValues(this.getDefaultTolerance());
    }

    public double[] getInverseSingularValues(double tol) {
        double[] sInv = Arrays.copyOf(this.s, this.sLength());
        for (int i = 0; i < sInv.length; ++i) {
            sInv[i] = sInv[i] > tol ? 1.0 / sInv[i] : 0.0;
        }
        return sInv;
    }

    public Matrix getPseudoInverse() {
        return this.getPseudoInverse(this.getDefaultTolerance());
    }

    public Matrix getPseudoInverse(double tol) {
        Matrix UT = this.U.transpose();
        Matrix.diagMult(DenseVector.toDenseVec(this.getInverseSingularValues(tol)), UT);
        return this.V.multiply(UT);
    }

    public double getPseudoDet() {
        return this.getPseudoDet(this.getDefaultTolerance());
    }

    public double getPseudoDet(double tol) {
        double det = 1.0;
        for (double d : this.s) {
            if (d <= tol) break;
            det *= d;
        }
        return det;
    }

    public double absDet() {
        double absDet = 1.0;
        for (double d : this.s) {
            absDet *= d;
        }
        return absDet;
    }

    public Vec solve(Vec b) {
        Vec x = this.U.transposeMultiply(1.0, b);
        x.mutablePairwiseMultiply(DenseVector.toDenseVec(this.getInverseSingularValues()));
        return this.V.multiply(x);
    }

    public Matrix solve(Matrix B) {
        Matrix x = this.U.transposeMultiply(B);
        Matrix.diagMult(DenseVector.toDenseVec(this.getInverseSingularValues()), x);
        return this.V.multiply(x);
    }

    public Matrix solve(Matrix b, ExecutorService threadpool) {
        Matrix x = this.U.transposeMultiply(b, threadpool);
        Matrix.diagMult(DenseVector.toDenseVec(this.getInverseSingularValues()), x);
        return this.V.multiply(x, threadpool);
    }

    public SingularValueDecomposition clone() {
        return new SingularValueDecomposition(this.U.clone(), this.V.clone(), Arrays.copyOf(this.s, this.s.length));
    }
}

