/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Arrays;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.Lanczos;
import jsat.linear.Matrix;

public class TruncatedSVD {
    private Matrix U;
    private Matrix V;
    private double[] s;

    public TruncatedSVD(Matrix A2, int k) {
        DenseVector invertS = new DenseVector(k);
        if (A2.rows() < A2.cols()) {
            Lanczos u_lanc = new Lanczos(A2, k, true, false);
            this.U = u_lanc.getEigenVectors();
            this.s = u_lanc.d;
            for (int i = 0; i < k; ++i) {
                this.s[i] = Math.sqrt(Math.max(this.s[i], 0.0));
                if (this.s[i] == 0.0) {
                    invertS.set(i, 0.0);
                    continue;
                }
                invertS.set(i, 1.0 / this.s[i]);
            }
            this.V = A2.transposeMultiply(this.U);
            Matrix.diagMult(this.V, invertS);
            this.V = this.V.transpose();
        } else {
            Lanczos v_lanc = new Lanczos(A2, k, false, false);
            this.V = v_lanc.getEigenVectors().transpose();
            this.s = v_lanc.d;
            for (int i = 0; i < k; ++i) {
                this.s[i] = Math.sqrt(Math.max(this.s[i], 0.0));
                if (this.s[i] == 0.0) {
                    invertS.set(i, 0.0);
                    continue;
                }
                invertS.set(i, 1.0 / this.s[i]);
            }
            Matrix tmp = this.V.clone();
            Matrix.diagMult(invertS, tmp);
            this.U = A2.multiplyTranspose(tmp);
        }
    }

    private int sLength() {
        return Math.min(this.U.rows(), this.V.rows());
    }

    public Matrix getU() {
        return this.U;
    }

    public Matrix getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return Arrays.copyOf(this.s, this.sLength());
    }

    public Matrix getS() {
        DenseMatrix DS = new DenseMatrix(this.U.rows(), this.V.rows());
        for (int i = 0; i < this.sLength(); ++i) {
            ((Matrix)DS).set(i, i, this.s[i]);
        }
        return DS;
    }

    public double getNorm2() {
        return this.s[0];
    }

    public double getCondition() {
        return this.getNorm2() / this.s[this.sLength() - 1];
    }

    private double getDefaultTolerance() {
        return (double)Math.max(this.U.rows(), this.V.rows()) * (Math.nextUp(this.getNorm2()) - this.getNorm2());
    }

    public int getRank() {
        return this.getRank(this.getDefaultTolerance());
    }

    public boolean isFullRank() {
        return this.getRank() == this.sLength();
    }

    public int getRank(double tol) {
        for (int i = 0; i < this.sLength(); ++i) {
            if (!(this.s[i] <= tol)) continue;
            return i;
        }
        return this.sLength();
    }

    public double[] getInverseSingularValues() {
        return this.getInverseSingularValues(this.getDefaultTolerance());
    }

    public double[] getInverseSingularValues(double tol) {
        double[] sInv = Arrays.copyOf(this.s, this.sLength());
        for (int i = 0; i < sInv.length; ++i) {
            sInv[i] = sInv[i] > tol ? 1.0 / sInv[i] : 0.0;
        }
        return sInv;
    }
}

