/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.stream.Collectors;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.utils.BoundedSortedList;
import jsat.utils.IndexTable;
import jsat.utils.IntList;
import jsat.utils.ProbailityMatch;

public class RTree<V extends Vec>
implements IncrementalCollection<V> {
    private static final long serialVersionUID = -7067110612346062800L;
    private int size;
    private RNode root = new RNode();
    private int M;
    private int m;
    private int dim;
    private DenseVector dcScratch;
    private DistanceMetric dm;
    private List<V> allVecs;

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        Rectangle searchSpace = new Rectangle(this.dim, range, query);
        neighbors.clear();
        distances.clear();
        this.search(searchSpace, this.root, neighbors, distances);
        Iterator<Integer> nIter = neighbors.iterator();
        ListIterator<Double> dIter = distances.listIterator();
        assert (neighbors.size() == distances.size());
        while (nIter.hasNext()) {
            double d;
            int indx = nIter.next();
            double dist = dIter.next();
            dist = this.dm.dist(query, VecPaired.extractTrueVec(this.get(indx)));
            if (d <= range) {
                dIter.set(dist);
                continue;
            }
            nIter.remove();
            dIter.remove();
        }
        IndexTable it = new IndexTable(distances);
        it.apply(distances);
        it.apply(neighbors);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        Stack<ProbailityMatch<RNode<Object>>> stack = new Stack<ProbailityMatch<RNode<Object>>>();
        BoundedSortedList<ProbailityMatch<Integer>> curBest = new BoundedSortedList<ProbailityMatch<Integer>>(numNeighbors);
        curBest.add(new ProbailityMatch<Integer>(Double.MAX_VALUE, -1));
        stack.push(new ProbailityMatch<RNode>(this.minDist(query, this.root.bound), this.root));
        ArrayList ABL = new ArrayList();
        while (!stack.isEmpty()) {
            ProbailityMatch poped = (ProbailityMatch)stack.pop();
            RNode N = (RNode)poped.getMatch();
            double minDistN = poped.getProbability();
            if (!(minDistN <= ((ProbailityMatch)curBest.last()).getProbability())) continue;
            if (N.isLeaf()) {
                Iterator iterator = N.points.iterator();
                while (iterator.hasNext()) {
                    int indx = (Integer)iterator.next();
                    double dist = this.dm.dist(query, VecPaired.extractTrueVec(this.get(indx)));
                    curBest.add(new ProbailityMatch<Integer>(dist, indx));
                }
                continue;
            }
            for (int i = 0; i < N.size(); ++i) {
                double i_min = this.minDist(query, N.getChild((int)i).bound);
                if (!(i_min <= ((ProbailityMatch)curBest.last()).getProbability())) continue;
                ABL.add(new ProbailityMatch(i_min, N.getChild(i)));
            }
            Collections.sort(ABL, Collections.reverseOrder());
            stack.addAll(ABL);
            ABL.clear();
        }
        neighbors.clear();
        distances.clear();
        for (int i = 0; i < curBest.size(); ++i) {
            ProbailityMatch pm = (ProbailityMatch)curBest.get(i);
            neighbors.add((Integer)pm.getMatch());
            distances.add(pm.getProbability());
        }
    }

    private void search(Rectangle query, RNode<V> node, List<Integer> neighbors, List<Double> distances) {
        if (!node.isLeaf()) {
            for (int i = 0; i < ((RNode)node).size(); ++i) {
                if (!node.getChild((int)i).bound.intersects(query)) continue;
                this.search(query, node.getChild(i), neighbors, distances);
            }
        } else {
            for (int i = 0; i < ((RNode)node).size(); ++i) {
                if (!query.contains((Vec)this.get(node.points.get(i)))) continue;
                neighbors.add(node.points.get(i));
                distances.add(Double.NaN);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RTree<V> clone() {
        return new RTree<V>(this);
    }

    private RNode cloneChangeContext(RNode toClone) {
        if (toClone != null && toClone instanceof RNode) {
            return new RNode(toClone);
        }
        return null;
    }

    @Override
    public List<Double> getAccelerationCache() {
        return null;
    }

    public RTree() {
        this(new EuclideanDistance());
    }

    public RTree(DistanceMetric dm) {
        this(dm, 5);
    }

    public RTree(DistanceMetric dm, int max) {
        this(dm, max, (int)((double)max * 0.4));
    }

    public RTree(DistanceMetric dm, int max, int min) {
        if (max < 2) {
            throw new RuntimeException("The maximum number of elements per node must be at least 2");
        }
        if (min > max / 2 || min < 1) {
            throw new RuntimeException("Invalid minumum, min must be in the range[1, " + max / 2 + "]");
        }
        this.M = max;
        this.m = min;
        this.setDistanceMetric(dm);
        this.allVecs = new ArrayList<V>();
    }

    public RTree(RTree<V> toCopy) {
        this(toCopy.dm.clone(), toCopy.M, toCopy.m);
        this.size = toCopy.size;
        this.dim = toCopy.dim;
        if (toCopy.root != null) {
            this.root = super.cloneChangeContext(toCopy.root);
        }
        for (Vec v : toCopy.allVecs) {
            this.allVecs.add(v);
        }
        if (toCopy.dcScratch != null) {
            this.dcScratch = toCopy.dcScratch.clone();
        }
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.setDistanceMetric(dm);
        for (Vec v : collection) {
            this.insert(v);
        }
    }

    @Override
    public void setDistanceMetric(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.dm;
    }

    private RNode<V> chooseLeaf(Vec v) {
        RNode N = this.root;
        while (!N.isLeaf()) {
            double leastEnlargment = N.children.get((int)0).bound.increasedArea(v);
            int ind = 0;
            for (int i = 1; i < N.children.size(); ++i) {
                double nb = N.children.get((int)i).bound.increasedArea(v);
                if (nb < leastEnlargment) {
                    leastEnlargment = nb;
                    ind = i;
                    continue;
                }
                if (nb != leastEnlargment || !(N.children.get((int)i).bound.area() < N.children.get((int)ind).bound.area())) continue;
                leastEnlargment = nb;
                ind = i;
            }
            N = N.children.get(ind);
        }
        return N;
    }

    private RNode<V> splitNode(RNode<V> toSplit) {
        Rectangle rec1;
        Rectangle rec2;
        double d = Double.MIN_VALUE;
        int e1 = 0;
        int e2 = 0;
        for (int i2 = 0; i2 < toSplit.size(); ++i2) {
            for (int j = 0; j < toSplit.size(); ++j) {
                if (j == i2) continue;
                Rectangle E1Bound = toSplit.nthBound(i2);
                Rectangle E2Bound = toSplit.nthBound(j);
                Rectangle[] rectangleArray = new Rectangle[]{E1Bound, E2Bound};
                Rectangle J = new Rectangle(rectangleArray);
                double dCandidate = J.area() - E1Bound.area() - E2Bound.area();
                if (!(dCandidate > d)) continue;
                e1 = i2;
                e2 = j;
                d = dCandidate;
            }
        }
        int maxE = Math.max(e1, e2);
        e1 = Math.min(e1, e2);
        e2 = maxE;
        if (toSplit.isLeaf()) {
            IntList group1 = new IntList(this.m + 1);
            IntList group2 = new IntList(this.m + 1);
            IntList toAsign = toSplit.points;
            group2.add(toAsign.remove(e2));
            group1.add(toAsign.remove(e1));
            rec2 = new Rectangle((Vec)this.get(group2.get(0)));
            rec1 = new Rectangle((Vec)this.get(group1.get(0)));
            while (!toAsign.isEmpty()) {
                if (group1.size() >= this.m && group2.size() < this.m && toAsign.size() - group2.size() == 0) {
                    group2.addAll(toAsign);
                    toAsign.clear();
                    continue;
                }
                if (group2.size() >= this.m && group1.size() < this.m && toAsign.size() - group1.size() == 0) {
                    group1.addAll(toAsign);
                    toAsign.clear();
                    continue;
                }
                double minEnlargment = Double.MAX_VALUE;
                int index = -1;
                boolean toG1 = false;
                for (int i3 = 0; i3 < toAsign.size(); ++i3) {
                    double enlarg2;
                    double enlarg1 = rec1.increasedArea((Vec)this.get(toAsign.get(i3)));
                    boolean thisToG1 = enlarg1 < (enlarg2 = rec2.increasedArea((Vec)this.get(toAsign.get(i3))));
                    double enlarg = Math.min(enlarg1, enlarg2);
                    if (!(enlarg < minEnlargment)) continue;
                    minEnlargment = enlarg;
                    index = i3;
                    toG1 = thisToG1;
                }
                (toG1 ? group1 : group2).add(toAsign.remove(index));
            }
            toSplit.points = group1;
            toSplit.bound = Rectangle.contains(toSplit.points.stream().map(i -> this.get((int)i)).collect(Collectors.toList()));
            return new RNode(group2);
        }
        List toAsign = toSplit.children;
        toSplit.children = new ArrayList();
        toSplit.bound = null;
        RNode group1 = toSplit;
        RNode group2 = new RNode();
        group2.add(toAsign.remove(e2));
        group1.add(toAsign.remove(e1));
        rec2 = group2.bound;
        rec1 = group1.bound;
        while (!toAsign.isEmpty()) {
            if (group1.size() >= this.m && group2.size() < this.m && toAsign.size() - group2.size() == 0) {
                for (RNode node : toAsign) {
                    group2.add(node);
                }
                toAsign.clear();
                continue;
            }
            if (group2.size() >= this.m && group1.size() < this.m && toAsign.size() - group1.size() == 0) {
                for (RNode node : toAsign) {
                    group1.add(node);
                }
                toAsign.clear();
                continue;
            }
            double minEnlargment = Double.MAX_VALUE;
            int index = -1;
            boolean toG1 = false;
            for (int i4 = 0; i4 < toAsign.size(); ++i4) {
                double enlarg2;
                double enlarg1 = rec1.increasedArea(toAsign.get((int)i4).bound);
                boolean thisToG1 = enlarg1 < (enlarg2 = rec2.increasedArea(toAsign.get((int)i4).bound));
                double enlarg = Math.min(enlarg1, enlarg2);
                if (!(enlarg < minEnlargment)) continue;
                minEnlargment = enlarg;
                index = i4;
                toG1 = thisToG1;
            }
            (toG1 ? group1 : group2).add(toAsign.remove(index));
        }
        return group2;
    }

    private void AdjustTree(RNode<V> L, RNode<V> LL) {
        RNode<V> N = L;
        RNode<V> NN = LL;
        while (N != this.root) {
            RNode<V> P = N.parent;
            P.bound.adjustToContain(N.bound);
            if (NN != null) {
                NN = P.add(NN) ? this.splitNode(P) : null;
            }
            N = P;
        }
        if (NN != null) {
            this.root = new RNode();
            this.root.add(N);
            this.root.add(NN);
        }
    }

    @Override
    public V get(int indx) {
        return (V)((Vec)this.allVecs.get(indx));
    }

    @Override
    public synchronized void insert(V v) {
        int indx = this.allVecs.size();
        if (indx == 0) {
            this.dim = ((Vec)v).length();
            this.dcScratch = new DenseVector(this.dim);
        }
        this.allVecs.add(v);
        RNode<V> L = this.chooseLeaf((Vec)v);
        RNode<V> LL = null;
        if (L.add(indx)) {
            LL = this.splitNode(L);
        }
        this.AdjustTree(L, LL);
        ++this.size;
    }

    private double minDist(Vec p, Rectangle r) {
        if (r.contains(p)) {
            return 0.0;
        }
        for (int i = 0; i < this.dim; ++i) {
            double pi = p.get(i);
            if (pi < r.lB.get(i)) {
                this.dcScratch.set(i, r.lB.get(i));
                continue;
            }
            if (pi > r.uB.get(i)) {
                this.dcScratch.set(i, r.uB.get(i));
                continue;
            }
            this.dcScratch.set(i, pi);
        }
        return this.dm.dist(p, this.dcScratch);
    }

    private double minMaxDist(Vec p, Rectangle r) {
        if (r.contains(p)) {
            return 0.0;
        }
        double minDist = Double.MAX_VALUE;
        for (int k = 0; k < this.dim; ++k) {
            for (int j = 0; j < this.dim; ++j) {
                double pj = p.get(j);
                double sj = r.lB.get(j);
                double tj = r.uB.get(j);
                if (j == k) {
                    if (pj <= (sj + tj) * 0.5) {
                        this.dcScratch.set(j, sj);
                        continue;
                    }
                    this.dcScratch.set(j, tj);
                    continue;
                }
                if (pj >= (sj + tj) * 0.5) {
                    this.dcScratch.set(j, sj);
                    continue;
                }
                this.dcScratch.set(j, tj);
            }
            double dist = this.dm.dist(p, this.dcScratch);
            minDist = Math.min(dist, minDist);
        }
        return minDist;
    }

    private double maxDist(Vec p, Rectangle r) {
        if (r.contains(p)) {
            return 0.0;
        }
        for (int i = 0; i < this.dim; ++i) {
            double pi = p.get(i);
            double si = r.lB.get(i);
            double ti = r.uB.get(i);
            if (pi < si) {
                this.dcScratch.set(i, ti);
                continue;
            }
            if (pi > ti) {
                this.dcScratch.set(i, si);
                continue;
            }
            this.dcScratch.set(i, pi);
        }
        return this.dm.dist(p, this.dcScratch);
    }

    private static class Rectangle
    implements Cloneable {
        private Vec uB;
        private Vec lB;

        public Rectangle(Vec upperBound, Vec lowerBound) {
            this.uB = upperBound;
            this.lB = lowerBound;
        }

        public Rectangle(int dimensions, double distance, Vec center) {
            this.uB = new DenseVector(dimensions);
            this.lB = new DenseVector(dimensions);
            for (int i = 0; i < dimensions; ++i) {
                this.uB.set(i, center.get(i) + distance);
                this.lB.set(i, center.get(i) - distance);
            }
        }

        public Rectangle(int dimensions) {
            this.uB = new DenseVector(dimensions);
            this.lB = new DenseVector(dimensions);
        }

        public Rectangle(Vec point) {
            this.uB = point.clone();
            this.lB = point.clone();
        }

        public Rectangle(Vec ... points) {
            this(Arrays.asList(points));
        }

        public Rectangle(List<Vec> points) {
            this.uB = new DenseVector(points.get(0).length());
            this.lB = new DenseVector(this.uB.length());
            for (int i = 0; i < this.uB.length(); ++i) {
                double max = Double.MIN_VALUE;
                double min = Double.MAX_VALUE;
                for (int j = 0; j < points.size(); ++j) {
                    max = Math.max(max, points.get(j).get(i));
                    min = Math.min(min, points.get(j).get(i));
                }
                this.uB.set(i, max);
                this.lB.set(i, min);
            }
        }

        public Rectangle(Rectangle ... recs) {
            this.uB = new DenseVector(recs[0].uB.length());
            this.lB = new DenseVector(this.uB.length());
            for (int i = 0; i < this.uB.length(); ++i) {
                double max = Double.MIN_VALUE;
                double min = Double.MAX_VALUE;
                for (int j = 0; j < recs.length; ++j) {
                    max = Math.max(max, recs[j].uB.get(i));
                    min = Math.min(min, recs[j].lB.get(i));
                }
                this.uB.set(i, max);
                this.lB.set(i, min);
            }
        }

        double increasedArea(Vec v) {
            double newArea = 1.0;
            double curArea = 1.0;
            for (int i = 0; i < this.uB.length(); ++i) {
                double curAreaTerm = this.uB.get(i) - this.lB.get(i);
                double vi = v.get(i);
                newArea = vi < this.lB.get(i) ? (newArea *= this.uB.get(i) - vi) : (vi > this.uB.get(i) ? (newArea *= vi - this.lB.get(i)) : (newArea *= curAreaTerm));
                curArea *= curAreaTerm;
            }
            return newArea - curArea;
        }

        double increasedArea(Rectangle r) {
            double newArea = 1.0;
            double curArea = 1.0;
            for (int i = 0; i < this.uB.length(); ++i) {
                double curAreaTerm = this.uB.get(i) - this.lB.get(i);
                curArea *= curAreaTerm;
                double newUBi = Math.max(this.uB.get(i), r.uB.get(i));
                double newLBi = Math.min(this.lB.get(i), r.lB.get(i));
                newArea *= newUBi - newLBi;
            }
            return newArea - curArea;
        }

        double area() {
            double area = 1.0;
            for (int i = 0; i < this.uB.length(); ++i) {
                area *= this.uB.get(i) - this.lB.get(i);
            }
            return area;
        }

        boolean intersects(Rectangle rect) {
            for (int i = 0; i < this.uB.length(); ++i) {
                if (!(this.uB.get(i) < rect.lB.get(i)) && !(this.lB.get(i) > rect.uB.get(i))) continue;
                return false;
            }
            return true;
        }

        boolean contains(Vec point) {
            for (int i = 0; i < this.uB.length(); ++i) {
                if (!(this.uB.get(i) < point.get(i)) && !(this.lB.get(i) > point.get(i))) continue;
                return false;
            }
            return true;
        }

        void adjustToContain(Vec point) {
            for (int i = 0; i < this.uB.length(); ++i) {
                double vi = point.get(i);
                if (vi > this.uB.get(i)) {
                    this.uB.set(i, vi);
                    continue;
                }
                if (!(vi < this.lB.get(i))) continue;
                this.lB.set(i, vi);
            }
        }

        void adjustToContain(Rectangle r) {
            this.adjustToContain(r.uB);
            this.adjustToContain(r.lB);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.lB.get(0)).append(":").append(this.uB.get(0));
            for (int i = 1; i < this.uB.length(); ++i) {
                sb.append(",").append(this.lB.get(i)).append(":").append(this.uB.get(i));
            }
            sb.append("]");
            return sb.toString();
        }

        protected Rectangle clone() {
            return new Rectangle(this.uB.clone(), this.lB.clone());
        }

        static <V extends Vec> Rectangle contains(List<V> points) {
            DenseVector uB = new DenseVector(((Vec)points.get(0)).length());
            DenseVector lB = new DenseVector(uB.length());
            for (int i = 0; i < uB.length(); ++i) {
                double max = Double.MIN_VALUE;
                double min = Double.MAX_VALUE;
                for (int j = 0; j < points.size(); ++j) {
                    max = Math.max(max, ((Vec)points.get(j)).get(i));
                    min = Math.min(min, ((Vec)points.get(j)).get(i));
                }
                uB.set(i, max);
                lB.set(i, min);
            }
            return new Rectangle((Vec)uB, (Vec)lB);
        }
    }

    private class RNode<V extends Vec>
    implements Comparable<RNode<V>>,
    Cloneable {
        List<RNode<V>> children;
        RNode<V> parent;
        IntList points;
        Rectangle bound;

        public RNode(List<Integer> points) {
            this.points = new IntList(points);
            this.children = new ArrayList<RNode<V>>();
            this.bound = Rectangle.contains(points.stream().map(i -> RTree.this.get((int)i)).collect(Collectors.toList()));
        }

        public RNode(RNode<V> toCopy) {
            this();
            for (RNode<V> child : toCopy.children) {
                RNode cloneChild = rTree.cloneChangeContext(child);
                cloneChild.parent = this;
                this.children.add(cloneChild);
            }
            if (toCopy.points != null) {
                Iterator<RNode<Object>> iterator = toCopy.points.iterator();
                while (iterator.hasNext()) {
                    int v = (Integer)((Object)iterator.next());
                    this.points.add(v);
                }
            }
            if (toCopy.bound != null) {
                this.bound = toCopy.bound.clone();
            }
        }

        public RNode() {
            this.points = new IntList();
            this.children = new ArrayList<RNode<V>>();
            this.bound = null;
        }

        RNode<V> getChild(int n) {
            return this.children.get(n);
        }

        Rectangle nthBound(int n) {
            if (this.isLeaf()) {
                return new Rectangle((Vec)RTree.this.get(this.points.get(n)));
            }
            return this.children.get((int)n).bound;
        }

        boolean isFull() {
            return this.points.size() >= RTree.this.M;
        }

        boolean add(int indx) {
            this.points.add(indx);
            if (this.bound == null) {
                this.bound = new Rectangle((Vec)RTree.this.get(indx));
            } else {
                this.bound.adjustToContain((Vec)RTree.this.get(indx));
            }
            return this.size() > RTree.this.M;
        }

        boolean add(RNode<V> node) {
            node.parent = this;
            this.children.add(node);
            if (this.bound == null) {
                this.bound = new Rectangle(node.bound);
            } else {
                this.bound.adjustToContain(node.bound);
            }
            return this.size() > RTree.this.M;
        }

        boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public int compareTo(RNode<V> o) {
            return Double.compare(this.bound.area(), o.bound.area());
        }

        private int size() {
            if (this.isLeaf()) {
                return this.points.size();
            }
            return this.children.size();
        }

        protected RNode<V> clone() {
            return new RNode<V>(this);
        }
    }
}

