/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.IncrementalCollection;
import jsat.linear.vectorcollection.IndexDistPair;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.IndexTable;

public class VectorArray<V extends Vec>
extends ArrayList<V>
implements IncrementalCollection<V> {
    private static final long serialVersionUID = 5365949686370986234L;
    private DistanceMetric distanceMetric;
    private List<Double> distCache;

    public VectorArray() {
        this((DistanceMetric)new EuclideanDistance(), 20);
    }

    public VectorArray(DistanceMetric distanceMetric, int initialCapacity) {
        super(initialCapacity);
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = new DoubleList(initialCapacity);
        }
    }

    public VectorArray(DistanceMetric distanceMetric, Collection<? extends V> c) {
        super(c);
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = distanceMetric.getAccelerationCache(this);
        }
    }

    public VectorArray(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
        if (distanceMetric.supportsAcceleration()) {
            this.distCache = new DoubleList();
        }
    }

    @Override
    public DistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    @Override
    public void setDistanceMetric(DistanceMetric distanceMetric) {
        if (this.distanceMetric == distanceMetric) {
            return;
        }
        this.distanceMetric = distanceMetric;
        this.distCache = distanceMetric.supportsAcceleration() ? distanceMetric.getAccelerationCache(this) : null;
    }

    @Override
    public void insert(V x) {
        this.add(x);
    }

    @Override
    public boolean add(V e) {
        boolean toRet = super.add(e);
        if (this.distCache != null) {
            this.distCache.addAll(this.distanceMetric.getQueryInfo((Vec)e));
        }
        return toRet;
    }

    @Override
    public List<Double> getAccelerationCache() {
        return this.distCache;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean toRet = super.addAll(c);
        if (this.distCache != null) {
            for (Vec v : c) {
                this.distCache.addAll(this.distanceMetric.getQueryInfo(v));
            }
        }
        return toRet;
    }

    @Override
    public V remove(int index) {
        this.distCache = null;
        return (V)((Vec)super.remove(index));
    }

    @Override
    public void clear() {
        super.clear();
        this.distCache = this.distanceMetric.getAccelerationCache(this);
    }

    @Override
    public void search(Vec query, double range, List<Integer> neighbors, List<Double> distances) {
        neighbors.clear();
        distances.clear();
        List<Double> qi = this.distanceMetric.getQueryInfo(query);
        for (int i = 0; i < this.size(); ++i) {
            double dist = this.distanceMetric.dist(i, query, qi, this, this.distCache);
            if (!(dist <= range)) continue;
            neighbors.add(i);
            distances.add(dist);
        }
        IndexTable it = new IndexTable(distances);
        it.apply(neighbors);
        it.apply(distances);
    }

    @Override
    public void search(Vec query, int numNeighbors, List<Integer> neighbors, List<Double> distances) {
        int i;
        neighbors.clear();
        distances.clear();
        BoundedSortedList<IndexDistPair> knns = new BoundedSortedList<IndexDistPair>(numNeighbors);
        List<Double> qi = this.distanceMetric.getQueryInfo(query);
        for (i = 0; i < this.size(); ++i) {
            double distance = this.distanceMetric.dist(i, query, qi, this, this.distCache);
            knns.add(new IndexDistPair(i, distance));
        }
        for (i = 0; i < knns.size(); ++i) {
            neighbors.add(((IndexDistPair)knns.get(i)).getIndex());
            distances.add(((IndexDistPair)knns.get(i)).getDist());
        }
    }

    @Override
    public VectorArray<V> clone() {
        VectorArray<V> clone = new VectorArray<V>(this.distanceMetric, this);
        return clone;
    }

    @Override
    public void build(boolean parallel, List<V> collection, DistanceMetric dm) {
        this.clear();
        this.setDistanceMetric(dm);
        this.addAll((Collection<? extends V>)collection);
    }
}

