/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.math.Function1D;
import jsat.math.rootfinding.RootFinder;

public class Bisection
implements RootFinder {
    private static final long serialVersionUID = -8107160048637997385L;

    public static double root(double a, double b, Function1D f) {
        return Bisection.root(1.0E-15, a, b, f);
    }

    public static double root(double eps, double a, double b, Function1D f) {
        return Bisection.root(eps, 1000, a, b, f);
    }

    public static double root(double eps, int maxIterations, double a, double b, Function1D f) {
        if (b <= a) {
            throw new ArithmeticException("a musbt be < b for Bisection to work");
        }
        double fb = f.f(b);
        double fa = f.f(a);
        if (fa * fb >= 0.0) {
            throw new ArithmeticException("The given interval does not appear to bracket the root");
        }
        while (b - a > 2.0 * eps && maxIterations-- > 0) {
            double midPoint = (a + b) * 0.5;
            double ftmp = f.f(midPoint);
            if (fa * ftmp < 0.0) {
                b = midPoint;
                fb = ftmp;
                continue;
            }
            if (!(fb * ftmp < 0.0)) break;
            a = midPoint;
            fa = ftmp;
        }
        return (a + b) * 0.5;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function1D f) {
        return Bisection.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], f);
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

