/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.regression.evaluation.TotalHistoryRegressionScore;

public class RelativeSquaredError
extends TotalHistoryRegressionScore {
    private static final long serialVersionUID = 8377798320269626429L;

    public RelativeSquaredError() {
    }

    public RelativeSquaredError(RelativeSquaredError toCopy) {
        super(toCopy);
    }

    @Override
    public double getScore() {
        double trueMean = this.truths.getVecView().mean();
        double numer = 0.0;
        double denom = 0.0;
        for (int i = 0; i < this.truths.size(); ++i) {
            numer += Math.pow(this.predictions.getD(i) - this.truths.getD(i), 2.0);
            denom += Math.pow(trueMean - this.truths.getD(i), 2.0);
        }
        return numer / denom;
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public RelativeSquaredError clone() {
        return new RelativeSquaredError(this);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public String getName() {
        return "Relative Squared Error";
    }
}

