/*
 * Decompiled with CFR 0.152.
 */
package jsat.text.tokenizer;

import java.util.List;
import jsat.text.stemming.Stemmer;
import jsat.text.tokenizer.Tokenizer;

public class StemmingTokenizer
implements Tokenizer {
    private static final long serialVersionUID = 2883247633791522390L;
    private Stemmer stemmer;
    private Tokenizer baseTokenizer;

    public StemmingTokenizer(Stemmer stemmer, Tokenizer baseTokenizer) {
        this.stemmer = stemmer;
        this.baseTokenizer = baseTokenizer;
    }

    @Override
    public List<String> tokenize(String input) {
        List<String> tokens = this.baseTokenizer.tokenize(input);
        this.stemmer.applyTo(tokens);
        return tokens;
    }

    @Override
    public void tokenize(String input, StringBuilder workSpace, List<String> storageSpace) {
        this.baseTokenizer.tokenize(input, workSpace, storageSpace);
        this.stemmer.applyTo(storageSpace);
    }
}

