/*
 * Decompiled with CFR 0.152.
 */
package mgo.tools.neuralnetwork;

import java.io.Serializable;
import mgo.tools.network.DirectedEdges;
import mgo.tools.neuralnetwork.Feedforward;
import mgo.tools.neuralnetwork.HeterogeneousActivationFunction;
import mgo.tools.neuralnetwork.HomogeneousActivationFunction;
import mgo.tools.neuralnetwork.NeuralNetwork$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public interface NeuralNetwork<N, S, W> {
    public static <N, S, W> Feedforward<S, W> feedforwardDense(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Vector<Vector<W>> vector, Function1<Iterable<Tuple2<S, W>>, S> function1, IndexedSeq<S> indexedSeq4) {
        return NeuralNetwork$.MODULE$.feedforwardDense(indexedSeq, indexedSeq2, indexedSeq3, vector, function1, indexedSeq4);
    }

    public static <N, S, W> Feedforward<S, W> feedforwardSparse(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Seq<Tuple3<Object, Object, W>> seq, Function1<Iterable<Tuple2<S, W>>, S> function1, IndexedSeq<S> indexedSeq4) {
        return NeuralNetwork$.MODULE$.feedforwardSparse(indexedSeq, indexedSeq2, indexedSeq3, seq, function1, indexedSeq4);
    }

    public static <N, S, W> Feedforward<S, W> feedforwardSparse(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Seq<Tuple3<Object, Object, W>> seq, IndexedSeq<Function1<Iterable<Tuple2<S, W>>, S>> indexedSeq4, IndexedSeq<S> indexedSeq5) {
        return NeuralNetwork$.MODULE$.feedforwardSparse(indexedSeq, indexedSeq2, indexedSeq3, seq, indexedSeq4, indexedSeq5);
    }

    public static <N, S, W> HomogeneousActivationFunction<S, W> recurrentDense(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Vector<Vector<W>> vector, Function1<Iterable<Tuple2<S, W>>, S> function1, Function2<S, S, Object> function2, IndexedSeq<S> indexedSeq4) {
        return NeuralNetwork$.MODULE$.recurrentDense(indexedSeq, indexedSeq2, indexedSeq3, vector, function1, function2, indexedSeq4);
    }

    public static <N, S, W> HomogeneousActivationFunction<S, W> recurrentSparse(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Seq<Tuple3<Object, Object, W>> seq, Function1<Iterable<Tuple2<S, W>>, S> function1, Function2<S, S, Object> function2, IndexedSeq<S> indexedSeq4) {
        return NeuralNetwork$.MODULE$.recurrentSparse(indexedSeq, indexedSeq2, indexedSeq3, seq, function1, function2, indexedSeq4);
    }

    public static <N, S, W> HeterogeneousActivationFunction<S, W> recurrentSparse(IndexedSeq<N> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, Seq<Tuple3<Object, Object, W>> seq, IndexedSeq<Function1<Iterable<Tuple2<S, W>>, S>> indexedSeq4, Function2<S, S, Object> function2, IndexedSeq<S> indexedSeq5) {
        return NeuralNetwork$.MODULE$.recurrentSparse(indexedSeq, indexedSeq2, indexedSeq3, seq, indexedSeq4, function2, indexedSeq5);
    }

    public DirectedEdges<W> network();

    public Vector<Object> inputNeurons();

    public Vector<Object> outputNeurons();

    public static Vector inputsAndWeights$(NeuralNetwork $this, int neuron, IndexedSeq state) {
        return $this.inputsAndWeights(neuron, state);
    }

    default public Vector<Tuple2<S, W>> inputsAndWeights(int neuron, IndexedSeq<S> state) {
        return (Vector)this.network().in(neuron).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int innode = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Object weight = tuple2._2();
                return Tuple2$.MODULE$.apply(state.apply(innode), weight);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static Vector updateState$(NeuralNetwork $this, Iterable state, Iterable neuronsValues) {
        return $this.updateState(state, neuronsValues);
    }

    default public Vector<S> updateState(Iterable<S> state, Iterable<Tuple2<Object, S>> neuronsValues) {
        Buffer mutableState = state.toBuffer();
        neuronsValues.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Object v = tuple2._2();
                mutableState.update(i, v);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return mutableState.toVector();
    }

    public static Vector outNeighbours$(NeuralNetwork $this, int neuron) {
        return $this.outNeighbours(neuron);
    }

    default public Vector<Object> outNeighbours(int neuron) {
        return this.network().outneighbours(neuron);
    }

    public static Vector outputState$(NeuralNetwork $this, IndexedSeq state) {
        return $this.outputState(state);
    }

    default public Vector<S> outputState(IndexedSeq<S> state) {
        return (Vector)this.outputNeurons().map((Function1 & Serializable)_$1 -> state.apply(BoxesRunTime.unboxToInt((Object)_$1)));
    }

    public IndexedSeq<S> state();
}

