/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc;

import dotty.tools.FatalError;
import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.Run;
import dotty.tools.dotc.Run$;
import dotty.tools.dotc.ScalacCommand$;
import dotty.tools.dotc.ast.Positioned$;
import dotty.tools.dotc.config.CompilerCommand;
import dotty.tools.dotc.config.ScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Comments;
import dotty.tools.dotc.core.Comments$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.MacroClassLoader$;
import dotty.tools.dotc.core.TypeError;
import dotty.tools.dotc.fromtasty.TASTYCompiler;
import dotty.tools.dotc.fromtasty.TastyFileUtil$;
import dotty.tools.dotc.interfaces.CompilerCallback;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.Reporter$;
import dotty.tools.dotc.reporting.StoreReporter;
import dotty.tools.dotc.reporting.StoreReporter$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.FileExtension;
import dotty.tools.io.FileExtension$;
import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public class Driver {
    public Compiler newCompiler(Contexts.Context x$1) {
        if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().fromTasty(), x$1))) {
            return new TASTYCompiler();
        }
        return new Compiler();
    }

    public Reporter emptyReporter() {
        return new StoreReporter(null, StoreReporter$.MODULE$.$lessinit$greater$default$2());
    }

    public Reporter doCompile(Compiler compiler, List<AbstractFile> files, Contexts.Context x$3) {
        if (files.nonEmpty()) {
            Run runOrNull = x$3.run();
            try {
                Run run;
                runOrNull = run = compiler.newRun(x$3);
                run.compile(files);
                this.finish(compiler, run, x$3);
            }
            catch (FatalError ex) {
                report$.MODULE$.error(() -> Driver.doCompile$$anonfun$1(ex), x$3);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 != null) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = throwable2;
                    if (x$3.usedBestEffortTasty()) {
                        report$.MODULE$.bestEffortError(ex, "Some best-effort tasty files were not able to be read.", x$3);
                        throw ex;
                    }
                }
                if (throwable2 instanceof TypeError) {
                    TypeError typeError;
                    TypeError ex = typeError = (TypeError)throwable2;
                    if (!Run$.MODULE$.enrichedErrorMessage(runOrNull)) {
                        Predef$.MODULE$.println(Run$.MODULE$.enrichErrorMessage(runOrNull, new StringBuilder(17).append(ex.toMessage(x$3)).append(" while compiling ").append(((AbstractIterable)files.map((Function1<AbstractFile, String> & Serializable)_$1 -> _$1.path())).mkString(", ")).toString(), x$3));
                        throw ex;
                    }
                }
                if (throwable2 != null) {
                    Throwable throwable4;
                    Throwable ex = throwable4 = throwable2;
                    if (!Run$.MODULE$.enrichedErrorMessage(runOrNull)) {
                        Predef$.MODULE$.println(Run$.MODULE$.enrichErrorMessage(runOrNull, new StringBuilder(26).append("Exception while compiling ").append(((AbstractIterable)files.map((Function1<AbstractFile, String> & Serializable)_$2 -> _$2.path())).mkString(", ")).toString(), x$3));
                        throw ex;
                    }
                }
                throw throwable;
            }
        }
        return x$3.reporter();
    }

    public void finish(Compiler compiler, Run run, Contexts.Context x$3) {
        run.printSummary();
        if (!x$3.reporter().errorsReported() && run.suspendedUnits().nonEmpty()) {
            List<CompilationUnit> suspendedUnits = run.suspendedUnits().toList();
            if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$3.settings().XprintSuspension(), x$3))) {
                List suspendedHints = run.suspendedHints().toList();
                report$.MODULE$.echo(() -> Driver.finish$$anonfun$1(suspendedUnits, x$3), report$.MODULE$.echo$default$2(), x$3);
                suspendedHints.withFilter((Function1<Tuple2, Boolean> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    CompilationUnit unit = (CompilationUnit)tuple2._1();
                    String hint = (String)tuple22._1();
                    boolean atInlining = BoxesRunTime.unboxToBoolean(tuple22._2());
                    return true;
                }).foreach(x$1 -> {
                    Tuple2 tuple2 = x$1;
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    CompilationUnit unit = (CompilationUnit)tuple2._1();
                    String hint = (String)tuple22._1();
                    boolean atInlining = BoxesRunTime.unboxToBoolean(tuple22._2());
                    report$.MODULE$.echo(() -> Driver.finish$$anonfun$3$$anonfun$1(unit, atInlining, hint), report$.MODULE$.echo$default$2(), x$3);
                });
            }
            Run run1 = compiler.newRun(x$3);
            run1.compileSuspendedUnits(suspendedUnits, !run.suspendedAtTyperPhase());
            this.finish(compiler, run1, MacroClassLoader$.MODULE$.init(x$3.fresh()));
            return;
        }
    }

    public Contexts.Context initCtx() {
        return new Contexts.ContextBase().initialCtx();
    }

    public boolean sourcesRequired() {
        return true;
    }

    public CompilerCommand command() {
        return ScalacCommand$.MODULE$;
    }

    public Option<Tuple2<List<AbstractFile>, Contexts.Context>> setup(String[] args, Contexts.Context rootCtx) {
        Contexts.FreshContext ictx = rootCtx.fresh();
        Settings.ArgsSummary summary = this.command().distill(args, ictx.settings(), ictx.settingsState(), ictx);
        ictx.setSettings(summary.sstate());
        MacroClassLoader$.MODULE$.init(ictx);
        Positioned$.MODULE$.init(ictx);
        if (!BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(ictx.settings().XdropComments(), ictx)) || BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(ictx.settings().XreadComments(), ictx))) {
            ictx.setProperty(Comments$.MODULE$.ContextDoc(), new Comments.ContextDocstrings());
        }
        CompilerCommand compilerCommand = this.command();
        boolean bl = this.sourcesRequired();
        ScalaSettings scalaSettings = ictx.settings();
        Option fileNamesOrNone = compilerCommand.checkUsage(summary, bl, scalaSettings, ictx.settingsState(), ictx);
        return fileNamesOrNone.map((Function1<List, Tuple2> & Serializable)fileNames -> {
            Contexts.FreshContext freshContext = ictx;
            Object files = fileNames.map((Function1<String, AbstractFile> & Serializable)name -> freshContext.getFile((String)name));
            return Tuple2$.MODULE$.apply(files, this.fromTastySetup((List<AbstractFile>)files, ictx));
        });
    }

    public Contexts.Context fromTastySetup(List<AbstractFile> files, Contexts.Context x$2) {
        if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$2.settings().fromTasty(), x$2))) {
            List newEntries = (List)((AbstractSeq)files.flatMap((Function1<AbstractFile, IterableOnce> & Serializable)file -> {
                block10: {
                    block7: {
                        FileExtension fileExtension;
                        FileExtension fileExtension2;
                        block9: {
                            FileExtension fileExtension3;
                            block8: {
                                FileExtension fileExtension4;
                                FileExtension fileExtension5;
                                block6: {
                                    if (!file.exists()) {
                                        report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"File does not exist: ", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(file.path())}), x$2), report$.MODULE$.error$default$2(), x$2);
                                        return None$.MODULE$;
                                    }
                                    fileExtension3 = file.ext();
                                    FileExtension fileExtension6 = FileExtension$.Jar;
                                    FileExtension fileExtension7 = fileExtension3;
                                    if (!(fileExtension6 != null ? !fileExtension6.equals(fileExtension7) : fileExtension7 != null)) {
                                        return Some$.MODULE$.apply(file.path());
                                    }
                                    fileExtension5 = FileExtension$.Tasty;
                                    fileExtension4 = fileExtension3;
                                    if (fileExtension5 != null) break block6;
                                    if (fileExtension4 == null) break block7;
                                    break block8;
                                }
                                if (fileExtension5.equals(fileExtension4)) break block7;
                            }
                            fileExtension2 = FileExtension$.Betasty;
                            fileExtension = fileExtension3;
                            if (fileExtension2 != null) break block9;
                            if (fileExtension == null) break block7;
                            break block10;
                        }
                        if (!fileExtension2.equals(fileExtension)) break block10;
                    }
                    Option<String> option = TastyFileUtil$.MODULE$.getClassPath((AbstractFile)file, x$2.withBestEffortTasty());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String classpath = (String)some.value();
                        return Some$.MODULE$.apply(classpath);
                    }
                    report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Could not load classname from: ", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(file.path())}), x$2), report$.MODULE$.error$default$2(), x$2);
                    return None$.MODULE$;
                }
                report$.MODULE$.error(Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"File extension is not `tasty` or `jar`: ", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(file.path())}), x$2), report$.MODULE$.error$default$2(), x$2);
                return None$.MODULE$;
            })).distinct();
            Contexts.FreshContext ctx1 = x$2.fresh();
            String fullClassPath = ((IterableOnceOps)newEntries.$colon$plus(Settings$Setting$.MODULE$.value(x$2.settings().classpath(), x$2))).mkString(File.pathSeparator);
            return ctx1.setSetting(ctx1.settings().classpath(), fullClassPath);
        }
        return x$2;
    }

    public final ReporterResult process(String[] args, SimpleReporter simple, CompilerCallback callback) {
        Reporter reporter = simple == null ? null : Reporter$.MODULE$.fromSimpleReporter(simple);
        return this.process(args, reporter, callback);
    }

    public final Reporter process(String[] args, Reporter reporter, CompilerCallback callback) {
        Contexts.FreshContext compileCtx = this.initCtx().fresh();
        if (reporter != null) {
            compileCtx.setReporter(reporter);
        }
        if (callback != null) {
            compileCtx.setCompilerCallback(callback);
        }
        return this.process(args, compileCtx);
    }

    public Reporter process$default$2() {
        return null;
    }

    public CompilerCallback process$default$3() {
        return null;
    }

    public Reporter process(String[] args) {
        return this.process(args, (Reporter)null, (CompilerCallback)null);
    }

    public Reporter process(String[] args, Contexts.Context rootCtx) {
        Option<Tuple2<List<AbstractFile>, Contexts.Context>> option = this.setup(args, rootCtx);
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 tuple2 = (Tuple2)some.value();
            List files = (List)tuple2._1();
            Contexts.Context compileCtx = (Contexts.Context)tuple2._2();
            return this.doCompile(this.newCompiler(compileCtx), files, compileCtx);
        }
        if (None$.MODULE$.equals(option)) {
            return rootCtx.reporter();
        }
        throw new MatchError(option);
    }

    public void main(String[] args) {
        NonFatal$ nonFatal$ = NonFatal$.MODULE$;
        throw package$.MODULE$.exit(this.process(args).hasErrors() ? 1 : 0);
    }

    private static final String doCompile$$anonfun$1(FatalError ex$1) {
        return ex$1.getMessage();
    }

    private static final String finish$$anonfun$1(List suspendedUnits$1, Contexts.Context x$3$1) {
        return Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"compiling suspended ", "%, %"})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Seq(Formatting$ShownDef$Show$.MODULE$.given_Show_CompilationUnit())).apply((CompilationUnit)((Object)suspendedUnits$1))}), x$3$1);
    }

    private static final String finish$$anonfun$3$$anonfun$1(CompilationUnit unit$1, boolean atInlining$1, String hint$1) {
        return new StringBuilder(8).append("  ").append(unit$1).append(" at ").append(atInlining$1 ? "inlining" : "typer").append(": ").append(hint$1).toString();
    }
}

