/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.EfficientClassPath;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;

public interface DirectoryLookup<FileEntryType extends ClassRepresentation>
extends EfficientClassPath {
    public Object dir();

    public Object emptyFiles();

    public Option<Object> getSubDir(String var1);

    public Object listChildren(Object var1, Option<Function1<Object, Object>> var2);

    public static Option listChildren$default$2$(DirectoryLookup $this) {
        return $this.listChildren$default$2();
    }

    default public Option<Function1<Object, Object>> listChildren$default$2() {
        return None$.MODULE$;
    }

    public String getName(Object var1);

    public AbstractFile toAbstractFile(Object var1);

    public boolean isPackage(Object var1);

    public FileEntryType createFileEntry(AbstractFile var1);

    public boolean isMatchingFile(Object var1);

    private Option<Object> getDirectory(PackageName forPackage) {
        if (forPackage.isRoot()) {
            return Some$.MODULE$.apply(this.dir());
        }
        return this.getSubDir(forPackage.dirPathTrailingSlash());
    }

    public static boolean hasPackage$(DirectoryLookup $this, PackageName pkg) {
        return $this.hasPackage(pkg);
    }

    @Override
    default public boolean hasPackage(PackageName pkg) {
        return this.getDirectory(pkg).isDefined();
    }

    public static Seq packages$(DirectoryLookup $this, PackageName inPackage) {
        return $this.packages(inPackage);
    }

    @Override
    default public Seq<PackageEntry> packages(PackageName inPackage) {
        Object object;
        Option<Object> dirForPackage = this.getDirectory(inPackage);
        Option<Object> option = dirForPackage;
        if (None$.MODULE$.equals(option)) {
            object = this.emptyFiles();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Object directory = some.value();
            object = this.listChildren(directory, Some$.MODULE$.apply((Function1<Object, Boolean> & Serializable)f -> this.isPackage(f)));
        } else {
            throw new MatchError(option);
        }
        Object nestedDirs = object;
        return ArraySeq$.MODULE$.unsafeWrapArray(nestedDirs).map((Function1<Object, PackageEntryImpl> & Serializable)f -> PackageEntryImpl$.MODULE$.apply(inPackage.entryName(this.getName(f))));
    }

    public static Seq files$(DirectoryLookup $this, PackageName inPackage) {
        return $this.files(inPackage);
    }

    default public Seq<FileEntryType> files(PackageName inPackage) {
        Object object;
        Option<Object> dirForPackage = this.getDirectory(inPackage);
        Option<Object> option = dirForPackage;
        if (None$.MODULE$.equals(option)) {
            object = this.emptyFiles();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Object directory = some.value();
            object = this.listChildren(directory, Some$.MODULE$.apply((Function1<Object, Boolean> & Serializable)f -> this.isMatchingFile(f)));
        } else {
            throw new MatchError(option);
        }
        Object files = object;
        Object object2 = Predef$.MODULE$.genericArrayOps(files);
        return ArrayOps$.MODULE$.iterator$extension(object2).map((Function1<Object, ClassRepresentation> & Serializable)f -> this.createFileEntry(this.toAbstractFile(f))).toSeq();
    }

    public static void list$(DirectoryLookup $this, PackageName inPackage, Function1 onPackageEntry, Function1 onClassesAndSources) {
        $this.list(inPackage, onPackageEntry, onClassesAndSources);
    }

    @Override
    default public void list(PackageName inPackage, Function1<PackageEntry, BoxedUnit> onPackageEntry, Function1<ClassRepresentation, BoxedUnit> onClassesAndSources) {
        Option<Object> dirForPackage = this.getDirectory(inPackage);
        Option<Object> option = dirForPackage;
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object directory = some.value();
            Object object = Predef$.MODULE$.genericArrayOps(this.listChildren(directory, this.listChildren$default$2()));
            ArrayOps$.MODULE$.foreach$extension(object, file -> {
                if (this.isPackage(file)) {
                    onPackageEntry.apply(PackageEntryImpl$.MODULE$.apply(inPackage.entryName(this.getName(file))));
                    return;
                }
                if (this.isMatchingFile(file)) {
                    onClassesAndSources.apply((ClassRepresentation)this.createFileEntry(this.toAbstractFile(file)));
                    return;
                }
            });
            return;
        }
        throw new MatchError(option);
    }
}

