/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.tasty.NameBuffer;
import dotty.tools.dotc.core.tasty.TastyPickler$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import dotty.tools.tasty.TastyFormat$;
import dotty.tools.tasty.TastyHash$;
import dotty.tools.tasty.besteffort.BestEffortTastyFormat$;
import java.io.Serializable;
import scala.Byte$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class TastyPickler {
    private final Symbols.ClassSymbol rootCls;
    private final boolean isBestEffortTasty;
    private final ArrayBuffer<Tuple2<TastyBuffer.NameRef, TastyBuffer>> sections;
    private final NameBuffer nameBuffer;

    public TastyPickler(Symbols.ClassSymbol rootCls, boolean isBestEffortTasty) {
        this.rootCls = rootCls;
        this.isBestEffortTasty = isBestEffortTasty;
        this.sections = new ArrayBuffer();
        this.nameBuffer = new NameBuffer();
    }

    public Symbols.ClassSymbol rootCls() {
        return this.rootCls;
    }

    public NameBuffer nameBuffer() {
        return this.nameBuffer;
    }

    public void newSection(String name, TastyBuffer buf) {
        this.sections.$plus$eq(Tuple2$.MODULE$.apply(new TastyBuffer.NameRef(this.nameBuffer().nameIndex(Decorators$.MODULE$.toTermName(name))), buf));
    }

    public byte[] assembleParts() {
        this.nameBuffer().assemble();
        this.sections.foreach(_$1 -> ((TastyBuffer)_$1._2()).assemble());
        long nameBufferHash = TastyHash$.MODULE$.pjwHash64(this.nameBuffer().bytes(), this.nameBuffer().length());
        ArrayBuffer arrayBuffer = (ArrayBuffer)this.sections.map((Function1<Tuple2, Long> & Serializable)x -> TastyHash$.MODULE$.pjwHash64(((TastyBuffer)x._2()).bytes(), ((TastyBuffer)x._2()).length()));
        Option option = package$.MODULE$.$plus$colon().unapply(arrayBuffer);
        if (option.isEmpty()) {
            throw new MatchError(arrayBuffer);
        }
        Tuple2 tuple2 = option.get();
        long treeSectionHash = BoxesRunTime.unboxToLong(tuple2._1());
        ArrayBuffer otherSectionHashes = tuple2._2();
        Tuple2<Long, ArrayBuffer> tuple22 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToLong(treeSectionHash), otherSectionHashes);
        long treeSectionHash2 = BoxesRunTime.unboxToLong(tuple22._1());
        ArrayBuffer otherSectionHashes2 = tuple22._2();
        long uuidLow = nameBufferHash ^ treeSectionHash2;
        long uuidHi = BoxesRunTime.unboxToLong(otherSectionHashes2.fold(BoxesRunTime.boxToLong(0L), (_$2, _$3) -> _$2 ^ _$3));
        int[] fileHeader = this.isBestEffortTasty ? BestEffortTastyFormat$.MODULE$.bestEffortHeader() : TastyFormat$.MODULE$.header();
        TastyBuffer buf = new TastyBuffer(fileHeader.length + TastyPickler$.dotty$tools$dotc$core$tasty$TastyPickler$$$versionString.length() + 32);
        Object object = Predef$.MODULE$.intArrayOps(fileHeader);
        ArrayOps$.MODULE$.foreach$extension(object, ch -> buf.writeByte(Byte$.MODULE$.byte2int((byte)ch)));
        buf.writeNat(TastyFormat$.MODULE$.MajorVersion());
        buf.writeNat(TastyFormat$.MODULE$.MinorVersion());
        if (this.isBestEffortTasty) {
            buf.writeNat(BestEffortTastyFormat$.MODULE$.PatchVersion());
        }
        buf.writeNat(TastyFormat$.MODULE$.ExperimentalVersion());
        buf.writeUtf8(TastyPickler$.dotty$tools$dotc$core$tasty$TastyPickler$$$versionString);
        buf.writeUncompressedLong(uuidLow);
        buf.writeUncompressedLong(uuidHi);
        TastyBuffer headerBuffer = buf;
        int totalSize = headerBuffer.length() + TastyPickler.lengthWithLength$1(this.nameBuffer()) + BoxesRunTime.unboxToInt(((IterableOnceOps)this.sections.withFilter((Function1<Tuple2<TastyBuffer.NameRef, TastyBuffer>, Object>)(Function1<Tuple2, Boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            int nameRef = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.NameRef)tuple2._1()).index();
            TastyBuffer buf = (TastyBuffer)tuple2._2();
            return true;
        }).map((Function1<Tuple2, Integer> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            int nameRef = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.NameRef)tuple2._1()).index();
            TastyBuffer buf = (TastyBuffer)tuple2._2();
            return TastyBuffer$.MODULE$.natSize(nameRef) + TastyPickler.lengthWithLength$1(buf);
        })).sum(Numeric$IntIsIntegral$.MODULE$));
        TastyBuffer all = new TastyBuffer(totalSize);
        all.writeBytes(headerBuffer.bytes(), headerBuffer.length());
        all.writeNat(this.nameBuffer().length());
        all.writeBytes(this.nameBuffer().bytes(), this.nameBuffer().length());
        this.sections.withFilter((Function1<Tuple2<TastyBuffer.NameRef, TastyBuffer>, Object>)(Function1<Tuple2, Boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            int nameRef = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.NameRef)tuple2._1()).index();
            TastyBuffer buf = (TastyBuffer)tuple2._2();
            return true;
        }).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            int nameRef = tuple2._1() == null ? BoxesRunTime.unboxToInt(null) : ((TastyBuffer.NameRef)tuple2._1()).index();
            TastyBuffer buf = (TastyBuffer)tuple2._2();
            all.writeNat(nameRef);
            all.writeNat(buf.length());
            all.writeBytes(buf.bytes(), buf.length());
        });
        if (all.length() != totalSize || all.bytes().length != totalSize) {
            throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(48).append("totalSize = ").append(totalSize).append(", all.length = ").append(all.length()).append(", all.bytes.length = ").append(all.bytes().length).toString());
        }
        return all.bytes();
    }

    private static final int lengthWithLength$1(TastyBuffer buf) {
        return buf.length() + TastyBuffer$.MODULE$.natSize(buf.length());
    }
}

