/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.parsing.Scanners;
import dotty.tools.dotc.parsing.Scanners$Scanner$;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Profile;
import dotty.tools.dotc.reporting.Profile$;
import dotty.tools.dotc.reporting.Profile$MethodInfo$;
import dotty.tools.dotc.util.EqHashMap;
import dotty.tools.dotc.util.EqHashMap$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.io.AbstractFile;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering$DeprecatedFloatOrdering$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public class ActiveProfile
extends Profile {
    private final int details;
    private final EqHashMap<CompilationUnit, Profile.Info> pinfo;
    private final Profile.Info junkInfo;

    public ActiveProfile(int details) {
        this.details = details;
        this.pinfo = new EqHashMap(EqHashMap$.MODULE$.$lessinit$greater$default$1(), EqHashMap$.MODULE$.$lessinit$greater$default$2());
        this.junkInfo = new Profile.Info(0);
    }

    private Profile.Info curInfo(Contexts.Context x$1) {
        CompilationUnit unit = x$1.compilationUnit();
        if (unit == null || unit.source().file().isVirtual()) {
            return this.junkInfo;
        }
        return this.unitProfile(unit);
    }

    @Override
    public Profile.Info unitProfile(CompilationUnit unit) {
        return this.pinfo.getOrElseUpdate(unit, this::unitProfile$$anonfun$1);
    }

    @Override
    public void recordNewLine(Contexts.Context x$1) {
        Profile.Info info = this.curInfo(x$1);
        info.lineCount_$eq(info.lineCount() + 1);
    }

    @Override
    public void recordNewToken(Contexts.Context x$1) {
        Profile.Info info = this.curInfo(x$1);
        info.tokenCount_$eq(info.tokenCount() + 1);
    }

    @Override
    public void recordTasty(int size, Contexts.Context x$2) {
        Profile.Info info = this.curInfo(x$2);
        info.tastySize_$eq(info.tastySize() + size);
    }

    @Override
    public void recordMethodSize(Symbols.Symbol meth, int size, long span, Contexts.Context x$4) {
        this.curInfo(x$4).recordMethodSize(meth, size, span);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void printSummary(Contexts.Context x$1) {
        CompilationUnit[] compilationUnitArray;
        block8: {
            Object[] rawUnits = (CompilationUnit[])this.pinfo.keysIterator().toArray(ClassTag$.MODULE$.apply(CompilationUnit.class));
            String string2 = (String)Settings$Setting$.MODULE$.value(x$1.settings().VprofileSortedBy(), x$1);
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -868186726: {
                    if (!"tokens".equals(string2)) break;
                    Object object = Predef$.MODULE$.refArrayOps(rawUnits);
                    compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, Integer> & Serializable)_$4 -> this.unitProfile((CompilationUnit)_$4).tokenCount(), Ordering$Int$.MODULE$);
                    break block8;
                }
                case -541084162: {
                    if (!"complexity".equals(string2)) break;
                    Object object = Predef$.MODULE$.refArrayOps(rawUnits);
                    compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, Float> & Serializable)_$5 -> this.unitProfile((CompilationUnit)_$5).complexity(), Ordering$DeprecatedFloatOrdering$.MODULE$);
                    break block8;
                }
                case 3373707: {
                    if (!"name".equals(string2)) break;
                    Object object = Predef$.MODULE$.refArrayOps(rawUnits);
                    compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, String> & Serializable)_$1 -> _$1.source().file().name(), Ordering$String$.MODULE$);
                    break block8;
                }
                case 3433509: {
                    if (!"path".equals(string2)) break;
                    Object object = Predef$.MODULE$.refArrayOps(rawUnits);
                    compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, String> & Serializable)_$2 -> _$2.source().file().path(), Ordering$String$.MODULE$);
                    break block8;
                }
                case 102977279: {
                    if (!"lines".equals(string2)) break;
                    Object object = Predef$.MODULE$.refArrayOps(rawUnits);
                    compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, Integer> & Serializable)_$3 -> this.unitProfile((CompilationUnit)_$3).lineCount(), Ordering$Int$.MODULE$);
                    break block8;
                }
            }
            Object object = Predef$.MODULE$.refArrayOps(rawUnits);
            compilationUnitArray = (CompilationUnit[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1<CompilationUnit, Integer> & Serializable)_$6 -> this.unitProfile((CompilationUnit)_$6).tastySize(), Ordering$Int$.MODULE$);
        }
        CompilationUnit[] units = compilationUnitArray;
        Profile.Info agg = this.printAndAggregateSourceInfos$1(units, x$1);
        if (this.details > 0) {
            ActiveProfile.printDetails$1(x$1, units, agg);
            return;
        }
    }

    private final Profile.Info unitProfile$$anonfun$1() {
        return new Profile.Info(this.details);
    }

    private static final String printHeader$1$$anonfun$1(String layout$1, String prefix$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(layout$1), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{prefix$1, "Lines", "Tokens", "Tasty", " Complexity/Line", "Directory"}));
    }

    private static final String printHeader$1(Contexts.Context x$1$1, int sourceNameWidth, int methNameWidth) {
        String prefix = methNameWidth > 0 ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(7).append("%-").append(sourceNameWidth).append("s %-").append(methNameWidth).append("s").toString()), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"Sourcefile", "Method"})) : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(3).append("%-").append(sourceNameWidth).append("s").toString()), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{"Sourcefile"}));
        String layout = new StringBuilder(24).append("%-").append(prefix.length()).append("s %6s %8s %7s %s    %s").toString();
        report$.MODULE$.echo(() -> ActiveProfile.printHeader$1$$anonfun$1(layout, prefix), report$.MODULE$.echo$default$2(), x$1$1);
        return layout;
    }

    private static final int printHeader$default$2$1() {
        return 0;
    }

    private static final String printInfo$1$$anonfun$1(String layout$2, String name$1, Profile.Info info$1, float complexity$1, String explanation$1, String path$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(layout$2), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name$1, BoxesRunTime.boxToInteger(info$1.lineCount()), BoxesRunTime.boxToInteger(info$1.tokenCount()), BoxesRunTime.boxToInteger(Profile$.MODULE$.chunks(info$1.tastySize())), new StringBuilder(2).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%6.2f"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToFloat(complexity$1)}))).append("  ").append(explanation$1).toString(), path$1}));
    }

    private static final void printInfo$1(Contexts.Context x$1$2, String layout, String name, Profile.Info info, String path2) {
        float complexity = info.complexity();
        String explanation = complexity < 1.0f ? "low     " : (complexity < (float)5 ? "moderate" : (complexity < (float)25 ? "high    " : "extreme "));
        report$.MODULE$.echo(() -> ActiveProfile.printInfo$1$$anonfun$1(layout, name, info, complexity, explanation, path2), report$.MODULE$.echo$default$2(), x$1$2);
    }

    private static final int safeMax$1(int[] xs) {
        Object object = Predef$.MODULE$.intArrayOps(xs);
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            return 10;
        }
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(Predef$.MODULE$.wrapIntArray(xs).max(Ordering$Int$.MODULE$))), 10)), 50);
    }

    private static final String printAndAggregateSourceInfos$1$$anonfun$2(int sourceNameWidth$1) {
        return new StringBuilder(42).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), sourceNameWidth$1)).append("------------------------------------------").toString();
    }

    private final Profile.Info printAndAggregateSourceInfos$1(CompilationUnit[] units$1, Contexts.Context x$1$3) {
        Object object = Predef$.MODULE$.refArrayOps(units$1);
        int sourceNameWidth = ActiveProfile.safeMax$1((int[])ArrayOps$.MODULE$.map$extension(object, (Function1<CompilationUnit, Integer> & Serializable)_$7 -> _$7.source().file().name().length(), ClassTag$.MODULE$.apply(Integer.TYPE)));
        String layout = ActiveProfile.printHeader$1(x$1$3, sourceNameWidth, ActiveProfile.printHeader$default$2$1());
        Profile.Info agg = new Profile.Info(this.details);
        Object object2 = Predef$.MODULE$.refArrayOps(units$1);
        ArrayOps$.MODULE$.foreach$extension(object2, unit -> {
            AbstractFile file = unit.source().file();
            Profile.Info info = this.unitProfile((CompilationUnit)unit);
            ActiveProfile.printInfo$1(x$1$3, layout, file.name(), info, file.container().path());
            agg.lineCount_$eq(agg.lineCount() + info.lineCount());
            agg.tokenCount_$eq(agg.tokenCount() + info.tokenCount());
            agg.tastySize_$eq(agg.tastySize() + info.tastySize());
            Object object = Predef$.MODULE$.refArrayOps(info.leading());
            ArrayOps$.MODULE$.withFilter$extension(object, (Function1<Profile.MethodInfo, Boolean> & Serializable)x$1 -> {
                Profile.MethodInfo methodInfo = x$1;
                Profile.MethodInfo methodInfo2 = Profile$MethodInfo$.MODULE$.unapply(methodInfo);
                Symbols.Symbol symbol = methodInfo2._1();
                int n = methodInfo2._2();
                long l = methodInfo2._3();
                Symbols.Symbol meth = symbol;
                int size = n;
                long span = l;
                return true;
            }).foreach(x$1 -> {
                Profile.MethodInfo methodInfo = x$1;
                Profile.MethodInfo methodInfo2 = Profile$MethodInfo$.MODULE$.unapply(methodInfo);
                Symbols.Symbol symbol = methodInfo2._1();
                int n = methodInfo2._2();
                long l = methodInfo2._3();
                Symbols.Symbol meth = symbol;
                int size = n;
                long span = l;
                agg.recordMethodSize(meth, size, span);
            });
        });
        if (units$1.length > 1) {
            report$.MODULE$.echo(() -> ActiveProfile.printAndAggregateSourceInfos$1$$anonfun$2(sourceNameWidth), report$.MODULE$.echo$default$2(), x$1$3);
            ActiveProfile.printInfo$1(x$1$3, layout, "Total", agg, "");
        }
        return agg;
    }

    private static final String printDetails$1$$anonfun$1() {
        return "\nMost complex methods:";
    }

    private static final void printDetails$1(Contexts.Context x$1$5, CompilationUnit[] units$2, Profile.Info agg) {
        Object object = Predef$.MODULE$.refArrayOps(agg.leading());
        int sourceNameWidth = ActiveProfile.safeMax$1((int[])ArrayOps$.MODULE$.map$extension(object, (Function1<Profile.MethodInfo, Integer> & Serializable)_$8 -> _$8.meth().source(x$1$5).name().length(), ClassTag$.MODULE$.apply(Integer.TYPE)));
        Object object2 = Predef$.MODULE$.refArrayOps(agg.leading());
        int methNameWidth = ActiveProfile.safeMax$1((int[])ArrayOps$.MODULE$.map$extension(object2, (Function1<Profile.MethodInfo, Integer> & Serializable)_$9 -> _$9.meth().name(x$1$5).toString().length(), ClassTag$.MODULE$.apply(Integer.TYPE)));
        report$.MODULE$.echo(ActiveProfile::printDetails$1$$anonfun$1, report$.MODULE$.echo$default$2(), x$1$5);
        String layout = ActiveProfile.printHeader$1(x$1$5, sourceNameWidth, methNameWidth);
        Object object3 = Predef$.MODULE$.refArrayOps(agg.leading());
        Object object4 = Predef$.MODULE$.refArrayOps((Profile.MethodInfo[])ArrayOps$.MODULE$.reverse$extension(object3));
        ArrayOps$.MODULE$.withFilter$extension(object4, (Function1<Profile.MethodInfo, Boolean> & Serializable)x$1 -> {
            Profile.MethodInfo methodInfo = x$1;
            Profile.MethodInfo methodInfo2 = Profile$MethodInfo$.MODULE$.unapply(methodInfo);
            Symbols.Symbol symbol = methodInfo2._1();
            int n = methodInfo2._2();
            long l = methodInfo2._3();
            Symbols.Symbol meth = symbol;
            int size = n;
            long span = l;
            return true;
        }).foreach(x$1 -> {
            Profile.MethodInfo methodInfo = x$1;
            Profile.MethodInfo methodInfo2 = Profile$MethodInfo$.MODULE$.unapply(methodInfo);
            Symbols.Symbol symbol = methodInfo2._1();
            int n = methodInfo2._2();
            long l = methodInfo2._3();
            Symbols.Symbol meth = symbol;
            int size = n;
            long span = l;
            Object object = Predef$.MODULE$.refArrayOps(units$2);
            ArrayOps$.MODULE$.find$extension(object, (Function1<CompilationUnit, Boolean> & Serializable)_$10 -> _$10.source() == meth.source(x$1$5)).foreach(unit -> {
                ActiveProfile methProfile = new ActiveProfile(0);
                Contexts.FreshContext methCtx = x$1$5.fresh().setCompilationUnit((CompilationUnit)unit);
                Scanners.Scanner s = new Scanners.Scanner(meth.source(x$1$5), Spans$Span$.MODULE$.start$extension(span), methProfile, Scanners$Scanner$.MODULE$.$lessinit$greater$default$4(), methCtx);
                while (s.offset() < Spans$Span$.MODULE$.end$extension(span)) {
                    s.nextToken();
                }
                Profile.Info info = methProfile.unitProfile((CompilationUnit)unit);
                info.lineCount_$eq(info.lineCount() + 1);
                info.tastySize_$eq(size);
                AbstractFile file = meth.source(x$1$5).file();
                String header = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(new StringBuilder(7).append("%-").append(sourceNameWidth).append("s %-").append(methNameWidth).append("s").toString()), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{file.name(), meth.name(x$1$5)}));
                ActiveProfile.printInfo$1(x$1$5, layout, header, info, file.container().path());
            });
        });
    }
}

