/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.interfaces.DiagnosticRelatedInformation;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.dotc.reporting.Diagnostic$;
import dotty.tools.dotc.reporting.Message;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function0;
import scala.runtime.BoxesRunTime;

public class Diagnostic
implements dotty.tools.dotc.interfaces.Diagnostic {
    private final Message msg;
    private final dotty.tools.dotc.util.SourcePosition pos;
    private final int level;
    private boolean verbose;

    public static boolean shouldExplain(Diagnostic diagnostic, Contexts.Context context) {
        return Diagnostic$.MODULE$.shouldExplain(diagnostic, context);
    }

    public Diagnostic(Message msg, dotty.tools.dotc.util.SourcePosition pos, int level) {
        this.msg = msg;
        this.pos = pos;
        this.level = level;
        this.verbose = false;
    }

    public Message msg() {
        return this.msg;
    }

    public dotty.tools.dotc.util.SourcePosition pos() {
        return this.pos;
    }

    @Override
    public int level() {
        return this.level;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Diagnostic setVerbose() {
        this.verbose = true;
        return this;
    }

    @Override
    public Optional<SourcePosition> position() {
        if (this.pos().exists() && this.pos().source().exists()) {
            return Optional.of(this.pos());
        }
        return Optional.empty();
    }

    @Override
    public String message() {
        return this.msg().message().replaceAll("\u001b\\[[;\\d]*m", "");
    }

    @Override
    public List<DiagnosticRelatedInformation> diagnosticRelatedInformation() {
        return Collections.emptyList();
    }

    public String toString() {
        return new StringBuilder(8).append(this.getClass()).append(" at ").append(this.pos()).append(" L").append(this.pos().line() + 1).append(": ").append(this.message()).toString();
    }

    public static abstract class ConditionalWarning
    extends Warning {
        public ConditionalWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public abstract Settings.Setting<Object> enablingOption(Contexts.Context var1);

        @Override
        public boolean isSummarizedConditional(Contexts.Context x$1) {
            return !BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(this.enablingOption(x$1), x$1));
        }
    }

    public static class DeprecationWarning
    extends ConditionalWarning
    implements OriginWarning {
        private final String origin;

        public DeprecationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos, String origin) {
            super(msg, pos);
            this.origin = origin;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().deprecation();
        }
    }

    public static class Error
    extends Diagnostic {
        public Error(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 2);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Error(Function0<String> str, dotty.tools.dotc.util.SourcePosition pos) {
            this(Decorators$.MODULE$.toMessage(str), pos);
        }
    }

    public static class FeatureWarning
    extends ConditionalWarning {
        public FeatureWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().feature();
        }
    }

    public static class Info
    extends Diagnostic {
        public Info(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 0);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Info(Function0<String> str, dotty.tools.dotc.util.SourcePosition pos) {
            this(Decorators$.MODULE$.toMessage(str), pos);
        }
    }

    public static class LintWarning
    extends Warning
    implements OriginWarning {
        private final String origin;

        public LintWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos, String origin) {
            super(msg, pos);
            this.origin = origin;
        }

        @Override
        public String origin() {
            return this.origin;
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class MigrationWarning
    extends Warning {
        public MigrationWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static interface OriginWarning {
        public String origin();
    }

    public static class StickyError
    extends Error {
        public StickyError(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }
    }

    public static class UncheckedWarning
    extends ConditionalWarning {
        public UncheckedWarning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        @Override
        public Settings.Setting<Object> enablingOption(Contexts.Context x$1) {
            return x$1.settings().unchecked();
        }
    }

    public static class Warning
    extends Diagnostic {
        public Warning(Message msg, dotty.tools.dotc.util.SourcePosition pos) {
            super(msg, pos, 1);
        }

        private Message msg$accessor() {
            return super.msg();
        }

        private dotty.tools.dotc.util.SourcePosition pos$accessor() {
            return super.pos();
        }

        public Error toError() {
            Error x$proxy1 = new Error(this.msg$accessor(), this.pos$accessor());
            if (this.isVerbose()) {
                x$proxy1.setVerbose();
            }
            return x$proxy1;
        }

        public Info toInfo() {
            Info x$proxy2 = new Info(this.msg$accessor(), this.pos$accessor());
            if (this.isVerbose()) {
                x$proxy2.setVerbose();
            }
            return x$proxy2;
        }

        public boolean isSummarizedConditional(Contexts.Context x$1) {
            return false;
        }
    }
}

