/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.printing.Highlighting$Blue$;
import dotty.tools.dotc.printing.Highlighting$Red$;
import dotty.tools.dotc.printing.Highlighting$Yellow$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Diagnostic$;
import dotty.tools.dotc.reporting.ErrorMessageID;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.Highlight$;
import dotty.tools.dotc.reporting.Highlight$Level$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.MessageKind;
import dotty.tools.dotc.reporting.MessageKind$;
import dotty.tools.dotc.reporting.Offsets$;
import dotty.tools.dotc.reporting.Offsets$Offset$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyInt;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public interface MessageRendering {
    public static String stripColor$(MessageRendering $this, String str) {
        return $this.stripColor(str);
    }

    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    public static List inlinePosStack$(MessageRendering $this, SourcePosition pos) {
        return $this.inlinePosStack(pos);
    }

    default public List<SourcePosition> inlinePosStack(SourcePosition pos) {
        if (pos.outer() != null && pos.outer().exists()) {
            return this.inlinePosStack(pos.outer()).$colon$colon(pos);
        }
        return package$.MODULE$.Nil();
    }

    private Tuple3<List<String>, List<String>, Object> sourceLines(SourcePosition pos, Contexts.Context x$2, int x$3, int x$4) {
        if (!pos.exists() || !pos.source().file().exists()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        IntRef maxLen = IntRef.create(Integer.MIN_VALUE);
        Object t = Settings$Setting$.MODULE$.value(x$2.settings().color(), x$2);
        String string2 = "never";
        char[] syntax = (t == null ? string2 != null : !t.equals(string2)) && !x$2.isJava() ? SyntaxHighlighting$.MODULE$.highlight(new String(pos.linesSlice()), x$2).toCharArray() : pos.linesSlice();
        List lines = MessageRendering.linesFrom$1(syntax);
        Tuple2<List<Object>, List<Object>> tuple2 = pos.beforeAndAfterPoint();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<List<Object>, List<Object>> $1$ = tuple2;
        Tuple2<List<Object>, List<Object>> tuple22 = $1$;
        List<Object> before = tuple22._1();
        List<Object> after = tuple22._2();
        return Tuple3$.MODULE$.apply(((List)before.zip((IterableOnce)lines)).map((Function1<Tuple2, String> & Serializable)offsetAndLine -> this.render$1(pos, x$4, maxLen, x$2, x$3, (Tuple2)offsetAndLine)), ((List)after.zip((IterableOnce)lines.drop(before.length()))).map((Function1<Tuple2, String> & Serializable)offsetAndLine -> this.render$1(pos, x$4, maxLen, x$2, x$3, (Tuple2)offsetAndLine)), BoxesRunTime.boxToInteger(maxLen.elem));
    }

    private String boxTitle(String title, Contexts.Context x$2, int x$3, int x$4) {
        int pageWidth = BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$2.settings().pageWidth(), x$2));
        String line = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), pageWidth - title.length() - 4);
        return this.hl(new java.lang.StringBuilder(4).append("-- ").append(title).append(" ").append(line).toString(), x$2, x$3);
    }

    private String positionMarker(SourcePosition pos, Contexts.Context x$2, int x$3, int x$4) {
        String padding = pos.startColumnPadding();
        String carets = pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), scala.math.package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^";
        return this.hl(new java.lang.StringBuilder(0).append(this.offsetBox(x$2, x$3, x$4)).append(padding).append(carets).toString(), x$2, x$3);
    }

    private String offsetBox(Contexts.Context x$1, int x$2, int x$3) {
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$3) - 1);
        return this.hl(new java.lang.StringBuilder(1).append(prefix).append("|").toString(), x$1, x$2);
    }

    private String newBox(boolean soft, Contexts.Context x$2, int x$3, int x$4) {
        int pageWidth = BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$2.settings().pageWidth(), x$2));
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$4) - 1);
        int lineWidth = pageWidth - Offsets$.MODULE$.offset(x$4);
        String line = soft ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("- "), (lineWidth + 1) / 2).trim() : StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), lineWidth);
        return this.hl(new java.lang.StringBuilder(1).append(prefix).append("|").append(line).toString(), x$2, x$3);
    }

    private boolean newBox$default$1() {
        return false;
    }

    private String endBox(Contexts.Context x$1, int x$2, int x$3) {
        int pageWidth = BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$1.settings().pageWidth(), x$1));
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$3) - 1);
        String line = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), pageWidth - Offsets$.MODULE$.offset(x$3));
        return this.hl(new java.lang.StringBuilder(1).append(prefix).append(" ").append(line).toString(), x$1, x$2);
    }

    private String errorMsg(SourcePosition pos, String msg, Contexts.Context x$3, int x$4, int x$5) {
        String padding = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).foldLeft(pos.startColumnPadding(), (Function2<String, String, String> & Serializable)(pad, line) -> {
            int lineLength = this.stripColor((String)line).length();
            int maxPad = scala.math.package$.MODULE$.max(0, BoxesRunTime.unboxToInt(Settings$Setting$.MODULE$.value(x$3.settings().pageWidth(), x$3)) - Offsets$.MODULE$.offset(x$5) - lineLength) - Offsets$.MODULE$.offset(x$5);
            if (maxPad < pad.length()) {
                return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxPad);
            }
            return pad;
        });
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).map((Function1<String, String> & Serializable)line -> new java.lang.StringBuilder(0).append(this.offsetBox(x$3, x$4, x$5)).append(line.isEmpty() ? "" : new java.lang.StringBuilder(0).append(padding).append((String)line).toString()).toString()).mkString(System.lineSeparator());
    }

    public static String posFileStr$(MessageRendering $this, SourcePosition pos) {
        return $this.posFileStr(pos);
    }

    default public String posFileStr(SourcePosition pos) {
        String path2 = pos.source().file().path();
        if (pos.exists()) {
            return new java.lang.StringBuilder(2).append(path2).append(":").append(pos.line() + 1).append(":").append(pos.column()).toString();
        }
        return path2;
    }

    private String posStr(SourcePosition pos, Message message, String diagnosticString, Contexts.Context x$4, int x$5, int x$6) {
        if (!message.errorId().isActive()) {
            throw Scala3RunTime$.MODULE$.assertFailed(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Attempting to use an ErrorMessageID that is marked as inactive.\n         |The ID either needs to be marked as active or you need to use another.")));
        }
        SourceFile sourceFile = pos.source();
        SourceFile sourceFile2 = NoSourcePosition$.MODULE$.source();
        if (sourceFile == null ? sourceFile2 != null : !((Object)sourceFile).equals(sourceFile2)) {
            String string2;
            SourcePosition realPos = pos.nonInlined();
            String fileAndPos = this.posFileStr(realPos);
            ErrorMessageID errorMessageID = message.errorId();
            ErrorMessageID errorMessageID2 = ErrorMessageID$.NoExplanationID;
            if (errorMessageID == null ? errorMessageID2 != null : !errorMessageID.equals(errorMessageID2)) {
                int errorNumber = message.errorId().errorNumber();
                string2 = new java.lang.StringBuilder(4).append("[E").append(new java.lang.StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 3 - BoxesRunTime.boxToInteger(errorNumber).toString().length())).append(errorNumber).toString()).append("] ").toString();
            } else {
                string2 = "";
            }
            String errId = string2;
            MessageKind messageKind = message.kind();
            MessageKind messageKind2 = MessageKind$.NoKind;
            String kind = !(messageKind != null ? !messageKind.equals(messageKind2) : messageKind2 != null) ? diagnosticString : new java.lang.StringBuilder(1).append(message.kind().message()).append(" ").append(diagnosticString).toString();
            String title = fileAndPos.isEmpty() ? new java.lang.StringBuilder(1).append(errId).append(kind).append(":").toString() : new java.lang.StringBuilder(2).append(errId).append(kind).append(": ").append(fileAndPos).toString();
            return this.hl(this.boxTitle(title, x$4, x$5, x$6), x$4, x$5);
        }
        return "";
    }

    public static String explanation$(MessageRendering $this, Message m, Contexts.Context x$2) {
        return $this.explanation(m, x$2);
    }

    default public String explanation(Message m, Contexts.Context x$2) {
        StringBuilder sb = new StringBuilder(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(25).append("|\n          |").append(Highlighting$Blue$.MODULE$.apply("Explanation").show(x$2)).append("\n          |").append(Highlighting$Blue$.MODULE$.apply("===========").show(x$2)).toString())));
        sb.append(System.lineSeparator()).append(m.explanation());
        if (!m.explanation().endsWith(System.lineSeparator())) {
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private void appendFilterHelp(Diagnostic dia, StringBuilder sb, Contexts.Context x$3, int x$4, int x$5) {
        Tuple2<String, String> tuple2;
        boolean hasId = dia.msg().errorId().errorNumber() >= 0;
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.UncheckedWarning) {
            Diagnostic.UncheckedWarning uncheckedWarning = (Diagnostic.UncheckedWarning)diagnostic;
            tuple2 = Tuple2$.MODULE$.apply("unchecked", "");
        } else if (diagnostic instanceof Diagnostic.DeprecationWarning) {
            Diagnostic.DeprecationWarning deprecationWarning;
            Diagnostic.DeprecationWarning w = deprecationWarning = (Diagnostic.DeprecationWarning)diagnostic;
            tuple2 = Tuple2$.MODULE$.apply("deprecation", w.origin());
        } else if (diagnostic instanceof Diagnostic.FeatureWarning) {
            Diagnostic.FeatureWarning featureWarning = (Diagnostic.FeatureWarning)diagnostic;
            tuple2 = Tuple2$.MODULE$.apply("feature", "");
        } else {
            tuple2 = Tuple2$.MODULE$.apply("", "");
        }
        Tuple2<String, String> tuple22 = tuple2;
        String category = tuple22._1();
        String origin = tuple22._2();
        BooleanRef entitled = BooleanRef.create(false);
        if (hasId) {
            this.addHelp$1(entitled, sb, x$3, x$4, x$5, "id=E", BoxesRunTime.boxToInteger(dia.msg().errorId().errorNumber()).toString());
            this.addHelp$1(entitled, sb, x$3, x$4, x$5, "name=", StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(dia.msg().errorId().productPrefix()), "ID"));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(category))) {
            this.addHelp$1(entitled, sb, x$3, x$4, x$5, "cat=", category);
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(origin))) {
            this.addHelp$1(entitled, sb, x$3, x$4, x$5, "origin=", origin);
            return;
        }
    }

    public static String messageAndPos$(MessageRendering $this, Diagnostic dia, Contexts.Context x$2) {
        return $this.messageAndPos(dia, x$2);
    }

    default public String messageAndPos(Diagnostic dia, Contexts.Context x$2) {
        Serializable serializable;
        LazyInt lazyInt = new LazyInt();
        LazyInt lazyInt2 = new LazyInt();
        SourcePosition pos1 = dia.pos().nonInlined();
        Object inlineStack = this.inlinePosStack(dia.pos()).filter((Function1<SourcePosition, Boolean> & Serializable)_$2 -> {
            SourcePosition sourcePosition = _$2;
            SourcePosition sourcePosition2 = pos1;
            return sourcePosition == null ? sourcePosition2 != null : !((Object)sourcePosition).equals(sourcePosition2);
        });
        int maxLineNumber = dia.pos().exists() ? BoxesRunTime.unboxToInt(((AbstractIterable)((List)inlineStack).$colon$colon(pos1).map((Function1<SourcePosition, Integer> & Serializable)_$3 -> _$3.endLine())).max(Ordering$Int$.MODULE$)) + 1 : 0;
        StringBuilder sb = new StringBuilder();
        String posString = this.posStr(dia.pos(), dia.msg(), this.diagnosticLevel(dia), x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(posString))) {
            sb.append(posString).append(System.lineSeparator());
        }
        if (dia.pos().exists()) {
            SourcePosition pos12 = dia.pos().nonInlined();
            if (pos12.exists() && pos12.source().file().exists()) {
                Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines(pos12, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Tuple3<List<String>, List<String>, Object> $8$ = tuple3;
                Tuple3<List<String>, List<String>, Object> tuple32 = $8$;
                List<String> srcBefore = tuple32._1();
                List<String> srcAfter = tuple32._2();
                int offset = BoxesRunTime.unboxToInt(tuple32._3());
                String marker = this.positionMarker(pos12, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
                String err = this.errorMsg(pos12, dia.msg().message(), x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
                sb.append(srcAfter.$colon$colon(err).$colon$colon(marker).$colon$colon$colon(srcBefore).mkString(System.lineSeparator()));
                if (((AbstractIterable)inlineStack).nonEmpty()) {
                    sb.append(System.lineSeparator()).append(this.newBox(this.newBox$default$1(), x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
                    sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber))).append(Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"Inline stack trace"})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[0]), x$2));
                    ((AbstractIterable)inlineStack).withFilter((Function1<SourcePosition, Boolean> & Serializable)inlinedPos -> {
                        SourcePosition sourcePosition = inlinedPos;
                        SourcePosition sourcePosition2 = pos12;
                        return sourcePosition == null ? sourcePosition2 != null : !((Object)sourcePosition).equals(sourcePosition2);
                    }).foreach(inlinedPos -> {
                        sb.append(System.lineSeparator()).append(this.newBox(true, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
                        sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber))).append(Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"This location contains code that was inlined from ", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_Showable()).apply(dia.pos())}), x$2));
                        if (inlinedPos.source().file().exists()) {
                            Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines((SourcePosition)inlinedPos, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            Tuple3<List<String>, List<String>, Object> $10$ = tuple3;
                            Tuple3<List<String>, List<String>, Object> tuple32 = $10$;
                            List<String> srcBefore = tuple32._1();
                            List<String> srcAfter = tuple32._2();
                            String marker = this.positionMarker((SourcePosition)inlinedPos, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
                            sb.append(System.lineSeparator()).append(srcAfter.$colon$colon(marker).$colon$colon$colon(srcBefore).mkString(System.lineSeparator()));
                            return;
                        }
                    });
                    sb.append(System.lineSeparator()).append(this.endBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
                    serializable = BoxedUnit.UNIT;
                } else {
                    serializable = BoxedUnit.UNIT;
                }
            } else {
                serializable = sb.append(dia.msg().message());
            }
        } else {
            serializable = sb.append(dia.msg().message());
        }
        if (dia.isVerbose()) {
            this.appendFilterHelp(dia, sb, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber));
        }
        if (Diagnostic$.MODULE$.shouldExplain(dia, x$2)) {
            sb.append(System.lineSeparator()).append(this.newBox(this.newBox$default$1(), x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber))).append(" Explanation (enabled by `-explain`)");
            sb.append(System.lineSeparator()).append(this.newBox(true, x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
            Object object = Predef$.MODULE$.refArrayOps(dia.msg().explanation().split("\\R"));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1<String, StringBuilder> & Serializable)line -> sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber))).append(line.isEmpty() ? "" : " ").append((String)line));
            sb.append(System.lineSeparator()).append(this.endBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
        } else if (dia.msg().canExplain()) {
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber)));
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(lazyInt, dia), MessageRendering.given_Offset$1(lazyInt2, maxLineNumber))).append(" longer explanation available when compiling with `-explain`");
        }
        return sb.toString();
    }

    private String hl(String str, Contexts.Context x$2, int x$3) {
        int n = Highlight$.MODULE$.value(x$3);
        switch (n) {
            case 2: {
                return Highlighting$Red$.MODULE$.apply(str).show(x$2);
            }
            case 1: {
                return Highlighting$Yellow$.MODULE$.apply(str).show(x$2);
            }
            case 0: {
                return Highlighting$Blue$.MODULE$.apply(str).show(x$2);
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    private String diagnosticLevel(Diagnostic dia) {
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.FeatureWarning) {
            Diagnostic.FeatureWarning featureWarning;
            Diagnostic.FeatureWarning dia2 = featureWarning = (Diagnostic.FeatureWarning)diagnostic;
            return "Feature Warning";
        }
        if (diagnostic instanceof Diagnostic.DeprecationWarning) {
            Diagnostic.DeprecationWarning deprecationWarning;
            Diagnostic.DeprecationWarning dia3 = deprecationWarning = (Diagnostic.DeprecationWarning)diagnostic;
            return "Deprecation Warning";
        }
        if (diagnostic instanceof Diagnostic.UncheckedWarning) {
            Diagnostic.UncheckedWarning uncheckedWarning;
            Diagnostic.UncheckedWarning dia4 = uncheckedWarning = (Diagnostic.UncheckedWarning)diagnostic;
            return "Unchecked Warning";
        }
        if (diagnostic instanceof Diagnostic.MigrationWarning) {
            Diagnostic.MigrationWarning migrationWarning;
            Diagnostic.MigrationWarning dia5 = migrationWarning = (Diagnostic.MigrationWarning)diagnostic;
            return "Migration Warning";
        }
        int n = dia.level();
        switch (n) {
            case 2: {
                return "Error";
            }
            case 1: {
                return "Warning";
            }
            case 0: {
                return "Info";
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    private String render$1(SourcePosition pos$1, int x$4$1, IntRef maxLen$1, Contexts.Context x$2$1, int x$3$1, Tuple2 offsetAndLine) {
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 $3$ = tuple2;
        Tuple2 tuple22 = $3$;
        int offset1 = BoxesRunTime.unboxToInt(tuple22._1());
        String line = (String)tuple22._2();
        String lineNbr = BoxesRunTime.boxToInteger(pos$1.source().offsetToLine(offset1) + 1).toString();
        String prefix = String.format(new java.lang.StringBuilder(4).append("%").append(Offsets$.MODULE$.offset(x$4$1) - 2).append("s |").toString(), lineNbr);
        maxLen$1.elem = scala.math.package$.MODULE$.max(maxLen$1.elem, prefix.length());
        String lnum = this.hl(new java.lang.StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), scala.math.package$.MODULE$.max(0, maxLen$1.elem - prefix.length() - 1))).append(prefix).toString(), x$2$1, x$3$1);
        return new java.lang.StringBuilder(0).append(lnum).append(StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line))).toString();
    }

    private static boolean pred$1(char c) {
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean $anonfun$1(char _$1) {
        return !MessageRendering.pred$1(_$1);
    }

    private static List linesFrom$1(char[] arr) {
        Object object = Predef$.MODULE$.charArrayOps(arr);
        Tuple2<Object, Object> tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1<Object, Boolean> & Serializable)_$1 -> MessageRendering.$anonfun$1(BoxesRunTime.unboxToChar(_$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2<Object, Object> $5$ = tuple2;
        Tuple2<Object, Object> tuple22 = $5$;
        char[] line = (char[])tuple22._1();
        char[] rest0 = (char[])tuple22._2();
        Object object2 = Predef$.MODULE$.charArrayOps(rest0);
        Tuple2<Object, Object> tuple23 = ArrayOps$.MODULE$.span$extension(object2, (Function1<Object, Boolean> & Serializable)c -> MessageRendering.pred$1(BoxesRunTime.unboxToChar(c)));
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        char[] rest = (char[])tuple23._2();
        char[] rest2 = rest;
        String string2 = new String(line);
        Object object3 = Predef$.MODULE$.charArrayOps(rest2);
        return (ArrayOps$.MODULE$.isEmpty$extension(object3) ? package$.MODULE$.Nil() : MessageRendering.linesFrom$1(rest2)).$colon$colon(string2);
    }

    private StringBuilder nl$1(Contexts.Context x$3$4, int x$4$3, int x$5$3, StringBuilder sb) {
        return sb.append(System.lineSeparator()).append(this.offsetBox(x$3$4, x$4$3, x$5$3));
    }

    private void addHelp$1(BooleanRef entitled$1, StringBuilder sb$1, Contexts.Context x$3$5, int x$4$4, int x$5$4, String what, String value) {
        if (!entitled$1.elem) {
            this.nl$1(x$3$5, x$4$4, x$5$4, sb$1).append("Matching filters for @nowarn or -Wconf:");
            entitled$1.elem = true;
        }
        this.nl$1(x$3$5, x$4$4, x$5$4, sb$1).append("  - ").append(what).append(value);
    }

    private static int given_Level$lzyINIT1$1(LazyInt given_Level$lzy1$1, Diagnostic dia$1) {
        int n;
        LazyInt lazyInt = given_Level$lzy1$1;
        synchronized (lazyInt) {
            n = given_Level$lzy1$1.initialized() ? given_Level$lzy1$1.value() : given_Level$lzy1$1.initialize(Highlight$Level$.MODULE$.apply(dia$1.level()));
        }
        return n;
    }

    private static int given_Level$1(LazyInt given_Level$lzy1$2, Diagnostic dia$2) {
        if (given_Level$lzy1$2.initialized()) {
            return given_Level$lzy1$2.value();
        }
        return MessageRendering.given_Level$lzyINIT1$1(given_Level$lzy1$2, dia$2);
    }

    private static int given_Offset$lzyINIT1$1(LazyInt given_Offset$lzy1$1, int maxLineNumber$1) {
        int n;
        LazyInt lazyInt = given_Offset$lzy1$1;
        synchronized (lazyInt) {
            n = given_Offset$lzy1$1.initialized() ? given_Offset$lzy1$1.value() : given_Offset$lzy1$1.initialize(Offsets$Offset$.MODULE$.apply(BoxesRunTime.boxToInteger(maxLineNumber$1).toString().length() + 2));
        }
        return n;
    }

    private static int given_Offset$1(LazyInt given_Offset$lzy1$2, int maxLineNumber$2) {
        if (given_Offset$lzy1$2.initialized()) {
            return given_Offset$lzy1$2.value();
        }
        return MessageRendering.given_Offset$lzyINIT1$1(given_Offset$lzy1$2, maxLineNumber$2);
    }
}

