/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.Run;
import dotty.tools.dotc.Run$suppressions$;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Mode$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$NoSymbol$;
import dotty.tools.dotc.core.handleRecursive$;
import dotty.tools.dotc.interfaces.ReporterResult;
import dotty.tools.dotc.interfaces.SimpleReporter;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.Action;
import dotty.tools.dotc.reporting.Action$;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.NoExplanation;
import dotty.tools.dotc.reporting.Reporter$;
import dotty.tools.dotc.reporting.WConf$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourcePosition;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class Reporter
implements ReporterResult {
    private boolean _truncationOK = true;
    private Function2<Diagnostic, Contexts.Context, BoxedUnit> incompleteHandler = Reporter$.dotty$tools$dotc$reporting$Reporter$$$defaultIncompleteHandler;
    private int _errorCount = 0;
    private int _warningCount = 0;
    private int _infoCount = 0;
    private List<Diagnostic.Error> errors = package$.MODULE$.Nil();
    private List<Diagnostic.Warning> warnings = package$.MODULE$.Nil();
    private List<Diagnostic.Info> infos = package$.MODULE$.Nil();
    private Set<Symbols.Symbol> reportedFeaturesUseSites = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Symbols.Symbol[0]));
    private Map<String, Object> unreportedWarnings = Predef$.MODULE$.Map().empty();

    public static void displayPrompt(BufferedReader bufferedReader, PrintWriter printWriter) {
        Reporter$.MODULE$.displayPrompt(bufferedReader, printWriter);
    }

    public static Reporter fromSimpleReporter(SimpleReporter simpleReporter) {
        return Reporter$.MODULE$.fromSimpleReporter(simpleReporter);
    }

    public abstract void doReport(Diagnostic var1, Contexts.Context var2);

    public boolean truncationOK() {
        return this._truncationOK;
    }

    public <T> T withoutTruncating(Function0<T> body) {
        T t;
        boolean saved = this._truncationOK;
        this._truncationOK = false;
        try {
            t = body.apply();
        }
        finally {
            this._truncationOK = saved;
        }
        return t;
    }

    public <T> T withIncompleteHandler(Function2<Diagnostic, Contexts.Context, BoxedUnit> handler, Function0<T> op) {
        T t;
        Function2<Diagnostic, Contexts.Context, BoxedUnit> saved = this.incompleteHandler;
        this.incompleteHandler = handler;
        try {
            t = op.apply();
        }
        finally {
            this.incompleteHandler = saved;
        }
        return t;
    }

    private boolean isIncompleteChecking() {
        return this.incompleteHandler != Reporter$.dotty$tools$dotc$reporting$Reporter$$$defaultIncompleteHandler;
    }

    @Override
    public int errorCount() {
        return this._errorCount;
    }

    @Override
    public int warningCount() {
        return this._warningCount;
    }

    @Override
    public boolean hasErrors() {
        return this.errorCount() > 0;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningCount() > 0;
    }

    public List<Diagnostic.Error> allErrors() {
        return this.errors;
    }

    public List<Diagnostic.Warning> allWarnings() {
        return this.warnings;
    }

    public List<Diagnostic.Info> allInfos() {
        return this.infos;
    }

    public boolean hasStickyErrors() {
        return false;
    }

    public boolean errorsReported() {
        return this.hasErrors();
    }

    public boolean reportsErrorsFor(Function1<Contexts.Context, BoxedUnit> op, Contexts.Context x$2) {
        int initial = this.errorCount();
        op.apply(x$2);
        return this.errorCount() > initial;
    }

    public boolean isReportedFeatureUseSite(Symbols.Symbol featureTrait) {
        return featureTrait != Symbols$NoSymbol$.MODULE$ && this.reportedFeaturesUseSites.contains(featureTrait);
    }

    public void reportNewFeatureUseSite(Symbols.Symbol featureTrait) {
        this.reportedFeaturesUseSites = (Set)this.reportedFeaturesUseSites.$plus(featureTrait);
    }

    public Map<String, Object> unreportedWarnings() {
        return this.unreportedWarnings;
    }

    public void unreportedWarnings_$eq(Map<String, Object> x$1) {
        this.unreportedWarnings = x$1;
    }

    public void addUnreported(String key, int n) {
        int count = BoxesRunTime.unboxToInt(this.unreportedWarnings().getOrElse(key, Reporter::$anonfun$1));
        this.unreportedWarnings_$eq((Map)this.unreportedWarnings().updated(key, BoxesRunTime.boxToInteger(count + n)));
    }

    public void issueUnconfigured(Diagnostic dia, Contexts.Context x$2) {
        Diagnostic.ConditionalWarning conditionalWarning;
        Diagnostic.ConditionalWarning w;
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.Warning) {
            Diagnostic.Warning warning;
            Diagnostic.Warning w2 = warning = (Diagnostic.Warning)diagnostic;
            if (BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$2.settings().silentWarnings(), x$2))) {
                return;
            }
        }
        if (diagnostic instanceof Diagnostic.ConditionalWarning && (w = (conditionalWarning = (Diagnostic.ConditionalWarning)diagnostic)).isSummarizedConditional(x$2)) {
            String key = w.enablingOption(x$2).name();
            this.addUnreported(key, 1);
            return;
        }
        if (!this.isHidden(dia, x$2)) {
            try {
                int mode$proxy1 = Mode$.MODULE$.$bar$extension(x$2.mode(), Mode$.MODULE$.Printing());
                Contexts.Context context = Mode$.MODULE$.$bang$eq$extension(mode$proxy1, x$2.mode()) ? x$2.fresh().setMode(mode$proxy1) : x$2;
                this.doReport(dia, context);
            }
            catch (Throwable ex) {
                throw handleRecursive$.MODULE$.apply("error reporting", () -> Reporter.issueUnconfigured$$anonfun$1(dia), ex, handleRecursive$.MODULE$.apply$default$4(), x$2);
            }
            Diagnostic diagnostic2 = dia;
            if (diagnostic2 instanceof Diagnostic.Warning) {
                Diagnostic.Warning warning;
                Diagnostic.Warning w3 = warning = (Diagnostic.Warning)diagnostic2;
                this.warnings = this.warnings.$colon$colon(w3);
                ++this._warningCount;
            } else if (diagnostic2 instanceof Diagnostic.Error) {
                Diagnostic.Error error;
                Diagnostic.Error e = error = (Diagnostic.Error)diagnostic2;
                this.errors = this.errors.$colon$colon(e);
                ++this._errorCount;
                if (x$2.typerState().isGlobalCommittable()) {
                    x$2.base().errorsToBeReported_$eq(true);
                }
            } else if (diagnostic2 instanceof Diagnostic.Info) {
                Diagnostic.Info info;
                Diagnostic.Info i = info = (Diagnostic.Info)diagnostic2;
                this.infos = this.infos.$colon$colon(i);
                ++this._infoCount;
            } else {
                throw new MatchError(diagnostic2);
            }
            this.markReported(dia, x$2);
            return;
        }
    }

    public void issueIfNotSuppressed(Diagnostic dia, Contexts.Context x$2) {
        Run run = x$2.run();
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.Warning) {
            Diagnostic.Warning warning;
            Diagnostic.Warning w = warning = (Diagnostic.Warning)diagnostic;
            if (run != null) {
                Run$suppressions$ sup = run.suppressions();
                if (sup.suppressionsComplete(w.pos().source())) {
                    Action action = sup.nowarnAction(w);
                    Action action2 = Action$.Warning;
                    Action action3 = action;
                    if (!(action2 != null ? !action2.equals(action3) : action3 != null)) {
                        this.go$1(dia, x$2);
                        return;
                    }
                    Action action4 = Action$.Verbose;
                    Action action5 = action;
                    if (!(action4 != null ? !action4.equals(action5) : action5 != null)) {
                        w.setVerbose();
                        this.go$1(dia, x$2);
                        return;
                    }
                    Action action6 = Action$.Silent;
                    Action action7 = action;
                    if (!(action6 != null ? !action6.equals(action7) : action7 != null)) {
                        return;
                    }
                    throw new MatchError(action);
                }
                if (!this.isIncompleteChecking()) {
                    sup.addSuspendedMessage(w);
                    return;
                }
                return;
            }
        }
        this.go$1(dia, x$2);
    }

    public void report(Diagnostic dia, Contexts.Context x$2) {
        this.issueIfNotSuppressed(dia, x$2);
    }

    public void incomplete(Diagnostic dia, Contexts.Context x$2) {
        this.incompleteHandler.apply(dia, x$2);
    }

    public void finalizeReporting(Contexts.Context x$1) {
        if (this.hasWarnings() && BoxesRunTime.unboxToBoolean(Settings$Setting$.MODULE$.value(x$1.settings().Werror(), x$1))) {
            this.report(new Diagnostic.Error(Reporter::finalizeReporting$$anonfun$1, (SourcePosition)NoSourcePosition$.MODULE$), x$1);
            return;
        }
    }

    public String summary() {
        ListBuffer<String> b = new ListBuffer<String>();
        if (this.warningCount() > 0) {
            b.$plus$eq(new StringBuilder(6).append(this.countString(this.warningCount(), "warning")).append(" found").toString());
        }
        if (this.errorCount() > 0) {
            b.$plus$eq(new StringBuilder(6).append(this.countString(this.errorCount(), "error")).append(" found").toString());
        }
        return b.mkString("\n");
    }

    public void summarizeUnreportedWarnings(Contexts.Context x$12) {
        this.unreportedWarnings().withFilter((Function1<Tuple2<String, Object>, Object>)(Function1<Tuple2, Boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String settingName = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt(tuple2._2());
                return true;
            }
            return false;
        }).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String settingName = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt(tuple2._2());
                String were = count == 1 ? "was" : "were";
                NoExplanation msg = Decorators$.MODULE$.em(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"there ", " ", "; re-run with ", " for details"})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(were), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(this.countString(count, new StringBuilder(8).append(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(settingName))).append(" warning").toString())), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(settingName)}), x$12);
                this.report(new Diagnostic.Warning(msg, NoSourcePosition$.MODULE$), x$12);
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public void printSummary(Contexts.Context x$1) {
        String s;
        String string2 = s = this.summary();
        String string3 = "";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            this.doReport(new Diagnostic.Warning(Decorators$.MODULE$.toMessage(() -> Reporter.printSummary$$anonfun$1(s)), NoSourcePosition$.MODULE$), x$1);
            return;
        }
    }

    public String countString(int n, String elements) {
        int n2 = n;
        if (0 == n2) {
            return new StringBuilder(4).append("no ").append(elements).append("s").toString();
        }
        if (1 == n2) {
            return new StringBuilder(2).append("1 ").append(elements).toString();
        }
        return new StringBuilder(2).append(n).append(" ").append(elements).append("s").toString();
    }

    public boolean isHidden(Diagnostic dia, Contexts.Context x$2) {
        return Mode$.MODULE$.is$extension(x$2.mode(), Mode$.MODULE$.Printing());
    }

    public void markReported(Diagnostic dia, Contexts.Context x$2) {
    }

    public boolean hasUnreportedErrors() {
        return false;
    }

    public boolean hasUnreportedMessages(Contexts.Context x$1) {
        return this.pendingMessages(x$1).nonEmpty() || this.unreportedWarnings().nonEmpty();
    }

    public List<Diagnostic> removeBufferedMessages(Contexts.Context x$1) {
        return package$.MODULE$.Nil();
    }

    public void mapBufferedMessages(Function1<Diagnostic, Diagnostic> f, Contexts.Context x$2) {
    }

    public void flush(Contexts.Context x$12) {
        List<Diagnostic> msgs = this.removeBufferedMessages(x$12);
        if (msgs.nonEmpty()) {
            Reporter reporter = x$12.reporter();
            msgs.foreach(dia -> reporter.report((Diagnostic)dia, x$12));
        }
        this.unreportedWarnings().withFilter((Function1<Tuple2<String, Object>, Object>)(Function1<Tuple2, Boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt(tuple2._2());
                return true;
            }
            return false;
        }).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                int count = BoxesRunTime.unboxToInt(tuple2._2());
                x$12.reporter().addUnreported(key, count);
                return;
            }
            throw new MatchError(tuple2);
        });
        this.unreportedWarnings_$eq((Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public List<Diagnostic> pendingMessages(Contexts.Context x$1) {
        return package$.MODULE$.Nil();
    }

    private static final int $anonfun$1() {
        return 0;
    }

    private static final String issueUnconfigured$$anonfun$1(Diagnostic dia$1) {
        return dia$1.message();
    }

    private final void go$1(Diagnostic dia$2, Contexts.Context x$2$1) {
        Diagnostic diagnostic = dia$2;
        if (diagnostic instanceof Diagnostic.Warning) {
            Diagnostic.Warning warning;
            Diagnostic.Warning w = warning = (Diagnostic.Warning)diagnostic;
            Action action = WConf$.MODULE$.parsed(x$2$1).action(dia$2);
            Action action2 = Action$.Error;
            Action action3 = action;
            if (!(action2 != null ? !action2.equals(action3) : action3 != null)) {
                this.issueUnconfigured(w.toError(), x$2$1);
                return;
            }
            Action action4 = Action$.Warning;
            Action action5 = action;
            if (!(action4 != null ? !action4.equals(action5) : action5 != null)) {
                this.issueUnconfigured(w, x$2$1);
                return;
            }
            Action action6 = Action$.Verbose;
            Action action7 = action;
            if (!(action6 != null ? !action6.equals(action7) : action7 != null)) {
                this.issueUnconfigured(w.setVerbose(), x$2$1);
                return;
            }
            Action action8 = Action$.Info;
            Action action9 = action;
            if (!(action8 != null ? !action8.equals(action9) : action9 != null)) {
                this.issueUnconfigured(w.toInfo(), x$2$1);
                return;
            }
            Action action10 = Action$.Silent;
            Action action11 = action;
            if (!(action10 != null ? !action10.equals(action11) : action11 != null)) {
                return;
            }
            throw new MatchError(action);
        }
        this.issueUnconfigured(dia$2, x$2$1);
    }

    private static final String finalizeReporting$$anonfun$1() {
        return "No warnings can be incurred under -Werror (or -Xfatal-warnings)";
    }

    private static final String printSummary$$anonfun$1(String s$1) {
        return s$1;
    }
}

