/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform.init;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class Trace$
implements Serializable {
    private static final Vector<Trees.Tree<Types.Type>> empty;
    private static final String EMPTY_PADDING;
    private static final String CONNECTING_INDENT;
    private static final String CHILD;
    private static final String LAST_CHILD;
    public static final Trace$ MODULE$;

    private Trace$() {
    }

    static {
        MODULE$ = new Trace$();
        empty = scala.package$.MODULE$.Vector().empty();
        EMPTY_PADDING = "    ";
        CONNECTING_INDENT = "\u2502   ";
        CHILD = "\u251c\u2500\u2500 ";
        LAST_CHILD = "\u2514\u2500\u2500 ";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Trace$.class);
    }

    public Vector<Trees.Tree<Types.Type>> empty() {
        return empty;
    }

    public String EMPTY_PADDING() {
        return EMPTY_PADDING;
    }

    public String CONNECTING_INDENT() {
        return CONNECTING_INDENT;
    }

    public String CHILD() {
        return CHILD;
    }

    public String LAST_CHILD() {
        return LAST_CHILD;
    }

    public Vector<Trees.Tree<Types.Type>> add(Vector<Trees.Tree<Types.Type>> trace2, Trees.Tree<Types.Type> node) {
        return (Vector)trace2.$colon$plus(node);
    }

    public Vector<Trees.Tree<Types.Type>> toVector(Vector<Trees.Tree<Types.Type>> trace2) {
        return trace2;
    }

    public Vector<Trees.Tree<Types.Type>> $plus$plus(Vector<Trees.Tree<Types.Type>> trace2, Vector<Trees.Tree<Types.Type>> trace22) {
        return (Vector)trace2.$plus$plus(trace22);
    }

    public String show(Vector<Trees.Tree<Types.Type>> trace2, Contexts.Context ctx) {
        return this.buildStacktrace(trace2, new StringBuilder(14).append("Calling trace:").append(System.lineSeparator()).toString(), ctx);
    }

    public Trees.Tree<Types.Type> position(Vector<Trees.Tree<Types.Type>> trace2) {
        return trace2.last();
    }

    public Vector<Trees.Tree<Types.Type>> trace(Vector<Trees.Tree<Types.Type>> t) {
        return t;
    }

    public String buildStacktrace(Vector<Trees.Tree<Types.Type>> trace2, String preamble, Contexts.Context x$3) {
        if (trace2.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(0).append(preamble);
        IntRef lastLineNum = IntRef.create(-1);
        ObjectRef lines = ObjectRef.create(new ArrayBuffer());
        trace2.foreach(tree -> {
            String positionMarkerLine;
            String line;
            String string2;
            boolean isLastTraceItem = tree == trace2.last();
            SourcePosition pos = tree.sourcePos(x$3);
            if (pos.source().exists()) {
                String loc = new StringBuilder(5).append("[ ").append(pos.source().file().name()).append(":").append(pos.line() + 1).append(" ]").toString();
                String code = SyntaxHighlighting$.MODULE$.highlight(pos.lineContent().trim(), x$3);
                string2 = Decorators$.MODULE$.i(StringContext$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{"", "\\t", ""})), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(code), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply(loc)}), x$3);
            } else {
                Trees.Tree tree2 = tree;
                if (tree2 instanceof Trees.DefTree) {
                    Trees.DefTree defTree;
                    Trees.DefTree defDef = defTree = (Trees.DefTree)((Object)tree2);
                    string2 = ((Trees.Tree)((Object)defDef)).symbol(x$3).showFullName(x$3);
                } else {
                    Object object = Predef$.MODULE$.refArrayOps(tree.show(x$3).split(System.lineSeparator(), 2));
                    string2 = line = (String)ArrayOps$.MODULE$.head$extension(object);
                }
            }
            String string3 = pos.exists() && pos.source().exists() ? new StringBuilder(0).append(isLastTraceItem ? MODULE$.EMPTY_PADDING() : MODULE$.CONNECTING_INDENT()).append(MODULE$.positionMarker(pos)).toString() : (positionMarkerLine = "");
            if (lastLineNum$1.elem >= 0 && lastLineNum$1.elem == pos.line()) {
                ((ArrayBuffer)lines$1.elem).dropRightInPlace(1);
            }
            String prefix = isLastTraceItem ? MODULE$.LAST_CHILD() : MODULE$.CHILD();
            ((ArrayBuffer)lines$1.elem).$plus$eq(new StringBuilder(0).append(prefix).append(line).append(System.lineSeparator()).append(positionMarkerLine).toString());
            lastLineNum$1.elem = pos.line();
        });
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        ((ArrayBuffer)lines.elem).foreach((Function1<String, scala.collection.mutable.StringBuilder> & Serializable)line -> sb.append((String)line));
        return stringBuilder.append(sb.toString()).toString();
    }

    private String positionMarker(SourcePosition pos) {
        int trimmed = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(pos.source().lineContent(pos.start())), (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)c -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(c)))).length();
        String padding = pos.startColumnPadding().substring(trimmed);
        String carets = pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^";
        return new StringBuilder(0).append(padding).append(carets).append(System.lineSeparator()).toString();
    }
}

