/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.util;

import dotty.tools.dotc.util.GenericHashSet$;
import dotty.tools.dotc.util.MutableSet;
import java.util.Arrays;
import scala.Array$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public abstract class GenericHashSet<T>
extends MutableSet<T> {
    private final int initialCapacity;
    private final int capacityMultiple;
    private int used;
    private int limit;
    private Object[] table;

    public static <T> int $lessinit$greater$default$1() {
        return GenericHashSet$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int $lessinit$greater$default$2() {
        return GenericHashSet$.MODULE$.$lessinit$greater$default$2();
    }

    public GenericHashSet(int initialCapacity, int capacityMultiple) {
        this.initialCapacity = initialCapacity;
        this.capacityMultiple = capacityMultiple;
        this.clear(this.clear$default$1());
    }

    public int used() {
        return this.used;
    }

    public void used_$eq(int x$1) {
        this.used = x$1;
    }

    public int limit() {
        return this.limit;
    }

    public void limit_$eq(int x$1) {
        this.limit = x$1;
    }

    public Object[] table() {
        return this.table;
    }

    public void table_$eq(Object[] x$1) {
        this.table = x$1;
    }

    private void allocate(int capacity) {
        this.table_$eq(new Object[capacity]);
        this.limit_$eq(capacity <= 8 ? capacity - 1 : capacity / this.capacityMultiple);
    }

    private int roundToPower(int n) {
        if (n < 4) {
            return 4;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    @Override
    public void clear(boolean resetToInitial) {
        this.used_$eq(0);
        if (resetToInitial) {
            this.allocate(this.roundToPower(this.initialCapacity));
            return;
        }
        Arrays.fill(this.table(), null);
    }

    @Override
    public int size() {
        return this.used();
    }

    public boolean isDense() {
        return this.limit() < 8;
    }

    public abstract int hash(T var1);

    public abstract boolean isEqual(T var1, T var2);

    private int index(int x) {
        return x & this.table().length - 1;
    }

    public Object[] currentTable() {
        return this.table();
    }

    private int firstIndex(T x) {
        if (this.isDense()) {
            return 0;
        }
        return this.index(this.hash(x));
    }

    private int nextIndex(int idx) {
        return this.index(idx + 1);
    }

    public Object dotty$tools$dotc$util$GenericHashSet$$entryAt(int idx) {
        return this.table()[idx];
    }

    private void setEntry(int idx, T x) {
        this.table()[idx] = x;
    }

    @Override
    public Object lookup(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy1 = e;
            if (this.isEqual(x$proxy1, x)) {
                return e;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return null;
    }

    private T addEntryAt(int idx, T x) {
        this.setEntry(idx, x);
        this.used_$eq(this.used() + 1);
        if (this.used() > this.limit()) {
            this.growTable();
        }
        return x;
    }

    @Override
    public boolean add(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy2 = e;
            if (this.isEqual(x$proxy2, x)) {
                return false;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        this.addEntryAt(idx, x);
        return true;
    }

    @Override
    public T put(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy3 = e;
            if (this.isEqual(x$proxy3, x)) {
                Object x$proxy4 = e;
                return (T)x$proxy4;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return this.addEntryAt(idx, x);
    }

    @Override
    public void $plus$eq(T x) {
        this.put(x);
    }

    public boolean remove(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            Object x$proxy5 = e;
            if (this.isEqual(x$proxy5, x)) {
                int hole = idx;
                while ((e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx = this.nextIndex(idx))) != null) {
                    Object x$proxy6 = e;
                    int eidx = this.index(this.hash(x$proxy6));
                    if (!this.isDense() && this.index(eidx - (hole + 1)) <= this.index(idx - (hole + 1))) continue;
                    Object x$proxy7 = e;
                    this.setEntry(hole, x$proxy7);
                    hole = idx;
                }
                this.table()[hole] = null;
                this.used_$eq(this.used() - 1);
                return true;
            }
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        return false;
    }

    @Override
    public void $minus$eq(T x) {
        this.remove(x);
    }

    private void addOld(T x) {
        int idx = this.firstIndex(x);
        Object e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        while (e != null) {
            idx = this.nextIndex(idx);
            e = this.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
        }
        this.setEntry(idx, x);
    }

    public void copyFrom(Object[] oldTable) {
        if (this.isDense()) {
            Array$.MODULE$.copy(oldTable, 0, this.table(), 0, oldTable.length);
            return;
        }
        for (int idx = 0; idx < oldTable.length; ++idx) {
            Object e = oldTable[idx];
            if (e == null) continue;
            Object x$proxy8 = e;
            this.addOld(x$proxy8);
        }
    }

    public void growTable() {
        Object[] oldTable = this.table();
        int newLength = oldTable.length == 8 ? 16 * this.roundToPower(this.capacityMultiple) : this.table().length * 2;
        this.allocate(newLength);
        this.copyFrom(oldTable);
    }

    @Override
    public Iterator<T> iterator() {
        return new EntryIterator(this){
            private final /* synthetic */ GenericHashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object entry(int idx) {
                return this.$outer.dotty$tools$dotc$util$GenericHashSet$$entryAt(idx);
            }
        };
    }

    public String toString() {
        return this.iterator().mkString("HashSet(", ", ", ")");
    }

    public String statsItem(String op) {
        String prefix = this.isDense() ? "HashSet(dense)." : "HashSet.";
        String suffix = this.getClass().getSimpleName();
        return new StringBuilder(1).append(prefix).append(op).append(" ").append(suffix).toString();
    }

    public abstract class EntryIterator
    implements Iterator<T> {
        private int idx;

        public EntryIterator() {
            if (GenericHashSet.this == null) {
                throw new NullPointerException();
            }
            IterableOnce.$init$(this);
            IterableOnceOps.$init$(this);
            Iterator.$init$(this);
            this.idx = 0;
        }

        public abstract Object entry(int var1);

        @Override
        public boolean hasNext() {
            while (this.idx < GenericHashSet.this.table().length && GenericHashSet.this.table()[this.idx] == null) {
                ++this.idx;
            }
            return this.idx < GenericHashSet.this.table().length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void v0;
            Predef$.MODULE$.require(this.hasNext());
            try {
                void var1_1;
                Object x$proxy9 = this.entry(this.idx);
                v0 = var1_1;
            }
            finally {
                ++this.idx;
            }
            return v0;
        }

        public final /* synthetic */ GenericHashSet dotty$tools$dotc$util$GenericHashSet$EntryIterator$$$outer() {
            return GenericHashSet.this;
        }
    }
}

